/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol;

import jeus.servlet.connector.Constants;
import jeus.servlet.connector.protocol.AbstractMessage;
import jeus.servlet.connector.protocol.FileMessage;
import jeus.servlet.connector.protocol.Message;
import jeus.servlet.connector.protocol.SimpleMessage;
import jeus.util.logging.JeusLogger;

public class MessageFactory {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");

    public static Message createMessage(int initSize) throws Exception {
        return MessageFactory.createMessage(initSize, null, null);
    }

    public static Message createMessage(int initSize, String prefix, String suffix) throws Exception {
        AbstractMessage message = null;
        if (initSize == -1) {
            message = new SimpleMessage();
        } else if (initSize >= Constants.FILE_PERSISTENT_MESSAGE_LOWER_BOUND) {
            if (prefix == null || prefix.length() < 3) {
                prefix = "servletmsg";
            }
            if (suffix == null) {
                suffix = ".tmp";
            }
            message = new FileMessage(initSize, prefix, suffix, Constants.FILE_PERSISTENT_MESSAGE_TEMP_DIRECTORY);
        } else {
            message = new SimpleMessage(initSize);
        }
        message.initialize();
        return message;
    }
}

