/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jeus.servlet.connector.protocol.AbstractMessage;
import jeus.util.message.JeusMessage_WebContainer10;

public class SimpleMessage
extends AbstractMessage {
    private byte[] message;
    private ByteArrayInputStream byteArrayInput;
    private int messageOffset;
    private boolean complete;

    public SimpleMessage() {
        this(-1);
    }

    public SimpleMessage(int contentLength) {
        this.setMessageType(1);
        this.setContentLength(contentLength);
    }

    public void initialize() throws Exception {
        this.complete = false;
        int contentLength = this.getContentLength();
        if (contentLength == -1) {
            this.message = null;
            this.messageOffset = 0;
        } else if (this.message == null) {
            this.message = new byte[contentLength];
            this.messageOffset = 0;
        }
    }

    public void destroy() {
        super.destroy();
        this.complete = false;
        this.message = null;
        this.messageOffset = 0;
    }

    public byte[] getMessage() {
        int contentLength = this.getContentLength();
        if (contentLength == -1 || this.message == null) {
            return null;
        }
        this.checkContentLength(this.messageOffset);
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.complete = true;
        if (message == null) {
            this.message = null;
            this.setContentLength(-1);
            this.messageOffset = 0;
            return;
        }
        this.message = message;
        this.setContentLength(message.length);
        this.messageOffset = message.length;
    }

    public void appendMessage(byte[] appendMessage) {
        if (this.message == null) {
            this.setMessage(appendMessage);
            return;
        }
        if (appendMessage == null) {
            return;
        }
        this.appendMessage(appendMessage, 0, appendMessage.length);
    }

    public void appendMessage(byte[] appendMessage, int offset, int length) {
        if (this.message == null) {
            return;
        }
        if (appendMessage == null) {
            return;
        }
        if (this.complete) {
            return;
        }
        if (offset < 0 || offset >= appendMessage.length) {
            return;
        }
        if (offset + length > appendMessage.length) {
            return;
        }
        int contentLength = this.getContentLength();
        int remain = contentLength - this.messageOffset;
        if (remain <= 0) {
            return;
        }
        int copyLen = length;
        if (remain < copyLen) {
            copyLen = remain;
        }
        System.arraycopy(appendMessage, offset, this.message, this.messageOffset, copyLen);
        this.messageOffset += copyLen;
        if (this.messageOffset >= contentLength) {
            this.complete = true;
        }
    }

    public void setContentLength(int contentLength) {
        super.setContentLength(contentLength);
        if (contentLength != -1 && this.message == null) {
            this.message = new byte[contentLength];
            this.messageOffset = 0;
        }
    }

    public synchronized InputStream getInputStream() throws FileNotFoundException {
        int contentLength = this.getContentLength();
        if (contentLength == -1 || this.message == null) {
            return null;
        }
        this.checkContentLength(this.messageOffset);
        if (this.byteArrayInput != null) {
            return this.byteArrayInput;
        }
        this.byteArrayInput = new ByteArrayInputStream(this.message);
        return this.byteArrayInput;
    }

    public synchronized void putInputStream() {
        if (this.byteArrayInput != null) {
            block3: {
                try {
                    this.byteArrayInput.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer10._10303_LEVEL)) break block3;
                    logger.log(JeusMessage_WebContainer10._10303_LEVEL, JeusMessage_WebContainer10._10303, (Object)this.toString(), (Throwable)e);
                }
            }
            this.byteArrayInput = null;
        }
    }

    public static void main(String[] args) {
        SimpleMessage myMsg = new SimpleMessage(10);
        try {
            myMsg.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        myMsg.setContentLength(3);
        myMsg.appendMessage("ab".getBytes());
        myMsg.appendMessage("cde".getBytes());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        myMsg.setMessage("098761".getBytes());
        myMsg.setMessage("1234511".getBytes());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        myMsg.appendMessage("alpha".getBytes());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        myMsg.destroy();
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

