/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.nio.util.ByteBufferCreator;

public class HTTPBufferWrapper {
    private ByteBuffer realBuffer;
    private ByteBuffer sslInBuffer;
    private SSLEngine engine;
    StreamHandlerImpl endpoint;
    boolean ssl = false;

    public HTTPBufferWrapper(ByteBuffer buffer, SSLEngine sslEngine) {
        this.realBuffer = buffer;
        this.engine = sslEngine;
        if (this.engine != null) {
            this.ssl = true;
        }
        if (this.ssl) {
            this.sslInBuffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)8192);
        }
    }

    public HTTPBufferWrapper(ByteBuffer buffer, SSLEngine sslEngine, StreamHandlerImpl endpoint) {
        this.realBuffer = buffer;
        this.engine = sslEngine;
        if (this.engine != null) {
            this.ssl = true;
        }
        this.endpoint = endpoint;
        if (this.ssl) {
            this.sslInBuffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)8192);
        }
    }

    public void clear() {
        this.realBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ReadableByteChannel c) throws IOException {
        if (this.ssl) {
            int packetBufferSize = this.engine.getSession().getPacketBufferSize();
            this.sslInBuffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)packetBufferSize);
            int length = c.read(this.sslInBuffer);
            if (length < 0) {
                return -1;
            }
            this.sslInBuffer.flip();
            while (this.sslInBuffer.remaining() > 0) {
                SSLEngineResult engineResult;
                SSLEngine sSLEngine = this.engine;
                synchronized (sSLEngine) {
                    SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
                    boolean shouldNotifyAll = handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                    engineResult = this.engine.unwrap(this.sslInBuffer, this.realBuffer);
                    if (shouldNotifyAll) {
                        this.engine.notifyAll();
                    }
                }
                SSLEngineResult.Status status = engineResult.getStatus();
                if (status == SSLEngineResult.Status.OK) {
                    this.checkHandshake();
                    continue;
                }
                if (status == SSLEngineResult.Status.CLOSED) {
                    this.endpoint.reportException((Exception)new IOException("SSLEngine closed"));
                    this.engine.closeInbound();
                    return -1;
                }
                if (status != SSLEngineResult.Status.BUFFER_OVERFLOW && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            }
            return this.realBuffer.position();
        }
        return c.read(this.realBuffer);
    }

    private boolean checkHandshake() throws IOException {
        SSLEngine sSLEngine = this.engine;
        synchronized (sSLEngine) {
            while (true) {
                SSLEngineResult.HandshakeStatus handshakeStatus;
                if ((handshakeStatus = this.engine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    return true;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    SSLEngineResult engineResult = this.writeSSLOutBuffer(this.engine, (StreamHandler)this.endpoint, ByteBufferCreator.dummyBuffers);
                    SSLEngineResult.Status status = engineResult.getStatus();
                    if (status == SSLEngineResult.Status.OK) continue;
                    throw new IOException("Unexpected status:" + (Object)((Object)status) + " during handshake WRAP.");
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    if (!this.sslInBuffer.hasRemaining()) {
                        return false;
                    }
                    int position = this.sslInBuffer.position();
                    this.engine.unwrap(this.sslInBuffer, this.realBuffer);
                    if (position != this.sslInBuffer.position()) continue;
                    return false;
                }
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                SSLEngineResult.HandshakeStatus handshakeStatus2 = this.tasks();
            }
            throw new RuntimeException("never");
        }
    }

    public void flip() {
        this.realBuffer.flip();
    }

    public int remaining() {
        return this.realBuffer.remaining();
    }

    public void get(byte[] tempBuffer) {
        this.realBuffer.get(tempBuffer);
    }

    public byte get() {
        byte b = this.realBuffer.get();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult writeSSLOutBuffer(SSLEngine engine, StreamHandler endpoint, ByteBuffer[] buffers) throws IOException {
        SSLEngineResult engineResult;
        ByteBuffer sslOutBuffer = ByteBufferCreator.allocateByteBuffer((boolean)true, (int)engine.getSession().getPacketBufferSize());
        SSLEngine sSLEngine = engine;
        synchronized (sSLEngine) {
            engineResult = buffers.length == 1 ? engine.wrap(buffers[0], sslOutBuffer) : engine.wrap(buffers, sslOutBuffer);
            sslOutBuffer.flip();
            if (sslOutBuffer.hasRemaining() && sslOutBuffer.hasRemaining()) {
                endpoint.writeInternal((Object[])new ByteBuffer[]{sslOutBuffer});
            }
        }
        return engineResult;
    }

    protected SSLEngineResult.HandshakeStatus tasks() {
        Runnable r = null;
        while ((r = this.engine.getDelegatedTask()) != null) {
            r.run();
        }
        return this.engine.getHandshakeStatus();
    }
}

