/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol.tcp;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jeus.servlet.async.AbstractTcpAsyncServlet;
import jeus.servlet.async.FutureServletResponse;
import jeus.servlet.connector.MaxConnectionReachedException;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.protocol.tcp.TCPMessage;
import jeus.servlet.connector.protocol.tcp.TCPOutputStream;
import jeus.servlet.connector.protocol.tcp.TCPServletRequestImpl;
import jeus.servlet.connector.protocol.tcp.TCPServletResponseImpl;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer10;

public class TCPProcessorTask
extends ProcessorTask {
    protected HttpServletRequestImpl createRequest(ContextGroup contextGroup) {
        return new TCPServletRequestImpl(contextGroup, null);
    }

    protected HttpServletResponseImpl createResponse(ContextGroup contextGroup, NIOWebServerOutputStream outputStream) {
        return new TCPServletResponseImpl(contextGroup, outputStream);
    }

    protected NIOWebServerOutputStream createOutputStream(int bufferSize) {
        return new TCPOutputStream(bufferSize);
    }

    protected void destroy() {
    }

    public void readRequest(Object message) throws IOException, InterruptedException {
        if (message == null || !(message instanceof TCPMessage)) {
            IOException ie = new IOException("message type is not instance of TCPMessage");
            if (logger.isLoggable(JeusMessage_WebContainer10._10122_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10122_LEVEL, JeusMessage_WebContainer10._10122, (Object)this.requestStatistic.getStringWorkerThreadID(), (Throwable)ie);
            }
            throw ie;
        }
        if (!(this.request instanceof TCPServletRequestImpl)) {
            IOException ie = new IOException("request type is not instance of TCPServletRequestImpl");
            if (logger.isLoggable(JeusMessage_WebContainer10._10122_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10122_LEVEL, JeusMessage_WebContainer10._10122, (Object)this.requestStatistic.getStringWorkerThreadID(), (Throwable)ie);
            }
            throw ie;
        }
        TCPServletRequestImpl tcpRequest = (TCPServletRequestImpl)this.request;
        TCPMessage tcpMsg = (TCPMessage)message;
        tcpRequest.setMethod("GET");
        tcpRequest.setProtocol("HTTP/0.9");
        tcpRequest.setHeaderLength(tcpMsg.getHeaderLength());
        tcpRequest.setHeader(tcpMsg.getHeader());
        tcpRequest.setBody(tcpMsg.getBody());
        tcpRequest.setContentLength(tcpMsg.getContentLength());
        tcpRequest.setContextPath(tcpMsg.getContextPath());
        String servletPath = tcpMsg.getServletPath();
        if (servletPath != null && !servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
        tcpRequest.setServletPath(servletPath);
        String requestURI = tcpMsg.getContextPath();
        if (servletPath != null && !servletPath.equals("/")) {
            requestURI = requestURI + servletPath;
        }
        if (tcpMsg.getPathInfo() != null) {
            requestURI = requestURI + servletPath;
        }
        tcpRequest.setPathInfo(tcpMsg.getPathInfo());
        tcpRequest.processCommonRequest(requestURI, null, null);
        tcpRequest.setConnectionHandle(tcpMsg.getConnectionHandle());
        tcpRequest.setConnector(this.connector);
        if (logger.isLoggable(JeusMessage_WebContainer10._10401_LEVEL)) {
            StringBuffer buf = new StringBuffer();
            buf.append("\tcontext-path : " + tcpRequest.getContextPath() + StringUtil.lineSeparator);
            buf.append("\tservlet-path : " + tcpRequest.getServletPath() + StringUtil.lineSeparator);
            buf.append("\tpath-info    : " + tcpRequest.getPathInfo() + StringUtil.lineSeparator);
            buf.append("\trequest-uri  : " + tcpRequest.getRequestURI() + StringUtil.lineSeparator);
            buf.append("\tcontent-len  : " + tcpRequest.getContentLength() + StringUtil.lineSeparator);
            logger.log(JeusMessage_WebContainer10._10401_LEVEL, JeusMessage_WebContainer10._10401, (Object)buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(Throwable t, String msg) {
        if (logger.isLoggable(JeusMessage_WebContainer10._10101_LEVEL)) {
            if (t != null) {
                logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg, t);
            } else {
                logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg);
            }
        }
        if (!(t instanceof MaxConnectionReachedException) && this.async) {
            if (this.wrapper == null) {
                this.finishConnection();
            } else {
                ServletWrapper executionWrapper = (ServletWrapper)this.wrapper;
                String servletName = executionWrapper.getServletName();
                WebAppContextSwitch.preContextSwitch(executionWrapper.getReloader());
                try {
                    Servlet copy = null;
                    try {
                        this.requestStatistic.setStep(7);
                        copy = executionWrapper.getReloader().getServlet();
                        if (copy instanceof AbstractTcpAsyncServlet) {
                            ((AbstractTcpAsyncServlet)copy).sendError(t, msg, (ServletRequest)this.request, (ServletResponse)this.response);
                            ((FutureServletResponse)((Object)this.response)).send();
                        } else {
                            this.finishConnection();
                        }
                        if (copy != null) {
                            executionWrapper.getReloader().putServlet(copy);
                        }
                    }
                    catch (Throwable t2) {
                        try {
                            String msg2 = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10115, (Object)servletName);
                            logger.log(JeusMessage_WebContainer10._10115_LEVEL, msg2, t2);
                            this.finishConnection();
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (copy != null) {
                                executionWrapper.getReloader().putServlet(copy);
                            }
                        }
                    }
                }
                finally {
                    WebAppContextSwitch.postContextSwitch();
                }
            }
        }
    }
}

