/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.testcase.tcp.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import jeus.servlet.connector.testcase.tcp.client.TestPacket;
import jeus.servlet.connector.testcase.tcp.client.TestThread;

public class TestClient {
    private String address;
    private int port;
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;

    public TestClient(String host, int port) {
        this.address = host;
        this.port = port;
    }

    public void connect() throws IOException {
        this.socket = new Socket(this.address, this.port);
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
    }

    public void destroy() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public void sendInt(int value) throws IOException {
        if (this.out == null) {
            throw new IOException("already destroyed");
        }
        this.out.writeInt(value);
        this.out.flush();
    }

    public void test(TestPacket pkt, String name) throws IOException, UnsupportedEncodingException {
        if (this.out == null || this.in == null || this.socket == null) {
            throw new IOException("already destroyed");
        }
        if (pkt == null) {
            throw new IOException("packet is null");
        }
        if (pkt.getHeader() != null) {
            this.out.write(pkt.getHeader());
        }
        if (pkt.getBody() != null) {
            this.out.write(pkt.getBody());
        }
        this.out.writeInt(pkt.getTotalLen());
        this.out.flush();
        int totalLen = this.in.readInt();
        byte[] message = new byte[totalLen];
        this.in.readFully(message);
        pkt.reset();
        pkt.initMessage(message);
        System.out.println(name + pkt);
        System.out.println("");
    }

    public static void main(String[] argv) throws Exception {
        String ip = "";
        int port = 0;
        int threadNum = 0;
        int tryCount = 0;
        int sleep = 0;
        if (argv.length != 5) {
            TestClient.usage();
            return;
        }
        try {
            ip = argv[0];
            port = Integer.parseInt(argv[1]);
            threadNum = Integer.parseInt(argv[2]);
            tryCount = Integer.parseInt(argv[3]);
            sleep = Integer.parseInt(argv[4]);
        }
        catch (Exception e) {
            TestClient.usage();
            return;
        }
        TestThread[] threads = null;
        if (threadNum > 0) {
            threads = new TestThread[threadNum];
        }
        long startTime = System.currentTimeMillis();
        System.out.println("### test start!!!(" + startTime + ")");
        for (int i = 0; i < threadNum; ++i) {
            threads[i] = new TestThread("thread" + i, ip, port, sleep, tryCount);
            threads[i].start();
        }
        boolean allFinish = false;
        while (!allFinish) {
            allFinish = true;
            for (int i = 0; i < threadNum; ++i) {
                if (threads[i].isFinished()) continue;
                allFinish = false;
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("### test end!!!(" + endTime + "), total gap = " + (endTime - startTime));
    }

    public static void usage() {
        System.out.println("TCPServletClient ip port thread_cnt send_sleep");
    }
}

