/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.servlet.deployment.WebConfiguration;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.AccessFormatter;
import jeus.util.logging.AccessHandlerFactory;
import jeus.util.logging.AccessLogger;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.jeusDD.AccessLogType;
import jeus.xml.binding.jeusDD.FileHandlerType;
import jeus.xml.binding.jeusDD.HandlerType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.UserLogType;

public class ConfigUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebAppDescriptor readWebAppDescriptor(String configDir, boolean isSystemConfig) throws Exception {
        if (configDir == null) {
            return new WebAppDescriptor();
        }
        if (!configDir.endsWith(File.separator)) {
            configDir = configDir + File.separator;
        }
        WebDeploymentDescriptorFile file = null;
        file = isSystemConfig ? new WebDeploymentDescriptorFile("") : new WebDeploymentDescriptorFile();
        FileArchive fileArchive = null;
        try {
            fileArchive = new FileArchive(new File(configDir));
            WebAppType webApp = (WebAppType)file.getDeploymentDescriptor((AbstractArchive)fileArchive);
            webApp.setVersion(file.getServletVersion());
            WebAppDescriptor webAppDesc = new WebAppDescriptor();
            try {
                if (!isSystemConfig) {
                    WebDeploymentDescriptorFile mapFile = null;
                    mapFile = new WebDeploymentDescriptorFile("WEB-INF", "jeus_jspmap.xml");
                    WebAppType jspMap = (WebAppType)mapFile.getDeploymentDescriptor((AbstractArchive)fileArchive);
                    webAppDesc = WebConfiguration.configureWeb(jspMap);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            WebAppDescriptor webAppDescriptor = WebConfiguration.configureWeb(webApp, webAppDesc);
            return webAppDescriptor;
        }
        catch (FileNotFoundException ex) {
            WebAppDescriptor webAppDescriptor = new WebAppDescriptor();
            return webAppDescriptor;
        }
        finally {
            if (fileArchive != null) {
                fileArchive.close();
                fileArchive = null;
            }
        }
    }

    public static AccessLogger configureAccessLog(AccessLogType sysLogType, String cgName) throws Throwable {
        AccessLogger logger;
        if (cgName == null) {
            logger = (AccessLogger)((Object)AccessLogger.getLogger("jeus.webaccess"));
            if (sysLogType == null) {
                ObjectFactory objFactory = new ObjectFactory();
                sysLogType = objFactory.createAccessLogType();
                sysLogType.fillDefault();
            }
            HandlerType handlerType = ConfigUtil.getDefaultHandlerType(sysLogType);
            sysLogType.setHandler(handlerType);
            JeusLoggerConfiguration.configLogger(logger, (SystemLoggingType)sysLogType, AccessFormatter.getAccessFormatter(sysLogType == null ? null : sysLogType.getFormat()), AccessHandlerFactory.handlerFactory);
            if (sysLogType != null && sysLogType.isSetEnable() && !sysLogType.isEnable().booleanValue()) {
                logger.setLevel(Level.SEVERE);
            } else {
                logger.setLevel(Level.INFO);
            }
        } else if (sysLogType == null) {
            logger = (AccessLogger)((Object)AccessLogger.getLogger("jeus.webaccess"));
        } else {
            logger = (AccessLogger)((Object)AccessLogger.getLogger("jeus.webaccess." + cgName));
            String[] defaultPath = (String[])JeusLoggerConfiguration.defaultLoggerSetting.get("jeus.webaccess");
            String[] path = new String[]{defaultPath[0], defaultPath[1] + File.separator + cgName};
            JeusLoggerConfiguration.setDefaultFilePath("jeus.webaccess." + cgName, path);
            HandlerType handlerType = ConfigUtil.getDefaultHandlerType(sysLogType);
            sysLogType.setHandler(handlerType);
            JeusLoggerConfiguration.configLogger(logger, (SystemLoggingType)sysLogType, AccessFormatter.getAccessFormatter(sysLogType.getFormat()), AccessHandlerFactory.handlerFactory);
            if (sysLogType.isSetEnable() && !sysLogType.isEnable().booleanValue()) {
                logger.setLevel(Level.SEVERE);
            } else {
                logger.setLevel(Level.INFO);
            }
        }
        return logger;
    }

    private static HandlerType getDefaultHandlerType(AccessLogType logType) throws JAXBException {
        List handlers;
        ObjectFactory objFactory = null;
        HandlerType handlerType = logType.getHandler();
        if (handlerType == null) {
            objFactory = new ObjectFactory();
            handlerType = objFactory.createHandlerType();
        }
        if ((handlers = handlerType.getConsoleHandlerOrFileHandlerOrSmtpHandler()).size() > 0) {
            return handlerType;
        }
        if (objFactory == null) {
            objFactory = new ObjectFactory();
        }
        FileHandlerType fileHandler = objFactory.createFileHandlerType();
        fileHandler.fillDefault();
        handlers.add(fileHandler);
        return handlerType;
    }

    public static JeusLogger configureUserLog(UserLogType logType, String cgName) throws Throwable {
        JeusLogger logger;
        if (cgName == null) {
            logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.systemuser.webuser");
            if (logType != null) {
                JeusLoggerConfiguration.configLogger(logger, (SystemLoggingType)logType);
            }
        } else {
            logger = (JeusLogger)JeusLogger.getLogger((String)("jeus.systemuser.webuser." + cgName));
            String[] defaultPath = (String[])JeusLoggerConfiguration.defaultLoggerSetting.get("jeus.systemuser.webuser");
            String[] path = new String[]{defaultPath[0], defaultPath[1] + File.separator + cgName};
            JeusLoggerConfiguration.setDefaultFilePath("jeus.systemuser.webuser." + cgName, path);
            if (logType != null) {
                JeusLoggerConfiguration.configLogger(logger, (SystemLoggingType)logType);
            }
        }
        return logger;
    }

    public static JeusLogger configureWebDDUserLog(UserLogType logType, String cgName, String ctxName) throws Throwable {
        if (cgName == null) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1261));
        }
        if (ctxName == null) {
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1256));
        }
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)("jeus.systemuser.webuser." + cgName + "." + ctxName));
        String[] defaultPath = (String[])JeusLoggerConfiguration.defaultLoggerSetting.get("jeus.systemuser.webuser");
        String[] path = new String[]{defaultPath[0] + "_" + ctxName, defaultPath[1] + File.separator + cgName};
        JeusLoggerConfiguration.setDefaultFilePath("jeus.systemuser.webuser." + cgName + "." + ctxName, path);
        if (logType != null) {
            JeusLoggerConfiguration.configLogger(logger, (SystemLoggingType)logType);
        }
        return logger;
    }
}

