/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.ResponseHeaderDescriptor;
import jeus.servlet.deployment.descriptor.SessionDescriptor;
import jeus.servlet.deployment.descriptor.VirtualHostDescriptor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.LoggingType;
import jeus.xml.binding.jeusDD.PropertiesType;
import jeus.xml.binding.jeusDD.SessionConfigType;

public class ContextGroupDescriptor
implements Serializable {
    private String groupName;
    private String forcedRequestUrlEncoding;
    private String forcedRequestEncoding;
    private String forcedResponseEncoding;
    private String defaultRequestUrlEncoding;
    private String defaultRequestEncoding;
    private String defaultResponseEncoding;
    private boolean strictPostDataEncoding = false;
    private boolean isAttachStacktraceOnError = false;
    private Hashtable jspConfig;
    private Hashtable connDescs = new Hashtable();
    private ResponseHeaderDescriptor respHeaderDesc = new ResponseHeaderDescriptor();
    private boolean disableDefaultContext = false;
    private Hashtable virtualHosts = new Hashtable();
    private VirtualHostDescriptor defaultVirtualHostDescriptor = new VirtualHostDescriptor();
    private LoggingType logging;
    private PropertiesType properties;
    private SessionConfigType sessionDescType;

    public ContextGroupDescriptor() {
        this.defaultVirtualHostDescriptor.setDefaultVirtualHost(true);
    }

    public String toString() {
        return this.groupName;
    }

    public void setGroupName(String name) throws DescriptorException {
        if (name != null) {
            this.groupName = name.trim();
            if (this.groupName.length() == 0) {
                throw new DescriptorException(JeusMessage_WebContainer0._1261);
            }
        } else {
            throw new DescriptorException(JeusMessage_WebContainer0._1261);
        }
    }

    public void setForcedRequestUrlEncoding(String charset) {
        this.forcedRequestUrlEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setForcedRequestEncoding(String charset) {
        this.forcedRequestEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setForcedResponseEncoding(String charset) {
        this.forcedResponseEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setDefaultRequestUrlEncoding(String charset) {
        this.defaultRequestUrlEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setDefaultRequestEncoding(String charset) {
        this.defaultRequestEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setDefaultResponseEncoding(String charset) {
        this.defaultResponseEncoding = charset == null || charset.equals("") ? null : charset;
    }

    public void setStrictPostDataEncoding(String value) {
        this.strictPostDataEncoding = value != null && value.equals("true");
    }

    public void setAttachStacktraceOnError(String printing) {
        this.isAttachStacktraceOnError = printing != null && printing.equals("true");
    }

    public void setJspConfig(Hashtable jspConf) {
        this.jspConfig = jspConf;
    }

    public void addContextDescriptorToDefaultVHostDesc(ContextDescriptor desc) throws DescriptorException {
        this.defaultVirtualHostDescriptor.addContextDescriptor(desc);
    }

    public void addVirtualHostDescriptor(VirtualHostDescriptor desc) throws DescriptorException {
        String vhostName = desc.getVirtualHostName();
        Object dup = this.virtualHosts.get(vhostName);
        if (dup != null) {
            throw new DescriptorException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1342, (Object)vhostName));
        }
        this.virtualHosts.put(desc.getVirtualHostName(), desc);
    }

    public void setVirtualHostDescriptors(Hashtable value) {
        this.virtualHosts = value;
    }

    public void addConnectionDescriptor(String id, ConnectionDescriptor desc) throws DescriptorException {
        ConnectionDescriptor dup = this.connDescs.put(id, desc);
        if (dup != null) {
            throw new DescriptorException(JeusMessage_WebContainer0._1013, id);
        }
    }

    public void updateConnectionDescriptor(String id, ConnectionDescriptor desc) throws DescriptorException {
        this.connDescs.put(id, desc);
    }

    public void setResponseHeaderDescriptor(ResponseHeaderDescriptor desc) {
        this.respHeaderDesc = desc;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getForcedRequestUrlEncoding() {
        return this.forcedRequestUrlEncoding;
    }

    public String getForcedRequestEncoding() {
        return this.forcedRequestEncoding;
    }

    public String getForcedResponseEncoding() {
        return this.forcedResponseEncoding;
    }

    public String getDefaultRequestUrlEncoding() {
        return this.defaultRequestUrlEncoding;
    }

    public String getDefaultRequestEncoding() {
        return this.defaultRequestEncoding;
    }

    public String getDefaultResponseEncoding() {
        return this.defaultResponseEncoding;
    }

    public boolean getStrictPostDataEncoding() {
        return this.strictPostDataEncoding;
    }

    public boolean isAttachStacktraceOnError() {
        return this.isAttachStacktraceOnError;
    }

    public Hashtable getJspConfig() {
        return this.jspConfig;
    }

    public VirtualHostDescriptor getDefaultVirtualHostDescriptor() {
        return this.defaultVirtualHostDescriptor;
    }

    public VirtualHostDescriptor getVirtualHostDescriptor(String vhostName) {
        if (vhostName == null) {
            return null;
        }
        return (VirtualHostDescriptor)this.virtualHosts.get(vhostName);
    }

    public Hashtable getVirtualHostDescriptors() {
        return this.virtualHosts;
    }

    public ContextDescriptor getContextDescriptorByName(String ctxName) {
        Enumeration enum1 = this.virtualHosts.elements();
        while (enum1.hasMoreElements()) {
            VirtualHostDescriptor vhDesc = (VirtualHostDescriptor)enum1.nextElement();
            ContextDescriptor ctxDesc = vhDesc.getContextDescriptor(ctxName);
            if (ctxDesc == null) continue;
            return ctxDesc;
        }
        return this.defaultVirtualHostDescriptor.getContextDescriptor(ctxName);
    }

    public ContextDescriptor getContextDescriptorFromDefaultVHostDesc(String ctxName) {
        return this.defaultVirtualHostDescriptor.getContextDescriptor(ctxName);
    }

    public Hashtable getContextDescriptorsFromDefaultVHostDesc() {
        return this.defaultVirtualHostDescriptor.getContextDescriptors();
    }

    public ConnectionDescriptor getConnectionDescriptor(String port) {
        return (ConnectionDescriptor)this.connDescs.get(port);
    }

    public Hashtable getConnectionDescriptor() {
        return this.connDescs;
    }

    public ResponseHeaderDescriptor getResponseHeaderDescriptor() {
        return this.respHeaderDesc;
    }

    public boolean isDisableDefaultContext() {
        return this.disableDefaultContext;
    }

    public void printDescriptor(PrintWriter out) {
        Enumeration<Object> enum1;
        out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        out.println("+             ContextGroup Information                +");
        out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        out.println();
        out.println("- ContextGroup name             : " + this.groupName);
        out.println("- forced requestUrl encoding    : " + this.forcedRequestUrlEncoding);
        out.println("- forced request encoding       : " + this.forcedRequestEncoding);
        out.println("- forced response encoding      : " + this.forcedResponseEncoding);
        out.println("- default requestUrl encoding   : " + this.defaultRequestUrlEncoding);
        out.println("- default request encoding      : " + this.defaultRequestEncoding);
        out.println("- default response encoding     : " + this.defaultResponseEncoding);
        out.println("- attach stacktrace on error    : " + this.isAttachStacktraceOnError);
        if (this.jspConfig != null) {
            out.println("- jsp configuration             : ");
            enum1 = this.jspConfig.keys();
            while (enum1.hasMoreElements()) {
                String name = (String)enum1.nextElement();
                String value = (String)this.jspConfig.get(name);
                out.println("    + " + name + " : " + value);
            }
        }
        if (this.virtualHosts.size() > 0) {
            out.println("- virtual host List             : ");
            enum1 = this.virtualHosts.elements();
            while (enum1.hasMoreElements()) {
                VirtualHostDescriptor desc = (VirtualHostDescriptor)enum1.nextElement();
                out.println("    + " + desc.getVirtualHostName());
            }
        }
        if (this.sessionDescType != null) {
            out.println(SessionDescriptor.getSessionDescriptorTypeInformation(this.sessionDescType));
        }
        out.println();
    }

    public LoggingType getLogging() {
        return this.logging;
    }

    public void setLogging(LoggingType logging) {
        this.logging = logging;
    }

    public PropertiesType getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesType properties) {
        this.properties = properties;
    }

    public SessionConfigType getSessionDescType() {
        return this.sessionDescType;
    }

    public void setSessionDesc(SessionConfigType sessionDescType) {
        this.sessionDescType = sessionDescType;
    }
}

