/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.Serializable;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.SessionCookieType;

public class SessionCookieDescriptor
implements Serializable {
    public static final String DEFAULT_JSESSIONID_NAME = "JSESSIONID";
    public static final int DEFAULT_VERSION = 0;
    public static final String DEFAULT_DOMAIN = null;
    public static final String DEFAULT_PATH = "/";
    public static final int DEFAULT_MAX_AGE = -1;
    public static final boolean DEFAULT_SECURE = false;
    private String jsessionidName = "JSESSIONID";
    private int version = 0;
    private String domain = DEFAULT_DOMAIN;
    private String path = null;
    private int maxAge = -1;
    private boolean secure = false;

    public String getJsessionidName() {
        return this.jsessionidName;
    }

    public int getVersion() {
        return this.version;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setJsessionidName(String jsessionidName) {
        if (jsessionidName == null) {
            return;
        }
        if (jsessionidName.trim().length() > 0) {
            this.jsessionidName = jsessionidName.trim();
        }
    }

    public void setVersion(int version) throws DescriptorException {
        if (version != 0 && version != 1) {
            throw new DescriptorException(JeusMessage_WebContainer0._1276);
        }
        this.version = version;
    }

    public void setDomain(String domain) throws DescriptorException {
        if (domain == null || domain.equals("")) {
            return;
        }
        if (!domain.startsWith(".")) {
            throw new DescriptorException(JeusMessage_WebContainer0._1296, domain);
        }
        if (domain.length() <= 1 || domain.indexOf(".", 1) <= 0) {
            throw new DescriptorException(JeusMessage_WebContainer0._1297, domain);
        }
        this.domain = domain;
    }

    public void setPath(String path) throws DescriptorException {
        if (path == null) {
            return;
        }
        if (!path.startsWith(DEFAULT_PATH)) {
            throw new DescriptorException(JeusMessage_WebContainer0._1277);
        }
        this.path = path;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("- session cookie -").append('\n');
        buffer.append("    - jsessionid-name : ").append(this.jsessionidName).append('\n');
        buffer.append("    - version         : ").append(this.version).append('\n');
        buffer.append("    - domain          : ").append(this.domain).append('\n');
        buffer.append("    - path            : ").append(this.path).append('\n');
        if (this.maxAge >= 0) {
            buffer.append("    - max-age         : ").append(this.maxAge).append('\n');
        } else {
            buffer.append("    - max-age         : ").append(this.maxAge).append(" (browser-lifetime)").append('\n');
        }
        buffer.append("    - secure          : ").append(this.secure).append('\n');
        return buffer.toString();
    }

    public static String getSesssionCookieTypeInformation(SessionCookieType sessionCookieType) {
        if (sessionCookieType == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(2048);
        buffer.append("- session cookie -").append('\n');
        if (sessionCookieType.getJsessionidName() != null) {
            buffer.append("    - jsessionid-name : ").append(sessionCookieType.getJsessionidName()).append('\n');
        }
        if (sessionCookieType.getVersion() != null) {
            buffer.append("    - version         : ").append(sessionCookieType.getVersion()).append('\n');
        }
        if (sessionCookieType.getDomain() != null) {
            buffer.append("    - domain          : ").append(sessionCookieType.getDomain()).append('\n');
        }
        if (sessionCookieType.getPath() != null) {
            buffer.append("    - path            : ").append(sessionCookieType.getPath()).append('\n');
        }
        if (sessionCookieType.getMaxAge() != null) {
            buffer.append("    - max-age         : ").append(sessionCookieType.getMaxAge()).append('\n');
        }
        if (sessionCookieType.isSecure() != null) {
            buffer.append("    - secure          : ").append(sessionCookieType.isSecure()).append('\n');
        }
        return buffer.toString();
    }
}

