/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jeus.descriptor.jeusserver.EngineDescriptor;
import jeus.servlet.deployment.descriptor.ContainerMonitorDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.util.message.JeusMessage_WebContainer0;

public class WebContainerDescriptor
extends EngineDescriptor
implements Serializable {
    private ContainerMonitorDescriptor monitorDescriptor;
    private boolean redirectStdout = false;
    private boolean redirectStderr = false;
    private long shutdownTimeout = -1L;
    private Hashtable ctxGroupDescs = new Hashtable();
    private Vector ctxGroupNames = new Vector();
    private boolean securitySwitch = true;

    public void setContainerMonitorDescriptor(ContainerMonitorDescriptor desc) {
        this.monitorDescriptor = desc;
    }

    public void setSecuritySwitch(boolean value) {
        this.securitySwitch = value;
    }

    public void setRedirectStdOut(String stdout) {
        this.redirectStdout = stdout == null ? false : stdout.equals("true");
    }

    public void setRedirectStdErr(String stderr) {
        this.redirectStderr = stderr == null ? false : stderr.equals("true");
    }

    public void setShutdownTimeout(String value) {
        if (value != null) {
            try {
                this.shutdownTimeout = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                this.shutdownTimeout = -1L;
            }
        } else {
            this.shutdownTimeout = -1L;
        }
    }

    public void addContextGroupDescriptor(String groupName, ContextGroupDescriptor desc) throws DescriptorException {
        if (this.ctxGroupDescs.containsKey(groupName)) {
            throw new DescriptorException(JeusMessage_WebContainer0._1010, groupName);
        }
        this.ctxGroupDescs.put(groupName, desc);
        this.ctxGroupNames.addElement(groupName);
    }

    public ContainerMonitorDescriptor getContainerMonitorDescriptor() {
        return this.monitorDescriptor;
    }

    public boolean getSecuritySwitch() {
        return this.securitySwitch;
    }

    public boolean isRedirectStdOut() {
        return this.redirectStdout;
    }

    public boolean isRedirectStdErr() {
        return this.redirectStderr;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public ContextGroupDescriptor getContextGroupDescriptor(String groupName) {
        return (ContextGroupDescriptor)this.ctxGroupDescs.get(groupName);
    }

    public Hashtable getContextGroupDescriptor() {
        return this.ctxGroupDescs;
    }

    public Vector getContextGroupNames() {
        return this.ctxGroupNames;
    }

    public void printDescriptor(PrintWriter out) {
        out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        out.println("+             WebContainerType Information            +");
        out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        out.println();
        out.println("- redirect standard out   : " + this.redirectStdout);
        out.println("- redirect stardard error : " + this.redirectStderr);
        out.println("- shutdown timeout        : " + this.shutdownTimeout);
        if (this.monitorDescriptor != null) {
            this.monitorDescriptor.printDescriptor(out);
        }
        out.println();
    }
}

