/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor.bind;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.service.library.ClassPathEntry;
import jeus.service.library.LibraryManager;
import jeus.service.library.LibraryNotFoundException;
import jeus.service.library.LibraryRef;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.FileCachingDescriptor;
import jeus.servlet.deployment.descriptor.RoleMappingDescriptor;
import jeus.servlet.deployment.descriptor.SessionDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.deployment.descriptor.bind.BindedDescriptor;
import jeus.tool.common.xml.XMLConverterException;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.AddedClasspathType;
import jeus.xml.binding.jeusDD.AliasType;
import jeus.xml.binding.jeusDD.AliasingType;
import jeus.xml.binding.jeusDD.AllowIndexingType;
import jeus.xml.binding.jeusDD.AppEncodingType;
import jeus.xml.binding.jeusDD.AutoReloadType;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.DenyDownloadType;
import jeus.xml.binding.jeusDD.EnvType;
import jeus.xml.binding.jeusDD.FileCachingType;
import jeus.xml.binding.jeusDD.JeusWebservicesClientDdType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.JspEngineType;
import jeus.xml.binding.jeusDD.JspResourceType;
import jeus.xml.binding.jeusDD.LibraryRefType;
import jeus.xml.binding.jeusDD.LibraryRefVersionType;
import jeus.xml.binding.jeusDD.PropertiesType;
import jeus.xml.binding.jeusDD.RoleMappingType;
import jeus.xml.binding.jeusDD.RolePermissionType;
import jeus.xml.binding.jeusDD.ServletType;
import jeus.xml.binding.jeusDD.SessionConfigType;
import jeus.xml.binding.jeusDD.UserLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextDescriptorJB
extends ContextDescriptor
implements Serializable,
BindedDescriptor {
    private ContextType webDDElem;
    private ContextDescriptor contextDesc;
    private SessionConfigType sessionDescType;

    @Override
    public String toString() {
        return this.contextDesc.toString();
    }

    @Override
    public void setContextName(String name) throws DescriptorException {
        this.contextDesc.setContextName(name);
    }

    @Override
    public void setContextPath(String path) throws DescriptorException {
        this.contextDesc.setContextPath(path);
    }

    @Override
    public void setDocBase(String base) throws DescriptorException {
        this.contextDesc.setDocBase(base);
    }

    @Override
    public void setAutoReload(String reloading) {
        this.contextDesc.setAutoReload(reloading);
    }

    @Override
    public void setAttachStacktrace(String attach) {
        this.contextDesc.setAttachStacktrace(attach);
    }

    @Override
    public void setCheckOnDemand(String ondemand) {
        this.contextDesc.setCheckOnDemand(ondemand);
    }

    public void setWebinfFirst(String webinfFirst) {
        this.contextDesc.setWebinfFitst(webinfFirst);
    }

    @Override
    public void setEnableJSP(String enable) {
        this.contextDesc.setEnableJSP(enable);
    }

    @Override
    public void addAddedClassPath(String classPath) {
        this.contextDesc.addAddedClassPath(classPath);
    }

    @Override
    public void setMaxInstancePoolSize(String size) {
        this.contextDesc.setMaxInstancePoolSize(size);
    }

    @Override
    public void addAllowIndexing(String dir) {
        this.contextDesc.addAllowIndexing(dir);
    }

    @Override
    public void addDenyDownload(String key, String value) {
        this.contextDesc.addDenyDownload(key, value);
    }

    @Override
    public void addAliasing(String name, String path) throws DescriptorException {
        this.contextDesc.addAliasing(name, path);
    }

    @Override
    public void setFileCaching(FileCachingDescriptor fc) {
        this.contextDesc.setFileCaching(fc);
    }

    @Override
    public void setRoleMapping(RoleMappingDescriptor rm) {
        this.contextDesc.setRoleMapping(rm);
    }

    @Override
    public void setEJBRefs(Hashtable refs) {
        this.contextDesc.setEJBRefs(refs);
    }

    @Override
    public void setResourceRefs(Hashtable refs) {
        this.contextDesc.setResourceRefs(refs);
    }

    @Override
    public void setResourceEnvRefs(Hashtable refs) {
        this.contextDesc.setResourceEnvRefs(refs);
    }

    @Override
    public void setWebAppDescriptor(WebAppDescriptor desc) {
        this.contextDesc.setWebAppDescriptor(desc);
    }

    @Override
    public void setWebServiceURL(String url) {
        this.contextDesc.setWebServiceURL(url);
    }

    @Override
    public void setJspConfig(Hashtable table) {
        this.contextDesc.setJspConfig(table);
    }

    public void setSessionDescType(SessionConfigType sessionDescType) {
        this.sessionDescType = sessionDescType;
    }

    @Override
    public String getContextName() {
        return this.contextDesc.getContextName();
    }

    @Override
    public String getContextPath() {
        return this.contextDesc.getContextPath();
    }

    @Override
    public String getDocBase() {
        return this.contextDesc.getDocBase();
    }

    @Override
    public boolean isAutoReload() {
        return this.contextDesc.isAutoReload();
    }

    @Override
    public boolean isAttachStacktrace() {
        return this.contextDesc.isAttachStacktrace();
    }

    @Override
    public boolean isCheckOnDemand() {
        return this.contextDesc.isCheckOnDemand();
    }

    @Override
    public boolean isJspEnable() {
        return this.contextDesc.isJspEnable();
    }

    @Override
    public boolean isWebinfFirst() {
        return this.contextDesc.isWebinfFirst();
    }

    @Override
    public Vector getAddedClassPath() {
        return this.contextDesc.getAddedClassPath();
    }

    public Vector getLibraries() {
        return this.contextDesc.getLibraries();
    }

    @Override
    public int getMaxInstancePoolSize() {
        return this.contextDesc.getMaxInstancePoolSize();
    }

    @Override
    public Vector getAllowIndexing() {
        return this.contextDesc.getAllowIndexing();
    }

    @Override
    public Hashtable getDenyDownload() {
        return this.contextDesc.getDenyDownload();
    }

    @Override
    public Hashtable getAliasing() {
        return this.contextDesc.getAliasing();
    }

    @Override
    public FileCachingDescriptor getFileCaching() {
        return this.contextDesc.getFileCaching();
    }

    @Override
    public RoleMappingDescriptor getRoleMapping() {
        return this.contextDesc.getRoleMapping();
    }

    @Override
    public Hashtable getEJBRefs() {
        return this.contextDesc.getEJBRefs();
    }

    @Override
    public Hashtable getResourceRefs() {
        return this.contextDesc.getResourceRefs();
    }

    @Override
    public Hashtable getResourceEnvRefs() {
        return this.contextDesc.getResourceEnvRefs();
    }

    @Override
    public Hashtable getMessageDestinationRefs() {
        return this.contextDesc.getMessageDestinationRefs();
    }

    @Override
    public WebAppDescriptor getWebAppDescriptor() {
        return this.contextDesc.getWebAppDescriptor();
    }

    @Override
    public String getWebServiceURL() {
        return this.contextDesc.getWebServiceURL();
    }

    @Override
    public Hashtable getJspConfig() {
        return this.contextDesc.getJspConfig();
    }

    public SessionConfigType getSessionDescType() {
        return this.sessionDescType;
    }

    @Override
    public UserLogType getLogging() {
        return this.contextDesc.getLogging();
    }

    @Override
    public void setLogging(UserLogType logging) {
        this.contextDesc.setLogging(logging);
    }

    @Override
    public JspResourceType getJspResource() {
        return this.contextDesc.getJspResource();
    }

    @Override
    public void setJspResource(JspResourceType jspResource) {
        this.contextDesc.setJspResource(jspResource);
    }

    @Override
    public PropertiesType getProperties() {
        return this.contextDesc.getProperties();
    }

    @Override
    public void setProperties(PropertiesType properties) {
        this.contextDesc.setProperties(properties);
    }

    @Override
    public void printDescriptor(PrintWriter out) {
        this.contextDesc.printDescriptor(out);
        String sessionDescriptorTypeInfo = SessionDescriptor.getSessionDescriptorTypeInformation(this.sessionDescType);
        if (sessionDescriptorTypeInfo != null) {
            out.println(sessionDescriptorTypeInfo);
        }
    }

    public ContextType getElement() {
        return this.webDDElem;
    }

    public void setElement(ContextType element) {
        this.webDDElem = element;
    }

    public void setDescritpor(ContextDescriptor _contextDesc) {
        this.contextDesc = _contextDesc;
    }

    @Override
    public String getUserPrincipalForRunAs(String servletName) {
        String principalName = null;
        if (this.webDDElem == null) {
            return principalName;
        }
        List servlets = this.webDDElem.getServlet();
        for (ServletType servlet : servlets) {
            if (!servlet.getServletName().equals(servletName)) continue;
            principalName = servlet.getRunAsIdentity().getPrincipalName();
            break;
        }
        if (servlets.size() == 0) {
            RoleMappingType roleMapping = this.webDDElem.getRoleMapping();
            List rolePermissionList = roleMapping.getRolePermission();
            for (RolePermissionType permission : rolePermissionList) {
                if (!servletName.equals(permission.getRole())) continue;
                principalName = (String)permission.getPrincipal().get(0);
            }
        }
        return principalName;
    }

    public static ContextDescriptor getContextDescriptor(String contextName, InputStream is) throws XMLConverterException {
        ContextType _jeusWebDD;
        try {
            _jeusWebDD = (ContextType)new WebRuntimeDDFile(contextName).getDeploymentDescriptor(is);
            _jeusWebDD.fillDefault();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLConverterException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return ContextDescriptorJB.getContextDescriptor0(_jeusWebDD, contextName);
    }

    public static ContextDescriptor getContextDescriptor(String contextName, String contextPath, String configDir, boolean useDefaultXMLName) throws XMLConverterException {
        ContextType _jeusWebDD;
        if (!configDir.endsWith(File.separator)) {
            configDir = configDir + File.separator;
        }
        String fullpath = configDir;
        fullpath = useDefaultXMLName ? fullpath + "jeus-web-dd" + ".xml" : fullpath + "jeus-web-dd_" + contextName + ".xml";
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fullpath);
            _jeusWebDD = (ContextType)new WebRuntimeDDFile(contextName).getDeploymentDescriptor(fis);
            _jeusWebDD.fillDefault();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLConverterException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        ContextDescriptor ctxDesc = ContextDescriptorJB.getContextDescriptor0(_jeusWebDD, contextName);
        try {
            ctxDesc.setContextName(contextName);
            if (contextPath == null && ctxDesc.getContextPath() == null) {
                throw new XMLConverterException(JeusMessage_WebContainer0._1257);
            }
            String ctxPathDD = ctxDesc.getContextPath();
            if (ctxPathDD == null || ctxPathDD.trim().equals("")) {
                ctxDesc.setContextPath(contextPath);
            }
        }
        catch (DescriptorException de) {
            throw new XMLConverterException(de.getMessage(), de.getCause());
        }
        return ctxDesc;
    }

    private static ContextDescriptor getContextDescriptor0(ContextType _contextType, String contextName) throws XMLConverterException {
        AppEncodingType _appEncoding;
        PropertiesType _properties;
        JspResourceType _jspResource;
        FileCachingType fileCachingType;
        AliasingType aliasType;
        DenyDownloadType _denyDownload;
        List _paths;
        AddedClasspathType _addedClasspath;
        ContextDescriptor desc = new ContextDescriptor();
        try {
            desc.setContextName(contextName);
        }
        catch (DescriptorException e) {
            e.printStackTrace();
            throw new XMLConverterException(JeusMessage_WebContainer0._1202, contextName, (Throwable)((Object)e));
        }
        try {
            desc.setContextPath(_contextType.getContextPath());
        }
        catch (DescriptorException e) {
            throw new XMLConverterException(JeusMessage_WebContainer0._1223, contextName, (Throwable)((Object)e));
        }
        desc.setLogging(_contextType.getUserLog());
        desc.setEnableJSP(String.valueOf(_contextType.isEnableJsp()));
        AutoReloadType autoreloadConf = _contextType.getAutoReload();
        if (autoreloadConf != null) {
            desc.setAutoReload(String.valueOf(autoreloadConf.isEnableReload()));
            desc.setCheckOnDemand(String.valueOf(autoreloadConf.isCheckOnDemand()));
            desc.setAutoReloadType(autoreloadConf);
        }
        desc.setWebinfFitst(String.valueOf(_contextType.isWebinfFirst()));
        desc.setMaxInstancePoolSize(String.valueOf(_contextType.getMaxInstancePoolSize()));
        JspEngineType jspEngineType = _contextType.getJspEngine();
        if (jspEngineType != null) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            if (jspEngineType.isSetKeepGenerated()) {
                table.put("KeepGenerated", String.valueOf(jspEngineType.isKeepGenerated()));
            }
            if (jspEngineType.isSetCompileEncoding()) {
                table.put("CompileEncoding", jspEngineType.getCompileEncoding());
            }
            if (jspEngineType.isSetJavaCompiler()) {
                table.put("JavaCompiler", jspEngineType.getJavaCompiler());
            }
            if (jspEngineType.isSetCheckIncludedJspfile()) {
                table.put("CheckIncludedJspFile", String.valueOf(jspEngineType.isCheckIncludedJspfile()));
            }
            if (jspEngineType.isSetJspWorkDir()) {
                table.put("JspWorkDir", jspEngineType.getJspWorkDir());
            }
            if (jspEngineType.isSetCompileOutputDir()) {
                table.put("CompileOutputDir", jspEngineType.getCompileOutputDir());
            }
            if (jspEngineType.isSetCompileOption()) {
                table.put("CompileOption", jspEngineType.getCompileOption());
            }
            if (table.size() > 0) {
                desc.setJspConfig(table);
            }
        }
        if ((_addedClasspath = _contextType.getAddedClasspath()) != null && (_paths = _addedClasspath.getClassPath()) != null) {
            for (int i = 0; i < _paths.size(); ++i) {
                String classPath = (String)_paths.get(i);
                desc.addAddedClassPath(classPath);
            }
        }
        if (_contextType.isSetLibraryRef()) {
            LibraryManager libraryManager = LibraryManager.getInstance();
            libraryManager.refresh();
            for (LibraryRefType _libRef : _contextType.getLibraryRef()) {
                LibraryRef ref = new LibraryRef(_libRef);
                try {
                    List<ClassPathEntry> entries = libraryManager.getClassPathEntries(ref);
                    if (entries == null) continue;
                    for (ClassPathEntry entry : entries) {
                        desc.addLibrary(entry.getPath());
                    }
                }
                catch (LibraryNotFoundException ex) {
                    throw new XMLConverterException(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        List _libRefs = _contextType.getLibraryRef();
        for (LibraryRefType _libRef : _libRefs) {
            String libName = _libRef.getLibraryName();
            String specVer = null;
            LibraryRefVersionType _specVer = _libRef.getSpecificationVersion();
            if (_specVer != null) {
                specVer = _specVer.getValue();
            }
            String implVer = null;
            LibraryRefVersionType _implVer = _libRef.getImplementationVersion();
            if (_implVer == null) continue;
            implVer = _implVer.getValue();
        }
        AllowIndexingType _allowIndex = _contextType.getAllowIndexing();
        if (_allowIndex != null) {
            List _dirs = _allowIndex.getDirectory();
            for (int i = 0; i < _dirs.size(); ++i) {
                String directory = (String)_dirs.get(i);
                desc.addAllowIndexing(directory);
            }
        }
        if ((_denyDownload = _contextType.getDenyDownload()) != null) {
            List extensions;
            List files = _denyDownload.getFile();
            if (files != null && files.size() > 0) {
                for (int i = 0; i < files.size(); ++i) {
                    String file = (String)files.get(i);
                    desc.addDenyDownload("file", file);
                }
            }
            if ((extensions = _denyDownload.getExtension()) != null && extensions.size() > 0) {
                for (int i = 0; i < extensions.size(); ++i) {
                    String extension = (String)extensions.get(i);
                    desc.addDenyDownload("extension", extension);
                }
            }
            List directories = _denyDownload.getDirectory();
            for (int i = 0; i < directories.size(); ++i) {
                String directory = (String)directories.get(i);
                desc.addDenyDownload("directory", directory);
            }
        }
        if ((aliasType = _contextType.getAliasing()) != null) {
            List aliasList = aliasType.getAlias();
            if (aliasType != null && aliasList.size() > 0) {
                for (int i = 0; i < aliasList.size(); ++i) {
                    AliasType alias = (AliasType)aliasList.get(i);
                    String aliasName = alias.getAliasName();
                    String realPath = alias.getRealPath();
                    try {
                        desc.addAliasing(aliasName, realPath);
                        continue;
                    }
                    catch (DescriptorException de) {
                        System.out.println(ErrorMsgManager.getLocalizedString((Throwable)((Object)de)));
                    }
                }
            }
        }
        if ((fileCachingType = _contextType.getFileCaching()) != null) {
            FileCachingDescriptor fcDesc = new FileCachingDescriptor();
            fcDesc.setMaxCacheMemory(String.valueOf(fileCachingType.getMaxCacheMemory()));
            fcDesc.setMaxIdleTime(String.valueOf(fileCachingType.getMaxIdleTime()));
            List dirs = fileCachingType.getDirectory();
            if (dirs != null && dirs.size() > 0) {
                for (int i = 0; i < dirs.size(); ++i) {
                    String s = (String)dirs.get(i);
                    fcDesc.addCachingDirectory(s);
                }
            }
            desc.setFileCaching(fcDesc);
        }
        desc.setEnvType(_contextType.getEnv());
        JndiRefType _ejbRefs = _contextType.getEjbRef();
        desc.setEjbRefType(_ejbRefs);
        if (_ejbRefs != null) {
            desc.setEJBRefs(ContextDescriptorJB.getJNDIInfoMapping(_ejbRefs.getJndiInfo()));
        }
        JndiRefType _resRefs = _contextType.getResRef();
        desc.setResRefType(_resRefs);
        if (_resRefs != null) {
            desc.setResourceRefs(ContextDescriptorJB.getJNDIInfoMapping(_resRefs.getJndiInfo()));
        }
        JndiRefType _resEnvRefs = _contextType.getResEnvRef();
        desc.setResEnvRefType(_resEnvRefs);
        if (_resEnvRefs != null) {
            desc.setResourceEnvRefs(ContextDescriptorJB.getJNDIInfoMapping(_resEnvRefs.getJndiInfo()));
        }
        JndiRefType _msgDestRefs = _contextType.getMessageDestinationRef();
        desc.setMessageDestRefType(_msgDestRefs);
        if (_msgDestRefs != null) {
            desc.setMessageDestinationRefs(ContextDescriptorJB.getJNDIInfoMapping(_msgDestRefs.getJndiInfo()));
        }
        desc.setServiceRefType(_contextType.getServiceRef());
        if (_contextType.isSetKeepGenerated()) {
            desc.setKeepGenerated(_contextType.isKeepGenerated() != false ? Boolean.TRUE : Boolean.FALSE);
        }
        if (_contextType.isSetFastDeploy()) {
            desc.setFastDeploy(_contextType.isFastDeploy() != false ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((_jspResource = _contextType.getJspResource()) != null && _jspResource.isSetProviderClass()) {
            desc.setJspResource(_jspResource);
        }
        if ((_properties = _contextType.getProperties()) != null) {
            desc.setProperties(_properties);
        }
        if ((_appEncoding = _contextType.getEncoding()) != null) {
            desc.setEncoding(_appEncoding);
        }
        desc.setAttachStacktrace(String.valueOf(_contextType.isAttachStacktraceOnError()));
        ContextDescriptorJB descJB = new ContextDescriptorJB();
        descJB.setDescritpor(desc);
        descJB.setElement(_contextType);
        descJB.setSessionDescType(_contextType.getSessionConfig());
        return descJB;
    }

    public static Hashtable getJNDIInfoMapping(List jndiList) {
        if (jndiList == null || jndiList.size() == 0) {
            return null;
        }
        Hashtable<String, String> refs = new Hashtable<String, String>();
        for (int i = 0; i < jndiList.size(); ++i) {
            JndiInfoType jndiInfoType = (JndiInfoType)jndiList.get(i);
            String exportName = jndiInfoType.getExportName();
            String refName = jndiInfoType.getRefName();
            if (refName == null || refName.equals("") || exportName == null || exportName.equals("")) continue;
            refs.put(refName, exportName);
        }
        return refs;
    }

    @Override
    public String getContextGroup() {
        return this.contextDesc.getContextGroup();
    }

    @Override
    public String getForcedRequestEncoding() {
        return this.contextDesc.getForcedRequestEncoding();
    }

    @Override
    public String getDefaultRequestEncoding() {
        return this.contextDesc.getDefaultRequestEncoding();
    }

    @Override
    public String getForcedResponseEncoding() {
        return this.contextDesc.getForcedResponseEncoding();
    }

    @Override
    public String getDefaultResponseEncoding() {
        return this.contextDesc.getDefaultResponseEncoding();
    }

    @Override
    public void setContextGroup(String contextGroup) {
        this.contextDesc.setContextGroup(contextGroup);
    }

    @Override
    public List<EnvType> getEnvType() {
        return this.contextDesc.getEnvType();
    }

    @Override
    public JndiRefType getEjbRefType() {
        return this.contextDesc.getEjbRefType();
    }

    @Override
    public JndiRefType getResRefType() {
        return this.contextDesc.getResRefType();
    }

    @Override
    public JndiRefType getResEnvRefType() {
        return this.contextDesc.getResEnvRefType();
    }

    @Override
    public JndiRefType getMessageDestRefType() {
        return this.contextDesc.getMessageDestRefType();
    }

    @Override
    public JeusWebservicesClientDdType getServiceRefType() {
        return this.contextDesc.getServiceRefType();
    }
}

