/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.deployment.descriptor.bind;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jeus.service.descriptor.WebMainDescriptorFile;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.connection.SSLSupport;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ContainerMonitorDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.DescriptorException;
import jeus.servlet.deployment.descriptor.ResponseHeaderDescriptor;
import jeus.servlet.deployment.descriptor.ThreadPoolDescriptor;
import jeus.servlet.deployment.descriptor.ThreadStateNotifyDescriptor;
import jeus.servlet.deployment.descriptor.VirtualHostDescriptor;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.deployment.descriptor.bind.BindedDescriptor;
import jeus.tool.common.xml.XMLConverterException;
import jeus.util.JeusProperties;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer0;
import jeus.xml.binding.jeusDD.Ajp13ListenerType;
import jeus.xml.binding.jeusDD.ContextGroupType;
import jeus.xml.binding.jeusDD.CustomHeaderType;
import jeus.xml.binding.jeusDD.EncodingSubType;
import jeus.xml.binding.jeusDD.EncodingType;
import jeus.xml.binding.jeusDD.HeaderFieldType;
import jeus.xml.binding.jeusDD.HttpListenerType;
import jeus.xml.binding.jeusDD.JspEngineType;
import jeus.xml.binding.jeusDD.LoggingType;
import jeus.xml.binding.jeusDD.MonitoringType;
import jeus.xml.binding.jeusDD.ResponseHeaderType;
import jeus.xml.binding.jeusDD.SchemeType;
import jeus.xml.binding.jeusDD.SessionConfigType;
import jeus.xml.binding.jeusDD.SessionServerType;
import jeus.xml.binding.jeusDD.SslConfigType;
import jeus.xml.binding.jeusDD.TcpListenerType;
import jeus.xml.binding.jeusDD.ThreadPoolType;
import jeus.xml.binding.jeusDD.ThreadStateNotifyType;
import jeus.xml.binding.jeusDD.TmaxListenerType;
import jeus.xml.binding.jeusDD.VirtualHostType;
import jeus.xml.binding.jeusDD.WebContainerType;
import jeus.xml.binding.jeusDD.WebserverConnectionType;
import jeus.xml.binding.jeusDD.WebtobBackupType;
import jeus.xml.binding.jeusDD.WebtobListenerType;

public class WebMainDescriptorJB
extends WebContainerDescriptor
implements Serializable,
BindedDescriptor {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.deployment");
    private LoggingType logging;
    private WebContainerType webMainElement;
    private SessionConfigType sessionDescType;
    private SessionServerType sessionServerType;

    public WebMainDescriptorJB() {
    }

    public WebMainDescriptorJB(WebContainerType w) {
        this.webMainElement = w;
    }

    public WebContainerType getWebMainConfiguration() {
        return this.webMainElement;
    }

    public LoggingType getLogging() {
        return this.logging;
    }

    public void setLogging(LoggingType logging) {
        this.logging = logging;
    }

    public static WebContainerDescriptor getWebMainDescriptor(WebContainerType webMain) throws StartingException {
        try {
            WebMainDescriptorJB desc = new WebMainDescriptorJB(webMain);
            MonitoringType mon = webMain.getMonitoring();
            ContainerMonitorDescriptor monDesc = new ContainerMonitorDescriptor();
            monDesc.setMonType(mon);
            if (mon != null) {
                monDesc.setThreadPoolCheckPeriod(String.valueOf(mon.getCheckThreadPool()));
                monDesc.setServletReloadCheckPeriod(String.valueOf(mon.getCheckClassReload()));
                monDesc.setSessionCheckPeriod(String.valueOf(mon.getCheckSession()));
            }
            desc.setContainerMonitorDescriptor(monDesc);
            desc.setRedirectStdErr(String.valueOf(webMain.isRedirectStderr()));
            desc.setRedirectStdOut(String.valueOf(webMain.isRedirectStdout()));
            desc.setShutdownTimeout(String.valueOf(webMain.getShutdownTimeout()));
            desc.setLogging(webMain.getLogging());
            desc.setSessionDescType(webMain.getSessionConfig());
            desc.setSessionServerType(webMain.getSessionServer());
            WebMainDescriptorJB.getContextGroup(webMain, desc);
            return desc;
        }
        catch (DescriptorException e) {
            e.printStackTrace();
            throw new StartingException(e.getMessage(), (Throwable)(e.getCause() == null ? e : e.getCause()));
        }
        catch (IOException ioe) {
            throw new StartingException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public static WebContainerDescriptor getWebMainDescriptor(String fullEngineName) throws StartingException {
        try {
            WebContainerType webMain;
            String nodeName = WebContainerManager.NODE_NAME;
            String configDir = JeusProperties.JEUS_CONFIG_HOME;
            if (!configDir.endsWith(File.separator)) {
                configDir = configDir + File.separator;
            }
            configDir = configDir + nodeName + File.separator + fullEngineName + File.separator;
            WebMainDescriptorFile descFile = new WebMainDescriptorFile(fullEngineName);
            try {
                webMain = (WebContainerType)descFile.getConfigDescriptor(null);
                webMain.fillDefault();
            }
            catch (Exception e) {
                throw new XMLConverterException(JeusMessage_WebContainer0._1224, (Throwable)e);
            }
            WebMainDescriptorJB desc = new WebMainDescriptorJB(webMain);
            MonitoringType mon = webMain.getMonitoring();
            ContainerMonitorDescriptor monDesc = new ContainerMonitorDescriptor();
            monDesc.setMonType(mon);
            if (mon != null) {
                monDesc.setThreadPoolCheckPeriod(String.valueOf(mon.getCheckThreadPool()));
                monDesc.setServletReloadCheckPeriod(String.valueOf(mon.getCheckClassReload()));
                monDesc.setSessionCheckPeriod(String.valueOf(mon.getCheckSession()));
            }
            desc.setContainerMonitorDescriptor(monDesc);
            desc.setRedirectStdErr(String.valueOf(webMain.isRedirectStderr()));
            desc.setRedirectStdOut(String.valueOf(webMain.isRedirectStdout()));
            desc.setShutdownTimeout(String.valueOf(webMain.getShutdownTimeout()));
            desc.setLogging(webMain.getLogging());
            desc.setSessionDescType(webMain.getSessionConfig());
            desc.setSessionServerType(webMain.getSessionServer());
            WebMainDescriptorJB.getContextGroup(webMain, desc);
            return desc;
        }
        catch (DescriptorException e) {
            throw new StartingException(e.getMessage(), (Throwable)(e.getCause() == null ? e : e.getCause()));
        }
        catch (IOException ioe) {
            throw new StartingException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    private static void getContextGroup(WebContainerType webMain, WebMainDescriptorJB desc) throws DescriptorException {
        List list = webMain.getContextGroup();
        for (ContextGroupType cg : list) {
            ContextGroupDescriptor cgd = new ContextGroupDescriptor();
            WebMainDescriptorJB.getWebServerConnection(cg, cgd);
            WebMainDescriptorJB.getVirtualHost(cg, cgd);
            WebMainDescriptorJB.getEncoding(cg, cgd);
            cgd.setGroupName(cg.getGroupName());
            WebMainDescriptorJB.getJspConfig(cg, cgd);
            cgd.setLogging(cg.getLogging());
            cgd.setAttachStacktraceOnError(String.valueOf(cg.isAttachStacktraceOnError()));
            cgd.setSessionDesc(cg.getSessionConfig());
            WebMainDescriptorJB.getResponseHeader(cg, cgd);
            cgd.setProperties(cg.getProperties());
            try {
                desc.addContextGroupDescriptor(cgd.getGroupName(), cgd);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_WebContainer0._1513_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer0._1513_LEVEL, JeusMessage_WebContainer0._1513, (Object)cgd.getGroupName(), (Throwable)e);
            }
        }
    }

    private static void getWebServerConnection(ContextGroupType cg, ContextGroupDescriptor cgDesc) throws DescriptorException {
        WebserverConnectionType wc = cg.getWebserverConnection();
        List listeners = wc.getWebtobListenerOrHttpListenerOrTcpListener();
        for (Object o : listeners) {
            ThreadStateNotifyDescriptor tsnDesc;
            ThreadStateNotifyType tsn;
            ThreadPoolDescriptor tpoolDesc;
            ThreadPoolType tpool;
            Iterator it3;
            List allowedServer;
            Ajp13ListenerType listener;
            ConnectionDescriptor cDesc = new ConnectionDescriptor();
            if (o instanceof Ajp13ListenerType) {
                listener = (Ajp13ListenerType)o;
                cDesc.setAccessControl(String.valueOf(listener.isServerAccessControl()));
                allowedServer = listener.getAllowedServer();
                if (allowedServer != null) {
                    it3 = allowedServer.iterator();
                    while (it3.hasNext()) {
                        cDesc.addAllowedServer((String)it3.next());
                    }
                }
                cDesc.setBacklog(String.valueOf(listener.getBackLog()));
                cDesc.setListenerId(listener.getListenerId());
                cDesc.setListenerType("Ajp13Listener");
                cDesc.setOutputBufferSize(String.valueOf(listener.getOutputBufferSize()));
                cDesc.setPort(String.valueOf(listener.getPort()));
                cDesc.setPostdataReadTimeout(String.valueOf(listener.getPostdataReadTimeout()));
                cDesc.setScheme(listener.getScheme().value());
                tpool = listener.getThreadPool();
                tpoolDesc = new ThreadPoolDescriptor();
                tpoolDesc.setThreadPoolType(tpool);
                tpoolDesc.setChangingRate(String.valueOf(tpool.getStep()));
                tpoolDesc.setMaxIdleTime(String.valueOf(tpool.getMaxIdleTime()));
                tpoolDesc.setMaxQueue(String.valueOf(tpool.getMaxQueue()));
                tpoolDesc.setMaxThreadNum(String.valueOf(tpool.getMax()));
                tpoolDesc.setMaxWaitQueue(String.valueOf(tpool.getMaxWaitQueue()));
                tpoolDesc.setMinThreadNum(String.valueOf(tpool.getMin()));
                tsn = tpool.getThreadStateNotify();
                if (tsn != null) {
                    tsnDesc = new ThreadStateNotifyDescriptor();
                    tsnDesc.setMaxThreadActiveTime(String.valueOf(tsn.getMaxThreadActiveTime()));
                    tsnDesc.setNotifySubject(tsn.getNotifySubject());
                    tsnDesc.setNotifyThreshold(String.valueOf(tsn.getNotifyThresholdRatio()));
                    tsnDesc.setRestartSubject(tsn.getRestartSubject());
                    tsnDesc.setRestartThreshold(String.valueOf(tsn.getRestartThresholdRatio()));
                    tpoolDesc.setThreadStateNotifyDescriptor(tsnDesc);
                    tsnDesc.setThreadThreadNotifyType(tsn);
                }
                cDesc.setThreadPoolDescriptor(tpoolDesc);
                cgDesc.addConnectionDescriptor(cDesc.getListenerId(), cDesc);
                continue;
            }
            if (o instanceof HttpListenerType) {
                listener = (HttpListenerType)o;
                cDesc.setUseNIO(listener.isUseNio());
                cDesc.setSelectorCount(String.valueOf(listener.getSelectorCount()));
                cDesc.setAccessControl(String.valueOf(listener.isServerAccessControl()));
                allowedServer = listener.getAllowedServer();
                if (allowedServer != null) {
                    it3 = allowedServer.iterator();
                    while (it3.hasNext()) {
                        cDesc.addAllowedServer((String)it3.next());
                    }
                }
                cDesc.setBacklog(String.valueOf(listener.getBackLog()));
                cDesc.setListenerId(listener.getListenerId());
                cDesc.setListenerType("HttpListener");
                cDesc.setOutputBufferSize(String.valueOf(listener.getOutputBufferSize()));
                cDesc.setPort(String.valueOf(listener.getPort()));
                cDesc.setReadTimeout(String.valueOf(listener.getReadTimeout()));
                cDesc.setPostdataReadTimeout(String.valueOf(listener.getPostdataReadTimeout()));
                cDesc.setScheme(listener.getScheme().value());
                cDesc.setIsKeepAlive(listener.isKeepAlive());
                cDesc.setMaxKeepAliveRequests(listener.getMaxKeepAliveRequest());
                tpool = listener.getThreadPool();
                tpoolDesc = new ThreadPoolDescriptor();
                cDesc.setReadTimeout(String.valueOf(listener.getReadTimeout()));
                tpoolDesc.setThreadPoolType(tpool);
                tpoolDesc.setChangingRate(String.valueOf(tpool.getStep()));
                tpoolDesc.setMaxIdleTime(String.valueOf(tpool.getMaxIdleTime()));
                tpoolDesc.setMaxQueue(String.valueOf(tpool.getMaxQueue()));
                tpoolDesc.setMaxThreadNum(String.valueOf(tpool.getMax()));
                tpoolDesc.setMaxWaitQueue(String.valueOf(tpool.getMaxWaitQueue()));
                tpoolDesc.setMinThreadNum(String.valueOf(tpool.getMin()));
                tsn = tpool.getThreadStateNotify();
                if (tsn != null) {
                    tsnDesc = new ThreadStateNotifyDescriptor();
                    tsnDesc.setMaxThreadActiveTime(String.valueOf(tsn.getMaxThreadActiveTime()));
                    tsnDesc.setNotifySubject(tsn.getNotifySubject());
                    tsnDesc.setNotifyThreshold(String.valueOf(tsn.getNotifyThresholdRatio()));
                    tsnDesc.setRestartSubject(tsn.getRestartSubject());
                    tsnDesc.setRestartThreshold(String.valueOf(tsn.getRestartThresholdRatio()));
                    tpoolDesc.setThreadStateNotifyDescriptor(tsnDesc);
                    tsnDesc.setThreadThreadNotifyType(tsn);
                }
                cDesc.setThreadPoolDescriptor(tpoolDesc);
                SslConfigType sslConfigType = listener.getSslConfig();
                if (sslConfigType != null) {
                    listener.setScheme(SchemeType.HTTPS);
                    WebMainDescriptorJB.configSSL(sslConfigType, cDesc);
                }
                cgDesc.addConnectionDescriptor(cDesc.getListenerId(), cDesc);
                continue;
            }
            if (o instanceof TcpListenerType) {
                listener = (TcpListenerType)o;
                cDesc.setUseNIO(listener.isUseNio());
                cDesc.setSelectorCount(String.valueOf(listener.getSelectorCount()));
                cDesc.setAccessControl(String.valueOf(listener.isServerAccessControl()));
                allowedServer = listener.getAllowedServer();
                if (allowedServer != null) {
                    it3 = allowedServer.iterator();
                    while (it3.hasNext()) {
                        cDesc.addAllowedServer((String)it3.next());
                    }
                }
                cDesc.setBacklog(String.valueOf(listener.getBackLog()));
                cDesc.setListenerId(listener.getListenerId());
                cDesc.setListenerType("TCPListener");
                cDesc.setOutputBufferSize(String.valueOf(listener.getOutputBufferSize()));
                cDesc.setPort(String.valueOf(listener.getPort()));
                cDesc.setPostdataReadTimeout(String.valueOf(listener.getPostdataReadTimeout()));
                cDesc.setScheme(listener.getScheme().value());
                SslConfigType sslConfigType = listener.getSslConfig();
                if (sslConfigType != null) {
                    WebMainDescriptorJB.configSSL(sslConfigType, cDesc);
                }
                ThreadPoolType tpool2 = listener.getThreadPool();
                ThreadPoolDescriptor tpoolDesc2 = new ThreadPoolDescriptor();
                tpoolDesc2.setThreadPoolType(tpool2);
                tpoolDesc2.setChangingRate(String.valueOf(tpool2.getStep()));
                tpoolDesc2.setMaxIdleTime(String.valueOf(tpool2.getMaxIdleTime()));
                tpoolDesc2.setMaxQueue(String.valueOf(tpool2.getMaxQueue()));
                tpoolDesc2.setMaxThreadNum(String.valueOf(tpool2.getMax()));
                tpoolDesc2.setMaxWaitQueue(String.valueOf(tpool2.getMaxWaitQueue()));
                tpoolDesc2.setMinThreadNum(String.valueOf(tpool2.getMin()));
                ThreadStateNotifyType tsn2 = tpool2.getThreadStateNotify();
                if (tsn2 != null) {
                    ThreadStateNotifyDescriptor tsnDesc2 = new ThreadStateNotifyDescriptor();
                    tsnDesc2.setMaxThreadActiveTime(String.valueOf(tsn2.getMaxThreadActiveTime()));
                    tsnDesc2.setNotifySubject(tsn2.getNotifySubject());
                    tsnDesc2.setNotifyThreshold(String.valueOf(tsn2.getNotifyThresholdRatio()));
                    tsnDesc2.setRestartSubject(tsn2.getRestartSubject());
                    tsnDesc2.setRestartThreshold(String.valueOf(tsn2.getRestartThresholdRatio()));
                    tpoolDesc2.setThreadStateNotifyDescriptor(tsnDesc2);
                    tsnDesc2.setThreadThreadNotifyType(tsn2);
                }
                cDesc.setThreadPoolDescriptor(tpoolDesc2);
                cDesc.setDispatcherConfigClass(listener.getDispatcherConfigClass());
                cgDesc.addConnectionDescriptor(cDesc.getListenerId(), cDesc);
                continue;
            }
            if (o instanceof WebtobListenerType) {
                listener = (WebtobListenerType)o;
                cDesc.setListenerId(listener.getListenerId());
                cDesc.setListenerType("WebtobListener");
                cDesc.setOutputBufferSize(String.valueOf(listener.getOutputBufferSize()));
                cDesc.setPort(String.valueOf(listener.getPort()));
                cDesc.setPostdataReadTimeout(String.valueOf(listener.getPostdataReadTimeout()));
                cDesc.setScheme(listener.getScheme().value());
                ThreadPoolType tpool3 = listener.getThreadPool();
                ThreadPoolDescriptor tpoolDesc3 = new ThreadPoolDescriptor();
                tpoolDesc3.setThreadPoolType(tpool3);
                tpoolDesc3.setChangingRate(String.valueOf(tpool3.getStep()));
                tpoolDesc3.setMaxIdleTime(String.valueOf(tpool3.getMaxIdleTime()));
                tpoolDesc3.setMaxQueue(String.valueOf(tpool3.getMaxQueue()));
                tpoolDesc3.setMaxThreadNum(String.valueOf(tpool3.getMax()));
                tpoolDesc3.setMaxWaitQueue(String.valueOf(tpool3.getMaxWaitQueue()));
                tpoolDesc3.setMinThreadNum(String.valueOf(tpool3.getMin()));
                ThreadStateNotifyType tsn3 = tpool3.getThreadStateNotify();
                if (tsn3 != null) {
                    ThreadStateNotifyDescriptor tsnDesc3 = new ThreadStateNotifyDescriptor();
                    tsnDesc3.setMaxThreadActiveTime(String.valueOf(tsn3.getMaxThreadActiveTime()));
                    tsnDesc3.setNotifySubject(tsn3.getNotifySubject());
                    tsnDesc3.setNotifyThreshold(String.valueOf(tsn3.getNotifyThresholdRatio()));
                    tsnDesc3.setRestartSubject(tsn3.getRestartSubject());
                    tsnDesc3.setRestartThreshold(String.valueOf(tsn3.getRestartThresholdRatio()));
                    tpoolDesc3.setThreadStateNotifyDescriptor(tsnDesc3);
                    tsnDesc3.setThreadThreadNotifyType(tsn3);
                }
                cDesc.setThreadPoolDescriptor(tpoolDesc3);
                cDesc.setConnectionPortNum(String.valueOf(listener.getHthCount()));
                cDesc.setDisablePipe(String.valueOf(listener.isDisablePipe()));
                cDesc.setWebServerAddress(listener.getWebtobAddress());
                cDesc.setWebtobHome(listener.getWebtobHome());
                cDesc.setRegistrationId(listener.getRegistrationId());
                cDesc.setRequestPrefetch(listener.isRequestPrefetch());
                cDesc.setWebtobIpcbaseport(String.valueOf(listener.getWebtobIpcbaseport()));
                cDesc.setReadTimeout(String.valueOf(listener.getReadTimeout()));
                cDesc.setReconnectTimeout(String.valueOf(listener.getReconnectTimeout()));
                WebMainDescriptorJB.getWebtobBackup((WebtobListenerType)listener, cDesc);
                cgDesc.addConnectionDescriptor(cDesc.getListenerId(), cDesc);
                continue;
            }
            if (!(o instanceof TmaxListenerType)) continue;
            listener = (TmaxListenerType)o;
            cDesc.setUseNIO(listener.isUseNio());
            cDesc.setSelectorCount(String.valueOf(listener.getSelectorCount()));
            cDesc.setListenerId(listener.getListenerId());
            cDesc.setListenerType("TmaxListener");
            cDesc.setOutputBufferSize(String.valueOf(listener.getOutputBufferSize()));
            cDesc.setPort(String.valueOf(listener.getPort()));
            cDesc.setPostdataReadTimeout(String.valueOf(listener.getPostdataReadTimeout()));
            cDesc.setWebServerAddress(String.valueOf(listener.getTmaxAddress()));
            cDesc.setServerGroupName(String.valueOf(listener.getServerGroupName()));
            cDesc.setServerName(String.valueOf(listener.getServerName()));
            cDesc.setServerType(String.valueOf(listener.getServerType()));
            cDesc.setTmaxVersion(String.valueOf(listener.getTmaxVersion()));
            cDesc.setXAResourceClass(listener.getXaresourceClass());
            cDesc.setTmaxBackupAddress(String.valueOf(listener.getTmaxBackupAddress()));
            cDesc.setTmaxBackupPort(String.valueOf(listener.getTmaxBackupPort()));
            String backupAddress = String.valueOf(listener.getTmaxBackupAddress());
            if (!backupAddress.equals("null") && !backupAddress.equals("")) {
                ConnectionDescriptor backupConnDesc = new ConnectionDescriptor();
                backupConnDesc.setListenerType("TmaxListener");
                backupConnDesc.setListenerId(listener.getListenerId());
                backupConnDesc.setWebServerAddress(backupAddress);
                if (listener.isSetTmaxBackupPort()) {
                    backupConnDesc.setPort(String.valueOf(cDesc.getTmaxBackupPort()));
                }
                backupConnDesc.setOutputBufferSize(String.valueOf(listener.getOutputBufferSize()));
                backupConnDesc.setPostdataReadTimeout(String.valueOf(listener.getPostdataReadTimeout()));
                backupConnDesc.setReconnectTimeout(String.valueOf(listener.getReconnectTimeout()));
                backupConnDesc.setServerGroupName(String.valueOf(cDesc.getServerGroupName()));
                backupConnDesc.setServerName(String.valueOf(cDesc.getServerName()));
                cDesc.addBackupServerDescriptor(backupConnDesc);
            }
            tpool = listener.getThreadPool();
            tpoolDesc = new ThreadPoolDescriptor();
            tpoolDesc.setThreadPoolType(tpool);
            tpoolDesc.setChangingRate(String.valueOf(tpool.getStep()));
            tpoolDesc.setMaxIdleTime(String.valueOf(tpool.getMaxIdleTime()));
            tpoolDesc.setMaxQueue(String.valueOf(tpool.getMaxQueue()));
            tpoolDesc.setMaxThreadNum(String.valueOf(tpool.getMax()));
            tpoolDesc.setMaxWaitQueue(String.valueOf(tpool.getMaxWaitQueue()));
            tpoolDesc.setMinThreadNum(String.valueOf(tpool.getMin()));
            tsn = tpool.getThreadStateNotify();
            if (tsn != null) {
                tsnDesc = new ThreadStateNotifyDescriptor();
                tsnDesc.setMaxThreadActiveTime(String.valueOf(tsn.getMaxThreadActiveTime()));
                tsnDesc.setNotifySubject(tsn.getNotifySubject());
                tsnDesc.setNotifyThreshold(String.valueOf(tsn.getNotifyThresholdRatio()));
                tsnDesc.setRestartSubject(tsn.getRestartSubject());
                tsnDesc.setRestartThreshold(String.valueOf(tsn.getRestartThresholdRatio()));
                tpoolDesc.setThreadStateNotifyDescriptor(tsnDesc);
                tsnDesc.setThreadThreadNotifyType(tsn);
            }
            cDesc.setThreadPoolDescriptor(tpoolDesc);
            cDesc.setDispatcherConfigClass(listener.getDispatcherConfigClass());
            cgDesc.addConnectionDescriptor(cDesc.getListenerId(), cDesc);
        }
    }

    private static void configSSL(SslConfigType sslConfig, ConnectionDescriptor cDesc) throws DescriptorException {
        cDesc.setEnableSecure(sslConfig.isEnableSecure());
        cDesc.setClientAuth(sslConfig.getClientAuth());
        cDesc.setKeyAlias(sslConfig.getKeyAlias());
        cDesc.setSslProtocol(sslConfig.getSslProtocol());
        cDesc.setCipherSuites(sslConfig.getCipherSuite());
        cDesc.setKeyStoreFile(SSLSupport.getSSLConfigValue(sslConfig.getKeystoreFile(), "jeus.ssl.keystore", "javax.net.ssl.keyStore", 1));
        cDesc.setKeyStorePass(SSLSupport.getSSLConfigValue(sslConfig.getKeystorePass(), "jeus.ssl.keypass", "javax.net.ssl.keyStorePassword", 2));
        cDesc.setKeyStoreType(SSLSupport.getSSLConfigValue(sslConfig.getKeystoreType(), null, "javax.net.ssl.keyStoreType", 3));
        cDesc.setKeyManagementAlgorithm(SSLSupport.getSSLConfigValue(sslConfig.getKeyManagementAlgorithm(), null, "ssl.KeyManagerFactory.algorithm", 4));
        cDesc.setKeypassword(SSLSupport.getSSLConfigValue(sslConfig.getKeystoreKeypassword(), "jeus.ssl.keypass", "javax.net.ssl.keyStorePassword", 2));
        cDesc.setTrustStoreFile(SSLSupport.getSSLConfigValue(sslConfig.getTruststoreFile(), "jeus.ssl.truststore", "javax.net.ssl.trustStore", 5));
        cDesc.setTrustStorePass(SSLSupport.getSSLConfigValue(sslConfig.getTruststorePass(), "jeus.ssl.trustpass", "javax.net.ssl.trustStorePassword", 6));
        cDesc.setTrustStoreType(SSLSupport.getSSLConfigValue(sslConfig.getTruststoreType(), null, "javax.net.ssl.trustStoreType", 7));
        cDesc.setTrustManagementAlgorithm(SSLSupport.getSSLConfigValue(sslConfig.getTrustManagementAlgorithm(), null, "ssl.TrustManagerFactory.algorithm", 8));
        cDesc.setCrlFile(sslConfig.getCrlFile());
    }

    private static void getWebtobBackup(WebtobListenerType webtob, ConnectionDescriptor cDesc) throws DescriptorException {
        List list = webtob.getWebtobBackup();
        if (list != null) {
            for (WebtobBackupType backup : list) {
                ConnectionDescriptor bDesc = new ConnectionDescriptor();
                bDesc.setListenerType("WebtobListener");
                bDesc.setOutputBufferSize(String.valueOf(backup.getOutputBufferSize()));
                bDesc.setPort(String.valueOf(backup.getPort()));
                bDesc.setPostdataReadTimeout(String.valueOf(backup.getPostdataReadTimeout()));
                bDesc.setScheme(backup.getScheme().value());
                ThreadPoolType tpool = backup.getThreadPool();
                if (tpool != null) {
                    ThreadPoolDescriptor tpoolDesc = new ThreadPoolDescriptor();
                    tpoolDesc.setThreadPoolType(tpool);
                    tpoolDesc.setChangingRate(String.valueOf(tpool.getStep()));
                    tpoolDesc.setMaxIdleTime(String.valueOf(tpool.getMaxIdleTime()));
                    tpoolDesc.setMaxQueue(String.valueOf(tpool.getMaxQueue()));
                    tpoolDesc.setMaxThreadNum(String.valueOf(tpool.getMax()));
                    tpoolDesc.setMaxWaitQueue(String.valueOf(tpool.getMaxWaitQueue()));
                    tpoolDesc.setMinThreadNum(String.valueOf(tpool.getMin()));
                    ThreadStateNotifyType tsn = tpool.getThreadStateNotify();
                    if (tsn != null) {
                        ThreadStateNotifyDescriptor tsnDesc = new ThreadStateNotifyDescriptor();
                        tsnDesc.setMaxThreadActiveTime(String.valueOf(tsn.getMaxThreadActiveTime()));
                        tsnDesc.setNotifySubject(tsn.getNotifySubject());
                        tsnDesc.setNotifyThreshold(String.valueOf(tsn.getNotifyThresholdRatio()));
                        tsnDesc.setRestartSubject(tsn.getRestartSubject());
                        tsnDesc.setRestartThreshold(String.valueOf(tsn.getRestartThresholdRatio()));
                        tpoolDesc.setThreadStateNotifyDescriptor(tsnDesc);
                    }
                    bDesc.setThreadPoolDescriptor(tpoolDesc);
                }
                bDesc.setConnectionPortNum(String.valueOf(backup.getHthCount()));
                bDesc.setDisablePipe(String.valueOf(backup.isDisablePipe()));
                bDesc.setWebServerAddress(backup.getWebtobAddress());
                bDesc.setWebtobHome(backup.getWebtobHome());
                bDesc.setRegistrationId(backup.getRegistrationId());
                bDesc.setReadTimeout(String.valueOf(backup.getReadTimeout()));
                bDesc.setReconnectTimeout(String.valueOf(backup.getReconnectTimeout()));
                cDesc.addBackupServerDescriptor(bDesc);
            }
        }
    }

    private static void getVirtualHost(ContextGroupType cg, ContextGroupDescriptor cgd) throws DescriptorException {
        List l = cg.getVirtualHost();
        if (l != null) {
            for (VirtualHostType vh : l) {
                VirtualHostDescriptor vhd = new VirtualHostDescriptor();
                vhd.setVirtualHostName(vh.getVirtualHostName());
                vhd.setProperties(vh.getProperties());
                List l2 = vh.getHostList();
                if (l2 != null) {
                    Iterator it2 = l2.iterator();
                    while (it2.hasNext()) {
                        vhd.addHostName((String)it2.next());
                    }
                }
                cgd.addVirtualHostDescriptor(vhd);
            }
        }
    }

    private static void getEncoding(ContextGroupType cg, ContextGroupDescriptor cgd) {
        EncodingType e = cg.getEncoding();
        if (e != null) {
            EncodingSubType response;
            EncodingSubType request;
            EncodingSubType requestUrl = e.getRequestUrlEncoding();
            if (requestUrl != null) {
                cgd.setDefaultRequestUrlEncoding(requestUrl.getDefault());
                cgd.setForcedRequestUrlEncoding(requestUrl.getForced());
            }
            if ((request = e.getRequestEncoding()) != null) {
                cgd.setDefaultRequestEncoding(request.getDefault());
                cgd.setForcedRequestEncoding(request.getForced());
            }
            if ((response = e.getResponseEncoding()) != null) {
                cgd.setDefaultResponseEncoding(response.getDefault());
                cgd.setForcedResponseEncoding(response.getForced());
            }
        }
    }

    private static void getEncoding(EncodingType e, ConnectionDescriptor cd) {
        if (e != null) {
            EncodingSubType response;
            EncodingSubType request;
            EncodingSubType requestUrl = e.getRequestUrlEncoding();
            if (requestUrl != null) {
                cd.setDefaultRequestUrlEncoding(requestUrl.getDefault());
                cd.setForcedRequestUrlEncoding(requestUrl.getForced());
            }
            if ((request = e.getRequestEncoding()) != null) {
                cd.setDefaultRequestEncoding(request.getDefault());
                cd.setForcedRequestEncoding(request.getForced());
            }
            if ((response = e.getResponseEncoding()) != null) {
                cd.setDefaultResponseEncoding(response.getDefault());
                cd.setForcedResponseEncoding(response.getForced());
            }
        }
    }

    private static void getJspConfig(ContextGroupType cg, ContextGroupDescriptor cgd) {
        JspEngineType j = cg.getJspEngine();
        if (j != null) {
            Hashtable<String, String> t = new Hashtable<String, String>();
            String value = j.getCompileEncoding();
            if (value != null) {
                t.put("CompileEncoding", value);
            }
            if ((value = j.getCompileOption()) != null) {
                t.put("CompileOption", value);
            }
            if ((value = j.getCompileOutputDir()) != null) {
                t.put("CompileOutputDir", value);
            }
            if ((value = j.getJavaCompiler()) != null) {
                t.put("JavaCompiler", value);
            }
            if ((value = j.getJspWorkDir()) != null) {
                t.put("JspWorkDir", value);
            }
            if (j.isSetKeepGenerated()) {
                t.put("KeepGenerated", String.valueOf(j.isKeepGenerated()));
            }
            if (j.isSetCheckIncludedJspfile()) {
                t.put("CheckIncludedJspFile", String.valueOf(j.isCheckIncludedJspfile()));
            }
            cgd.setJspConfig(t);
        }
    }

    private static void getResponseHeader(ContextGroupType cg, ContextGroupDescriptor cgd) throws DescriptorException {
        ResponseHeaderType rh = cg.getResponseHeader();
        if (rh != null) {
            List l;
            ResponseHeaderDescriptor d = new ResponseHeaderDescriptor();
            CustomHeaderType ch = rh.getCustomHeader();
            if (ch != null && (l = ch.getHeaderField()) != null) {
                for (HeaderFieldType hf : l) {
                    d.addCustomHeaderField(hf.getFieldName(), hf.getFieldValue());
                }
            }
            cgd.setResponseHeaderDescriptor(d);
        }
    }

    public SessionConfigType getSessionDescType() {
        return this.sessionDescType;
    }

    public void setSessionDescType(SessionConfigType sessionDescType) {
        this.sessionDescType = sessionDescType;
    }

    public SessionServerType getSessionServerType() {
        return this.sessionServerType;
    }

    public void setSessionServerType(SessionServerType sessionServerType) {
        this.sessionServerType = sessionServerType;
    }
}

