/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.ServletInputStreamImpl;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.io.Ajp13InputStream;
import jeus.servlet.engine.io.Ajp13OutputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.trace.GID;

public class Ajp13ServletRequest
extends HttpServletRequestImpl {
    public static final String[] METHOD_ARRAY = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH", "MKWORKSPACE", "UPDATE", "LABEL", "MERGE", "BASELINE-CONTROL", "MKACTIVITY"};
    public static final int SC_REQ_ACCEPT = 1;
    public static final int SC_REQ_ACCEPT_CHARSET = 2;
    public static final int SC_REQ_ACCEPT_ENCODING = 3;
    public static final int SC_REQ_ACCEPT_LANGUAGE = 4;
    public static final int SC_REQ_AUTHORIZATION = 5;
    public static final int SC_REQ_CONNECTION = 6;
    public static final int SC_REQ_CONTENT_TYPE = 7;
    public static final int SC_REQ_CONTENT_LENGTH = 8;
    public static final int SC_REQ_COOKIE = 9;
    public static final int SC_REQ_COOKIE2 = 10;
    public static final int SC_REQ_HOST = 11;
    public static final int SC_REQ_PRAGMA = 12;
    public static final int SC_REQ_REFERER = 13;
    public static final int SC_REQ_USER_AGENT = 14;
    public static final String[] HEADER_ARRAY = new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "connection", "content-type", "content-length", "cookie", "cookie2", "host", "pragma", "referer", "user-agent"};
    public static final byte SC_A_CONTEXT = 1;
    public static final byte SC_A_SERVLET_PATH = 2;
    public static final byte SC_A_REMOTE_USER = 3;
    public static final byte SC_A_AUTH_TYPE = 4;
    public static final byte SC_A_QUERY_STRING = 5;
    public static final byte SC_A_JVM_ROUTE = 6;
    public static final byte SC_A_SSL_CERT = 7;
    public static final byte SC_A_SSL_CIPHER = 8;
    public static final byte SC_A_SSL_SESSION = 9;
    public static final byte SC_A_SSL_KEY_SIZE = 11;
    public static final byte SC_A_SECRET = 12;
    public static final byte SC_A_REQ_ATTRIBUTE = 10;
    public static final byte SC_A_ARE_DONE = -1;
    private Ajp13InputStream ajp13in;
    private Ajp13OutputStream ajp13out;

    Ajp13ServletRequest(ContextGroup ctxGroup, ThreadPoolManager manager, Ajp13OutputStream o) {
        super(ctxGroup, manager);
        this.ajp13out = o;
    }

    public int readRequest(int readTimeout, int postdataReadTimeout) throws IOException, InterruptedException {
        block23: {
            if (readTimeout >= 0) {
                try {
                    if (this.socket != null) {
                        this.socket.setSoTimeout(readTimeout);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (postdataReadTimeout > 0) {
                try {
                    if (this.socket != null) {
                        this.socket.setSoTimeout(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.ajp13in.parseRequestHeader(this);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3259_LEVEL)) break block23;
                logger.log(JeusMessage_WebContainer2._3259_LEVEL, JeusMessage_WebContainer2._3259, (Throwable)e);
            }
        }
        this.processCommonRequest(this.requestURI, null, null);
        GID gid = new GID();
        GID.setCurrentGID(gid);
        GID.increaseSeqNumber();
        int clen = this.getContentLength();
        if (clen > 0) {
            this.in.setLimit(clen);
        } else {
            this.in.setLimit(0);
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3260_LEVEL)) {
            StringBuffer buf = new StringBuffer();
            buf.append("\trequest-uri  : " + this.requestURI + StringUtil.lineSeparator);
            buf.append("\tquery-string : " + this.queryString + StringUtil.lineSeparator);
            buf.append("\tserver-name  : " + this.getServerName() + StringUtil.lineSeparator);
            buf.append("\tprotocol     : " + this.protocol + StringUtil.lineSeparator);
            buf.append("\tcontent-len  : " + this.contentLength + StringUtil.lineSeparator);
            Enumeration enum1 = this.headers3.keys();
            while (enum1.hasMoreElements()) {
                String name1 = (String)enum1.nextElement();
                Vector values = (Vector)this.headers3.get(name1);
                Enumeration enum2 = values.elements();
                while (enum2.hasMoreElements()) {
                    String value1 = (String)enum2.nextElement();
                    buf.append("\theaders      : " + name1 + ":" + value1 + StringUtil.lineSeparator);
                }
            }
            if (logger.isLoggable(JeusMessage_WebContainer2._3260_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3260_LEVEL, JeusMessage_WebContainer2._3260, (Object)buf.toString());
            }
        }
        if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(postdataReadTimeout);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 1;
    }

    public void parse() {
        boolean isSSL = false;
        byte methodCode = this.ajp13in.getByte();
        this.method.setString(METHOD_ARRAY[methodCode - 1]);
        this.protocol.setString(this.ajp13in.getString());
        this.requestURI.setString(this.ajp13in.getString("ISO-8859-1"));
        this.remoteAddr = this.ajp13in.getString();
        this.remoteHost = this.ajp13in.getString();
        this.ajp13in.getString();
        this.serverPort = this.ajp13in.getShort();
        isSSL = this.ajp13in.getBool();
        this.scheme = isSSL ? "https" : "http";
        int hcnt = this.ajp13in.getShort();
        for (int i = 0; i < hcnt; ++i) {
            String name = null;
            String value = null;
            int isc = this.ajp13in.peekShort();
            int hid = isc & 0xFF;
            if ((isc &= 0xFF00) == 40960) {
                this.ajp13in.getShort();
                name = HEADER_ARRAY[hid - 1];
                value = this.ajp13in.getString("ISO-8859-1");
                this.addHeader(name, value);
                continue;
            }
            name = this.ajp13in.getString("ISO-8859-1");
            value = this.ajp13in.getString("ISO-8859-1");
            this.addHeader(name, value);
        }
        byte attributeCode = this.ajp13in.getByte();
        while (attributeCode != -1) {
            switch (attributeCode) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.remoteUser = this.ajp13in.getString();
                    break;
                }
                case 4: {
                    this.authType = this.ajp13in.getString();
                    break;
                }
                case 5: {
                    this.queryString.setString(this.ajp13in.getString("ISO-8859-1"));
                    break;
                }
                case 6: {
                    this.ajp13in.getString();
                    break;
                }
                case 7: {
                    this.ajp13in.getString();
                    break;
                }
                case 8: {
                    this.ajp13in.getString();
                    break;
                }
                case 12: {
                    this.ajp13in.getString();
                    break;
                }
                case 9: {
                    this.ajp13in.getString();
                    break;
                }
                case 10: {
                    String attrName = this.ajp13in.getString();
                    String attrValue = this.ajp13in.getString();
                    this.setAttribute(attrName, attrValue);
                    break;
                }
                case 11: {
                    this.ajp13in.getShort();
                    break;
                }
                default: {
                    this.ajp13in.getString();
                }
            }
            attributeCode = this.ajp13in.getByte();
        }
    }

    public void setSocket(Socket soc) throws IOException {
        if (soc != null) {
            try {
                this.socket = soc;
                this.ajp13in = new Ajp13InputStream(soc.getInputStream(), this.ajp13out);
                this.in = new ServletInputStreamImpl(this.ajp13in);
                this.remoteAddr = this.socket.getInetAddress().getHostAddress();
                this.remotePort = this.socket.getPort();
            }
            catch (IOException ioe) {
                String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3420);
                throw new IOException(msg);
            }
        }
    }

    public void copySocket(HttpServletRequestImpl copy) {
        if (copy == null) {
            return;
        }
        if (!(copy instanceof Ajp13ServletRequest)) {
            return;
        }
        Ajp13ServletRequest copyAjp13Req = (Ajp13ServletRequest)copy;
        this.socket = copyAjp13Req.socket;
        this.ajp13in = copyAjp13Req.ajp13in;
        this.in = copyAjp13Req.in;
        if (this.socket != null) {
            this.remoteAddr = this.socket.getInetAddress().getHostAddress();
            this.remotePort = this.socket.getPort();
        }
    }

    public int getRemotePort() {
        return -1;
    }
}

