/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import jeus.descriptor.ejb.JNDIInfo;
import jeus.descriptor.tool.EJBReference;
import jeus.descriptor.tool.EnvironEntry;
import jeus.descriptor.tool.FormLoginConfig;
import jeus.descriptor.tool.LoginConfig;
import jeus.descriptor.tool.MessageDestinationReference;
import jeus.descriptor.tool.ResourceEnvironReference;
import jeus.descriptor.tool.ResourceReference;
import jeus.descriptor.tool.SecurityConstraint;
import jeus.descriptor.tool.WEBResource;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.WebAppDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.filter.FilterDef;
import jeus.servlet.filter.FilterMap;
import jeus.servlet.filter.util.URLPattern;
import jeus.transaction.TxHelper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;

class ContextEnvironment {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    private WebAppDescriptor webAppDesc;
    private ContextDescriptor contextDesc;
    private String contextName;
    private EJBReference[] ejbReferences;
    private EJBReference[] ejbLocalReferences;
    private EnvironEntry[] envEntries;
    private ResourceReference[] resourceReferences;
    private ResourceEnvironReference[] resourceEnvRefs;
    private MessageDestinationReference[] messageDestRefs;
    private String envRoot;
    private Vector[] contextEnvs;
    private Vector protectedResources;
    private FilterDef loginFilterDef;
    private ArrayList loginFilterMaps;
    public static final String LOGIN_FILTER_NAME = "JeusLoginFilter";
    public static final String LOGIN_FILTER_CLASS_NAME = "jeus.servlet.filter.LoginFilter";
    private boolean isFormBasedLogin;
    private Vector securityMap;

    ContextEnvironment(WebAppDescriptor desc, Context context) {
        this.webAppDesc = desc;
        this.loginFilterDef = null;
        this.loginFilterMaps = null;
        this.isFormBasedLogin = false;
        this.contextDesc = context.getContextDescriptor();
        this.contextName = context.getContextName();
        this.ejbReferences = desc.getEJBRefs();
        this.ejbLocalReferences = desc.getEJBLocalRefs();
        this.envEntries = desc.getEnvironEntries();
        this.resourceReferences = desc.getResourceRefs();
        this.resourceEnvRefs = desc.getResourceEnvRefs();
        this.messageDestRefs = desc.getMessageDestRefs();
        this.envRoot = context.getBindingName() + "/";
        this.contextEnvs = new Vector[6];
        for (int i = 0; i < this.contextEnvs.length; ++i) {
            this.contextEnvs[i] = null;
        }
        this.initEnvironEntries();
        this.initEJBReferences();
        this.initEJBLocalReferences();
        this.initResourceReferences();
        this.initResourceEnvReferences();
        this.initMessageDestinationReferences();
    }

    private void initEnvironEntries() {
        int size = 0;
        if (this.envEntries != null) {
            size = this.envEntries.length;
        }
        if (size > 0) {
            Vector<JNDIInfo> env = new Vector<JNDIInfo>(size);
            for (int i = 0; i < this.envEntries.length; ++i) {
                String vv;
                String name = this.envEntries[i].getName();
                String type = this.envEntries[i].getType();
                Object value = null;
                if (type == null) continue;
                value = type.equals("int") || type.equals("Integer") || type.equals("java.lang.Integer") ? Integer.valueOf(this.envEntries[i].getValue()) : (type.equals("long") || type.equals("Long") || type.equals("java.lang.Long") ? Long.valueOf(this.envEntries[i].getValue()) : (type.equals("float") || type.equals("Float") || type.equals("java.lang.Float") ? Float.valueOf(this.envEntries[i].getValue()) : (type.equals("boolean") || type.equals("Boolean") || type.equals("java.lang.Boolean") ? Boolean.valueOf(this.envEntries[i].getValue()) : (type.equals("double") || type.equals("Double") || type.equals("java.lang.Double") ? Double.valueOf(this.envEntries[i].getValue()) : (type.equals("byte") || type.equals("Byte") || type.equals("java.lang.Byte") ? Byte.valueOf(this.envEntries[i].getValue()) : (type.equals("short") || type.equals("Short") || type.equals("java.lang.Short") ? Short.valueOf(this.envEntries[i].getValue()) : (type.equals("char") || type.equals("Character") || type.equals("java.lang.Character") ? ((vv = this.envEntries[i].getValue()) == null || vv.length() == 0 ? null : new Character(vv.charAt(0))) : this.envEntries[i].getValue())))))));
                if (this.isExistingJNDIInfo(env, name)) continue;
                JNDIInfo jndiInfo = new JNDIInfo(name, value);
                env.addElement(jndiInfo);
            }
            this.contextEnvs[0] = env;
        }
    }

    private void initEJBReferences() {
        Hashtable jeusEJBRefs;
        int size = 0;
        if (this.ejbReferences != null) {
            size = this.ejbReferences.length;
        }
        if ((jeusEJBRefs = this.contextDesc.getEJBRefs()) == null || jeusEJBRefs.size() == 0) {
            return;
        }
        if (size > 0) {
            Vector<JNDIInfo> env = new Vector<JNDIInfo>(size);
            for (int i = 0; i < this.ejbReferences.length; ++i) {
                String name = this.ejbReferences[i].getName();
                String jndiName = (String)jeusEJBRefs.get(name);
                if (name == null || name.equals("")) continue;
                if (jndiName != null && !jndiName.equals("")) {
                    JNDIInfo jndiInfo = new JNDIInfo(name, jndiName);
                    if (this.isExistingJNDIInfo(env, name)) continue;
                    env.addElement(jndiInfo);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_WebContainer2._3460_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3460_LEVEL, JeusMessage_WebContainer2._3460, (Object[])new String[]{this.contextName, name});
            }
            this.contextEnvs[1] = env;
        }
    }

    private void initEJBLocalReferences() {
        Hashtable jeusEJBRefs;
        int size = 0;
        if (this.ejbLocalReferences != null) {
            size = this.ejbLocalReferences.length;
        }
        if ((jeusEJBRefs = this.contextDesc.getEJBRefs()) == null || jeusEJBRefs.size() == 0) {
            return;
        }
        if (size > 0) {
            Vector<JNDIInfo> env = new Vector<JNDIInfo>(size);
            for (int i = 0; i < this.ejbLocalReferences.length; ++i) {
                String name = this.ejbLocalReferences[i].getName();
                String jndiName = (String)jeusEJBRefs.get(name);
                if (name == null || name.equals("")) continue;
                if (jndiName != null && !jndiName.equals("")) {
                    JNDIInfo jndiInfo = new JNDIInfo(name, jndiName);
                    if (this.isExistingJNDIInfo(env, name)) continue;
                    env.addElement(jndiInfo);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_WebContainer2._3460_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3460_LEVEL, JeusMessage_WebContainer2._3460, (Object[])new String[]{this.contextName, name});
            }
            this.contextEnvs[2] = env;
        }
    }

    private void initResourceReferences() {
        Hashtable jeusResourceRefs;
        int size = 0;
        if (this.resourceReferences != null) {
            size = this.resourceReferences.length;
        }
        if ((jeusResourceRefs = this.contextDesc.getResourceRefs()) == null || jeusResourceRefs.size() == 0) {
            return;
        }
        if (size > 0) {
            Vector<JNDIInfo> env = new Vector<JNDIInfo>(size);
            for (int i = 0; i < this.resourceReferences.length; ++i) {
                String name = this.resourceReferences[i].getName();
                String jndiName = (String)jeusResourceRefs.get(name);
                if (name == null || name.equals("")) continue;
                if (jndiName != null && !jndiName.equals("")) {
                    JNDIInfo jndiInfo = new JNDIInfo(name, jndiName);
                    if (this.isExistingJNDIInfo(env, name)) continue;
                    env.addElement(jndiInfo);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_WebContainer2._3460_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3460_LEVEL, JeusMessage_WebContainer2._3460, (Object[])new String[]{this.contextName, name});
            }
            this.contextEnvs[3] = env;
        }
    }

    private void initResourceEnvReferences() {
        Hashtable jeusResourceEnvRefs;
        int size = 0;
        if (this.resourceEnvRefs != null) {
            size = this.resourceEnvRefs.length;
        }
        if ((jeusResourceEnvRefs = this.contextDesc.getResourceEnvRefs()) == null || jeusResourceEnvRefs.size() == 0) {
            return;
        }
        if (size > 0) {
            Vector<JNDIInfo> env = new Vector<JNDIInfo>(size);
            for (int i = 0; i < this.resourceEnvRefs.length; ++i) {
                String name = this.resourceEnvRefs[i].getName();
                String jndiName = (String)jeusResourceEnvRefs.get(name);
                if (name == null || name.equals("")) continue;
                if (jndiName != null && !jndiName.equals("")) {
                    JNDIInfo jndiInfo = new JNDIInfo(name, jndiName);
                    if (this.isExistingJNDIInfo(env, name)) continue;
                    env.addElement(jndiInfo);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_WebContainer2._3460_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3460_LEVEL, JeusMessage_WebContainer2._3460, (Object[])new String[]{this.contextName, name});
            }
            this.contextEnvs[4] = env;
        }
    }

    private void initMessageDestinationReferences() {
        Hashtable jeusMessageDestRefs;
        int size = 0;
        if (this.messageDestRefs != null) {
            size = this.messageDestRefs.length;
        }
        if ((jeusMessageDestRefs = this.contextDesc.getMessageDestinationRefs()) == null || jeusMessageDestRefs.size() == 0) {
            return;
        }
        if (size > 0) {
            Vector<JNDIInfo> env = new Vector<JNDIInfo>(size);
            for (int i = 0; i < this.messageDestRefs.length; ++i) {
                String name = this.messageDestRefs[i].getName();
                String jndiName = null;
                jndiName = jeusMessageDestRefs == null || jeusMessageDestRefs.size() == 0 ? "MDB_QUEUE_REPLY" : (String)jeusMessageDestRefs.get(name);
                if (name == null || name.equals("")) continue;
                if (jndiName != null && !jndiName.equals("")) {
                    JNDIInfo jndiInfo = new JNDIInfo(name, jndiName);
                    if (this.isExistingJNDIInfo(env, name)) continue;
                    env.addElement(jndiInfo);
                    continue;
                }
                if (!logger.isLoggable(JeusMessage_WebContainer2._3460_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer2._3460_LEVEL, JeusMessage_WebContainer2._3460, (Object[])new String[]{this.contextName, name});
            }
            this.contextEnvs[5] = env;
        }
    }

    private boolean isExistingJNDIInfo(Vector jndiInfos, String name) {
        if (jndiInfos == null) {
            return false;
        }
        for (int i = 0; i < jndiInfos.size(); ++i) {
            JNDIInfo jndiInfo = (JNDIInfo)jndiInfos.get(i);
            if (!jndiInfo.getRefName().equals(name)) continue;
            if (logger.isLoggable(JeusMessage_WebContainer2._3461_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3461_LEVEL, JeusMessage_WebContainer2._3461, (Object[])new String[]{this.contextName, name});
            }
            return true;
        }
        return false;
    }

    void initSecurityEnvironment() {
        SecurityConstraint[] securityConstraints = this.webAppDesc.getSecurityConstraints();
        if (securityConstraints != null && !WebContainerManager.STANDALONE_MODE) {
            if (this.protectedResources == null) {
                this.protectedResources = new Vector();
            }
            if (this.securityMap == null) {
                this.securityMap = new Vector();
            }
            for (int i = 0; i < securityConstraints.length; ++i) {
                this.initSecurityConstraint(securityConstraints[i]);
            }
            this.addLoginFilter();
        }
    }

    void destroySecurityEnvironment() {
        this.removeLoginFilter();
        if (this.securityMap != null) {
            this.securityMap.clear();
            this.securityMap = null;
        }
        if (this.protectedResources != null) {
            this.protectedResources.clear();
            this.protectedResources = null;
        }
    }

    private void initSecurityConstraint(SecurityConstraint securityConstraint) {
        WEBResource[] webResources = securityConstraint.getWEBResourceCollection();
        if (webResources == null) {
            return;
        }
        for (int i = 0; i < webResources.length; ++i) {
            String[] urlPatterns = webResources[i].getURLPatterns();
            if (urlPatterns == null) continue;
            for (int j = 0; j < urlPatterns.length; ++j) {
                if (!urlPatterns[j].startsWith("/") && !urlPatterns[j].startsWith("*.")) {
                    urlPatterns[j] = "/" + urlPatterns[j];
                }
                if (this.securityMap.contains(urlPatterns[j])) continue;
                this.securityMap.addElement(urlPatterns[j]);
            }
            if (this.securityMap.contains("/j_security_check")) continue;
            this.securityMap.addElement("/j_security_check");
        }
    }

    private void addLoginFilter() {
        this.loginFilterDef = new FilterDef();
        this.loginFilterDef.setFilterName(LOGIN_FILTER_NAME);
        this.loginFilterDef.setFilterClass(LOGIN_FILTER_CLASS_NAME);
        LoginConfig config = this.webAppDesc.getLoginConfig();
        if (config != null) {
            String authMethod = config.getAuthMethod();
            if (authMethod != null && authMethod.equalsIgnoreCase("FORM")) {
                this.loginFilterDef.addInitParameter("auth-method", "FORM");
                FormLoginConfig formLoginConfig = config.getFormLoginConfig();
                if (formLoginConfig != null) {
                    this.loginFilterDef.addInitParameter("form-login-page", formLoginConfig.getLoginPage());
                    this.loginFilterDef.addInitParameter("form-error-page", formLoginConfig.getErrorPage());
                }
                this.isFormBasedLogin = true;
            } else if (authMethod != null && authMethod.equalsIgnoreCase("DIGEST")) {
                this.loginFilterDef.addInitParameter("auth-method", "DIGEST");
                this.isFormBasedLogin = false;
            } else if (authMethod != null && authMethod.equalsIgnoreCase("CLIENT-CERT")) {
                this.loginFilterDef.addInitParameter("auth-method", "CLIENT-CERT");
                this.isFormBasedLogin = false;
            } else {
                this.loginFilterDef.addInitParameter("auth-method", "BASIC");
                this.isFormBasedLogin = false;
            }
            String realmName = config.getRealmName();
            if (realmName != null) {
                this.loginFilterDef.addInitParameter("realm-name", realmName);
            }
        } else {
            this.isFormBasedLogin = false;
            this.loginFilterDef.addInitParameter("auth-method", "BASIC");
        }
        if (this.securityMap != null) {
            this.loginFilterMaps = new ArrayList();
            Iterator iter = this.securityMap.iterator();
            while (iter.hasNext()) {
                FilterMap filterMap = new FilterMap();
                String urlPattern = (String)iter.next();
                filterMap.setFilterName(LOGIN_FILTER_NAME);
                if (!URLPattern.isValid(urlPattern)) {
                    throw new IllegalArgumentException("Invalid URL Pattern: [" + urlPattern + "]");
                }
                filterMap.setURLPattern(urlPattern);
                this.loginFilterMaps.add(filterMap);
            }
        }
    }

    public void removeLoginFilter() {
        if (this.loginFilterMaps != null) {
            this.loginFilterMaps.clear();
            this.loginFilterMaps = null;
        }
        this.loginFilterDef = null;
    }

    public FilterDef getLoginFilterDef() {
        return this.loginFilterDef;
    }

    public ArrayList getLoginFilterMaps() {
        return this.loginFilterMaps;
    }

    public boolean isFormBasedLogin() {
        return this.isFormBasedLogin;
    }

    void registerEnvironments() {
        InitialContext ctx;
        block14: {
            if (WebContainerManager.STANDALONE_MODE) {
                return;
            }
            ctx = null;
            try {
                Hashtable<String, String> envs = new Hashtable<String, String>();
                envs.put("jeus.jndi.jns.localbindings", "true");
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                ctx = new InitialContext(envs);
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3463_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3463_LEVEL, JeusMessage_WebContainer2._3463, (Object)this.contextName, t);
                }
                return;
            }
            try {
                ctx.rebind(this.envRoot + "UserTransaction", (Object)TxHelper.getUserTransaction());
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3462_LEVEL)) break block14;
                logger.log(JeusMessage_WebContainer2._3462_LEVEL, JeusMessage_WebContainer2._3462, (Object[])new String[]{this.contextName, "UserTransaction"}, ex);
            }
        }
        for (int i = 0; i < this.contextEnvs.length; ++i) {
            if (this.contextEnvs[i] == null || this.contextEnvs[i].size() == 0) continue;
            Enumeration e = this.contextEnvs[i].elements();
            while (e.hasMoreElements()) {
                JNDIInfo info = (JNDIInfo)e.nextElement();
                try {
                    if (i == 0) {
                        ctx.rebind(this.envRoot + info.getRefName(), info.getTarget());
                        continue;
                    }
                    if (i == 3 && info.getRefName().startsWith("url/")) {
                        String jndiName = (String)info.getTarget();
                        try {
                            URL url = new URL(jndiName);
                            ctx.rebind(this.envRoot + info.getRefName(), (Object)url);
                        }
                        catch (MalformedURLException ex) {
                            ctx.rebind(this.envRoot + info.getRefName(), (Object)new LinkRef(jndiName));
                        }
                        continue;
                    }
                    ctx.rebind(this.envRoot + info.getRefName(), (Object)new LinkRef((String)info.getTarget()));
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3462_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3462_LEVEL, JeusMessage_WebContainer2._3462, (Object[])new String[]{this.contextName, info.getRefName()}, ex);
                }
            }
        }
    }

    void unregisterEnvironments() {
        InitialContext ctx;
        block10: {
            if (WebContainerManager.STANDALONE_MODE) {
                return;
            }
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.localbindings", "true");
            try {
                ctx = new InitialContext(envs);
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_WebContainer2._3463_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3463_LEVEL, JeusMessage_WebContainer2._3463, (Object)this.contextName, ex);
                }
                return;
            }
            try {
                ctx.unbind(this.envRoot + "UserTransaction");
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_WebContainer2._3464_LEVEL)) break block10;
                logger.log(JeusMessage_WebContainer2._3464_LEVEL, JeusMessage_WebContainer2._3464, (Object[])new String[]{this.contextName, "UserTransaction"}, ex);
            }
        }
        for (int i = 0; i < this.contextEnvs.length; ++i) {
            if (this.contextEnvs[i] == null || this.contextEnvs[i].size() == 0) continue;
            Enumeration e = this.contextEnvs[i].elements();
            while (e.hasMoreElements()) {
                JNDIInfo info = (JNDIInfo)e.nextElement();
                try {
                    ctx.unbind(this.envRoot + info.getRefName());
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3464_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3464_LEVEL, JeusMessage_WebContainer2._3464, (Object[])new String[]{this.contextName, info.getRefName()}, ex);
                }
            }
        }
    }

    public String getEnvRoot() {
        return this.envRoot;
    }
}

