/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpUtils;
import jeus.servlet.util.FileUtil;

public class HttpServletRequestWrapperForward
extends HttpServletRequestWrapper {
    private Hashtable parameters = null;
    private String lookupPath = null;
    private String requestURI = null;
    private String servletPath = null;
    private String pathInfo = null;
    private String queryString = null;

    HttpServletRequestWrapperForward(HttpServletRequest request) {
        super(request);
        this.setRequest((ServletRequest)request);
        this.parameters = new Hashtable();
        this.parameters.putAll(this.getRequest().getParameterMap());
        this.queryString = request.getQueryString();
    }

    void addQueryString(String query) {
        if (query == null || query.trim().length() <= 0) {
            return;
        }
        this.queryString = query;
        Hashtable newParams = HttpUtils.parseQueryString((String)query);
        Enumeration e = newParams.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.parameters.put(key, newParams.get(key));
        }
    }

    void setRequestURI(String uri) {
        this.requestURI = uri;
    }

    public void setServletPath(String path) {
        this.servletPath = path;
    }

    void setLookupPath(String path) {
        this.lookupPath = path;
    }

    public void setPathInfo(String path) {
        this.pathInfo = path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return (Map)this.parameters.clone();
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/") && (path = FileUtil.catPath(this.lookupPath, path)) == null) {
            return null;
        }
        return this.getRequest().getRequestDispatcher(path);
    }
}

