/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.FixedSizeMap;
import jeus.servlet.util2.buf.MessageBytes;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;

public class RequestUtil {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    private static final String JSP_PRECOMPILE = "jsp_precompile";
    private static final String DEFAULT_HTTP_CHARSET = "ISO-8859-1";
    protected static FixedSizeMap remoteHosts = new FixedSizeMap(1000);
    private static final int BOUNDARY_READ = 1;
    private static final int HEADER_READ = 2;
    private static final int VALUE_READ = 3;
    private static final int FILE_READ = 4;
    private static final int READ_END = 5;
    private static final Hashtable map = new Hashtable();
    private static final Locale loc;
    private static final TimeZone zone;
    private static final String rfc1123Pattern = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static final String rfc1123Pattern_2 = "EEE,dd MMM yyyyy HH:mm:ss z";
    private static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String asctimePattern = "EEE MMM d HH:mm:ss yyyyy";
    private static final SimpleDateFormat rfc1123Format;
    private static final SimpleDateFormat rfc1123Format_2;
    private static final SimpleDateFormat rfc1036Format;
    private static final SimpleDateFormat asctimeFormat;

    protected static String getRemoteHost(InetAddress addr) {
        return (String)remoteHosts.get(addr);
    }

    protected static void addRemoteHost(InetAddress addr, String cached) {
        remoteHosts.put(addr, cached);
    }

    public static LinkedHashMap readFormData(HttpServletRequest request, ServletInputStream is, String encoding, boolean justClear) {
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        try {
            is = ((HttpServletRequestImpl)request).getInputStreamInternal();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (contentType != null) {
            if (contentType.startsWith("application/x-www-form-urlencoded")) {
                String encoding1 = RequestUtil.getCharsetFromContentType(contentType);
                String encoding2 = null;
                if (encoding1 == null) {
                    encoding1 = encoding;
                } else {
                    encoding2 = encoding;
                    if (encoding2 != null && encoding2.equals(encoding1)) {
                        encoding2 = null;
                    }
                }
                String tranEncoding = (String)request.getAttribute("Transfer-Encoding");
                String postData = null;
                postData = tranEncoding != null && tranEncoding.equalsIgnoreCase("chunked") ? RequestUtil.readPostDataFromStream(102400, is) : RequestUtil.readPostDataFromStream(contentLength, is);
                if (logger.isLoggable(JeusMessage_WebContainer2._3262_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3262_LEVEL, JeusMessage_WebContainer2._3262, (Object)postData);
                }
                if (justClear) {
                    return null;
                }
                if (postData == null) {
                    return null;
                }
                LinkedHashMap postParameters = new LinkedHashMap();
                if (encoding1 == null) {
                    RequestUtil.processFormData(postData, postParameters);
                } else {
                    RequestUtil.processFormData(postData, postParameters, encoding1, encoding2);
                }
                return postParameters;
            }
            if (contentType.startsWith("text/plain")) {
                return null;
            }
            if (contentType.startsWith("multipart/form-data")) {
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Hashtable readMultipartFormData(HttpServletRequest req, ServletInputStream is, String encoding, String boundary, int length) {
        request = (HttpServletRequestImpl)req;
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        count = 0;
        n = 0;
        line = new byte[1024];
        boundaryByte = boundary.getBytes();
        dashEnd = 0;
        for (i = 0; i < boundaryByte.length; ++i) {
            if (boundaryByte[i] == 45) continue;
            dashEnd = i;
            break;
        }
        result = new Hashtable<String, String[]>();
        state = 1;
        disposition = null;
        name = null;
        filename = null;
        value = null;
        tmp = null;
        tok = null;
        while (state != 5) {
            try {
                n = ((HttpServletRequestImpl)req).getInputStreamInternal().readLine(line, 0, line.length);
            }
            catch (IOException ioe) {
                state = 5;
                break;
            }
            if (n < 0) break;
            count += n;
            switch (state) {
                case 1: {
                    if (!RequestUtil.isBoundaryMatched(boundary, dashEnd, line)) {
                        state = 5;
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    name = null;
                    filename = null;
                    try {
                        disposition = new String(line, 0, n, encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!encoding.equals("ISO-8859-1")) {
                            try {
                                disposition = new String(line, 0, n, "ISO-8859-1");
                            }
                            catch (UnsupportedEncodingException e2) {
                                disposition = new String(line, 0, n);
                            }
                        }
                        disposition = new String(line, 0, n);
                    }
                    tok = new StringTokenizer(disposition, ";", false);
                    fileFound = false;
                    nameFound = false;
                    while (tok.hasMoreTokens()) {
                        token = tok.nextToken();
                        i = token.indexOf("filename=\"");
                        if (i > -1) {
                            token = token.trim();
                            filename = (token = token.substring(0, token.length() - 1)).substring(i + 9, token.length());
                            if (filename.endsWith("\n")) {
                                filename = filename.substring(0, filename.length() - 1);
                            }
                            fileFound = true;
                            continue;
                        }
                        i = token.indexOf("name=\"");
                        if (i <= -1) continue;
                        token = token.trim();
                        token = token.substring(0, token.length() - 1);
                        name = token.substring(i + 5, token.length());
                        nameFound = true;
                    }
                    state = fileFound != false ? 4 : (nameFound != false ? 3 : 5);
                    if (!fileFound && !nameFound) ** GOTO lbl82
                    try {
                        n = ((HttpServletRequestImpl)req).getInputStreamInternal().readLine(line, 0, line.length);
                        if (n > 0 && line[0] != 13) {
                            n = ((HttpServletRequestImpl)req).getInputStreamInternal().readLine(line, 0, line.length);
                        }
                    }
                    catch (IOException ioe) {
                        state = 5;
                        break;
                    }
lbl82:
                    // 3 sources

                    value = new StringBuffer();
                    break;
                }
                case 3: {
                    if (RequestUtil.isBoundaryMatched(boundary, dashEnd, line)) {
                        v = value.toString();
                        if (v.endsWith("\r\n")) {
                            v = value.substring(0, value.length() - 2);
                        }
                        if (name != null) {
                            if (result.containsKey(name)) {
                                old = (String[])result.get(name);
                                newValue = new String[old.length + 1];
                                for (j = 0; j < old.length; ++j) {
                                    newValue[j] = old[j];
                                }
                                newValue[j] = v;
                                result.put(name, newValue);
                            } else {
                                newValue = new String[]{v};
                                result.put(name, newValue);
                            }
                        }
                        if (RequestUtil.isMultipartFormDataEnd(line, n)) {
                            state = 5;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    try {
                        tmp = new String(line, 0, n, encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!encoding.equals("ISO-8859-1")) {
                            try {
                                tmp = new String(line, 0, n, "ISO-8859-1");
                            }
                            catch (UnsupportedEncodingException e2) {
                                tmp = new String(line, 0, n);
                            }
                        }
                        tmp = new String(line, 0, n);
                    }
                    value.append(tmp);
                    state = 3;
                    break;
                }
                case 4: {
                    if (RequestUtil.isBoundaryMatched(boundary, dashEnd, line)) {
                        if (name != null && filename != null) {
                            if (result.containsKey(name)) {
                                old = (String[])result.get(name);
                                newValue = new String[old.length + 1];
                                for (j = 0; j < old.length; ++j) {
                                    newValue[j] = old[j];
                                }
                                newValue[j] = filename;
                                result.put(name, newValue);
                            } else {
                                newValue = new String[]{filename};
                                result.put(name, newValue);
                            }
                        }
                        if (RequestUtil.isMultipartFormDataEnd(line, n)) {
                            state = 5;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    try {
                        tmp = new String(line, 0, n, encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!encoding.equals("ISO-8859-1")) {
                            try {
                                tmp = new String(line, 0, n, "ISO-8859-1");
                            }
                            catch (UnsupportedEncodingException e2) {
                                tmp = new String(line, 0, n);
                            }
                        }
                        tmp = new String(line, 0, n);
                    }
                    value.append(tmp);
                    state = 4;
                    break;
                }
                default: {
                    state = 5;
                }
            }
            if (count < length) continue;
            break;
        }
        return result;
    }

    private static boolean isBoundaryMatched(String boundary, int dashEnd, byte[] line) {
        int len = line.length;
        if (line[len - 1] == 10) {
            --len;
        }
        if (len < boundary.length()) {
            return false;
        }
        if (line[0] != 45) {
            return false;
        }
        String s1 = new String(line);
        return s1.indexOf(boundary) >= 0;
    }

    private static boolean isMultipartFormDataEnd(byte[] line, int len) {
        if (len <= 3) {
            return false;
        }
        return line[len - 1] == 10 && line[len - 2] == 45 && line[len - 3] == 45;
    }

    private static String readPostDataFromStream(int len, ServletInputStream in) {
        byte[] postedBytes = null;
        if (len <= 0) {
            return null;
        }
        if (in == null) {
            throw new IllegalArgumentException();
        }
        try {
            int inputLen;
            postedBytes = new byte[len];
            int offset = 0;
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = "Short Read";
                throw new IOException(msg);
            } while (len - (offset += inputLen) > 0);
        }
        catch (IOException e) {
            return null;
        }
        try {
            return new String(postedBytes, 0, len, DEFAULT_HTTP_CHARSET);
        }
        catch (UnsupportedEncodingException uee2) {
            return new String(postedBytes, 0, len);
        }
    }

    public static Hashtable mergeParameters(Hashtable one, Hashtable two) {
        if (one.size() == 0) {
            return two;
        }
        if (two.size() == 0) {
            return one;
        }
        Hashtable combined = (Hashtable)one.clone();
        Enumeration e = Collections.enumeration(two.keySet());
        while (e.hasMoreElements()) {
            String[] combinedValue;
            String name = (String)e.nextElement();
            String[] oneValue = (String[])one.get(name);
            String[] twoValue = (String[])two.get(name);
            if (oneValue == null) {
                combinedValue = twoValue;
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            combined.put(name, combinedValue);
        }
        return combined;
    }

    public static LinkedHashMap mergeParameters(LinkedHashMap one, LinkedHashMap two) {
        if (one.size() == 0) {
            return two;
        }
        if (two.size() == 0) {
            return one;
        }
        LinkedHashMap combined = (LinkedHashMap)one.clone();
        Enumeration e = Collections.enumeration(two.keySet());
        while (e.hasMoreElements()) {
            String[] combinedValue;
            String name = (String)e.nextElement();
            String[] oneValue = (String[])one.get(name);
            String[] twoValue = (String[])two.get(name);
            if (oneValue == null) {
                combinedValue = twoValue;
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            combined.put(name, combinedValue);
        }
        return combined;
    }

    public static BufferedReader getReader(HttpServletRequestImpl request, InputStream is) throws IOException {
        String encoding = request.getRequestEncoding();
        if (encoding == null) {
            encoding = DEFAULT_HTTP_CHARSET;
        }
        InputStreamReader r = new InputStreamReader(is, encoding);
        return new BufferedReader(r);
    }

    public static void processCookies(HttpServletRequest request, Vector cookies, String encoding) {
        int _versionValue;
        Enumeration _enum;
        String _versionName;
        String _pathName;
        String _domainName;
        block29: {
            Enumeration enum1 = request.getHeaders("cookie");
            _domainName = null;
            _pathName = null;
            _versionName = null;
            WebProperties props = PropertyUtil.getContextProperties();
            while (enum1.hasMoreElements()) {
                Cookie cookie;
                String value;
                String name;
                int i;
                String token;
                StringTokenizer tok;
                String cookieString = (String)enum1.nextElement();
                if (cookieString == null) continue;
                if (props.URLDECODE_COOKIE.value) {
                    tok = new StringTokenizer(cookieString, ";", false);
                    while (tok.hasMoreTokens()) {
                        token = tok.nextToken();
                        i = token.indexOf("=");
                        if (i <= -1) continue;
                        name = RequestUtil.unUrlDecode(token.substring(0, i).trim());
                        value = RequestUtil.unUrlDecode(token.substring(i + 1, token.length()).trim());
                        if (encoding != null && !encoding.equals(DEFAULT_HTTP_CHARSET)) {
                            try {
                                name = new String(name.getBytes(DEFAULT_HTTP_CHARSET), encoding);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                value = new String(value.getBytes(DEFAULT_HTTP_CHARSET), encoding);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        try {
                            cookie = new Cookie(name, value);
                            cookies.addElement(cookie);
                        }
                        catch (IllegalArgumentException iae) {
                            // empty catch block
                        }
                        if ("$Domain".equalsIgnoreCase(name)) {
                            _domainName = value;
                        }
                        if ("$Path".equalsIgnoreCase(name)) {
                            _pathName = value;
                        }
                        if (!"$Version".equalsIgnoreCase(name)) continue;
                        _versionName = value;
                    }
                    continue;
                }
                if (encoding != null && !encoding.equals(DEFAULT_HTTP_CHARSET)) {
                    byte[] cookieBytes = null;
                    try {
                        cookieBytes = cookieString.getBytes(DEFAULT_HTTP_CHARSET);
                    }
                    catch (Exception e) {
                        cookieBytes = cookieString.getBytes();
                    }
                    try {
                        cookieString = new String(cookieBytes, encoding);
                    }
                    catch (Exception e) {
                        cookieString = new String(cookieBytes);
                    }
                }
                tok = new StringTokenizer(cookieString, ";", false);
                while (tok.hasMoreTokens()) {
                    token = tok.nextToken();
                    i = token.indexOf("=");
                    if (i <= -1) continue;
                    name = token.substring(0, i).trim();
                    value = token.substring(i + 1, token.length()).trim();
                    try {
                        cookie = new Cookie(name, value);
                        cookies.addElement(cookie);
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                    if ("$Domain".equalsIgnoreCase(name)) {
                        _domainName = value;
                    }
                    if ("$Path".equalsIgnoreCase(name)) {
                        _pathName = value;
                    }
                    if (!"$Version".equalsIgnoreCase(name)) continue;
                    _versionName = value;
                }
            }
            _versionName = RequestUtil.trimBothQuotes(_versionName);
            _domainName = RequestUtil.trimBothQuotes(_domainName);
            _pathName = RequestUtil.trimBothQuotes(_pathName);
            _enum = cookies.elements();
            _versionValue = 0;
            if (_versionName != null) {
                try {
                    _versionValue = Integer.parseInt(_versionName);
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3721_LEVEL)) break block29;
                    logger.log(JeusMessage_WebContainer2._3721_LEVEL, JeusMessage_WebContainer2._3721, (Object)_versionName);
                }
            }
        }
        while (_enum.hasMoreElements()) {
            Cookie o = (Cookie)_enum.nextElement();
            if (_versionValue == 1) {
                o.setValue(RequestUtil.trimBothQuotes(o.getValue()));
            }
            if (_domainName != null) {
                o.setDomain(_domainName);
            }
            if (_pathName != null) {
                o.setPath(_pathName);
            }
            if (_versionName == null) continue;
            o.setVersion(_versionValue);
        }
    }

    private static String trimBothQuotes(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private static void processFormData(String data, LinkedHashMap parameters, String encoding1, String encoding2) {
        if (data == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(data, "&", false);
        while (tok.hasMoreTokens()) {
            String[] values;
            String pair = tok.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) continue;
            String key = RequestUtil.unUrlDecode(pair.substring(0, pos), encoding1, encoding2);
            String value = RequestUtil.unUrlDecode(pair.substring(pos + 1, pair.length()), encoding1, encoding2);
            if (parameters.containsKey(key)) {
                String[] oldValues = (String[])parameters.get(key);
                values = new String[oldValues.length + 1];
                for (int i = 0; i < oldValues.length; ++i) {
                    values[i] = oldValues[i];
                }
                values[oldValues.length] = value;
            } else {
                values = new String[]{value};
            }
            parameters.put(key, values);
        }
    }

    private static void processFormData(String data, LinkedHashMap parameters) {
        if (data == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(data, "&", false);
        while (tok.hasMoreTokens()) {
            String[] values;
            String pair = tok.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) continue;
            String key = RequestUtil.unUrlDecode(pair.substring(0, pos));
            String value = RequestUtil.unUrlDecode(pair.substring(pos + 1, pair.length()));
            if (parameters.containsKey(key)) {
                String[] oldValues = (String[])parameters.get(key);
                values = new String[oldValues.length + 1];
                for (int i = 0; i < oldValues.length; ++i) {
                    values[i] = oldValues[i];
                }
                values[oldValues.length] = value;
            } else {
                values = new String[]{value};
            }
            parameters.put(key, values);
        }
    }

    public static void processQueryString(MessageBytes data, LinkedHashMap parameters) {
        RequestUtil.processQueryString(data, parameters, null);
    }

    public static void processQueryString(MessageBytes data, LinkedHashMap parameters, String encoding) {
        if (data == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(data.toString(), "&", false);
        while (tok.hasMoreTokens()) {
            String[] values;
            String pair = tok.nextToken();
            String key = null;
            String value = null;
            int pos = pair.indexOf(61);
            if (pos != -1) {
                key = RequestUtil.unUrlDecode(pair.substring(0, pos));
                value = RequestUtil.unUrlDecode(pair.substring(pos + 1, pair.length()));
            } else {
                key = RequestUtil.unUrlDecode(pair);
                value = "";
            }
            if (encoding != null) {
                try {
                    key = new String(key.getBytes(DEFAULT_HTTP_CHARSET), encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                try {
                    value = new String(value.getBytes(DEFAULT_HTTP_CHARSET), encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
            }
            if (parameters.containsKey(key)) {
                String[] oldValues = (String[])parameters.get(key);
                values = new String[oldValues.length + 1];
                for (int i = 0; i < oldValues.length; ++i) {
                    values[i] = oldValues[i];
                }
                values[oldValues.length] = value;
            } else {
                values = new String[]{value};
            }
            parameters.put(key, values);
        }
    }

    public static boolean isJspPreCompile(ServletRequest req) throws ServletException {
        HttpServletRequest request = null;
        request = RequestUtil.getHttpServletRequest(req);
        String data = request.getQueryString();
        if (data == null) {
            return false;
        }
        boolean jspPrecompile = false;
        StringTokenizer tok = new StringTokenizer(data, "&", false);
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            int pos = pair.indexOf(61);
            if (pos != -1) {
                String key = pair.substring(0, pos);
                String value = pair.substring(pos + 1, pair.length());
                if (!key.equals(JSP_PRECOMPILE)) continue;
                if (value.equals("true")) {
                    jspPrecompile = true;
                    continue;
                }
                if (value.equals("false")) {
                    jspPrecompile = true;
                    continue;
                }
                throw new ServletException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3432, (Object)value));
            }
            if (!pair.equals(JSP_PRECOMPILE)) continue;
            jspPrecompile = true;
        }
        return jspPrecompile;
    }

    public static HttpServletRequest getHttpServletRequest(ServletRequest req) {
        HttpServletRequest request = req instanceof HttpServletRequestWrapper ? (HttpServletRequest)req : (req instanceof ServletRequestWrapper ? (HttpServletRequest)((ServletRequestWrapper)req).getRequest() : (HttpServletRequest)req);
        return request;
    }

    public static int readData(InputStream in, byte[] buf, int length) {
        int read = 0;
        try {
            while ((read += in.read(buf, read, length - read)) < length && read != -1) {
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return read;
    }

    public static final String URLDecode(String str) throws NumberFormatException, StringIndexOutOfBoundsException {
        if (str == null) {
            return null;
        }
        StringBuffer dec = new StringBuffer();
        int strPos = 0;
        int strLen = str.length();
        dec.ensureCapacity(str.length());
        while (strPos < strLen) {
            char laChar;
            int laPos;
            for (laPos = strPos; laPos < strLen && (laChar = str.charAt(laPos)) != '+' && laChar != '%'; ++laPos) {
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            dec.append((char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16));
            strPos += 3;
        }
        return dec.toString();
    }

    public static String unUrlDecode(String data, String encoding1, String encoding2) {
        String str;
        block24: {
            byte[] bs = new byte[data.length() * 3];
            int n = 0;
            block16: for (int i = 0; i < data.length(); ++i) {
                char c = data.charAt(i);
                switch (c) {
                    case '+': {
                        bs[n++] = 32;
                        continue block16;
                    }
                    case '%': {
                        int a;
                        try {
                            if (data.charAt(i + 1) == 'u') {
                                bs[n++] = 92;
                                bs[n++] = (byte)data.charAt(i + 1);
                                bs[n++] = (byte)data.charAt(i + 2);
                                bs[n++] = (byte)data.charAt(i + 3);
                                bs[n++] = (byte)data.charAt(i + 4);
                                bs[n++] = (byte)data.charAt(i + 5);
                                i += 5;
                                continue block16;
                            }
                            a = Integer.parseInt(data.substring(i + 1, i + 3), 16);
                            byte b = (byte)(a - 256);
                            i += 2;
                            bs[n++] = b;
                            continue block16;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3440) + " - " + data);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            String rest = data.substring(i);
                            int a2 = Integer.parseInt(rest, 16);
                            byte b = (byte)(a2 - 256);
                            bs[n++] = b;
                            if (rest.length() != 2) continue block16;
                            ++i;
                            continue block16;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3440) + " - " + data);
                        }
                    }
                    default: {
                        int a = 0xFF00 & c;
                        if (a > 0) {
                            bs[n++] = (byte)(a >>= 1);
                        }
                        bs[n++] = (byte)c;
                    }
                }
            }
            str = null;
            if (encoding1 != null) {
                try {
                    str = new String(bs, 0, n, encoding1);
                }
                catch (UnsupportedEncodingException e) {
                    if (encoding2 != null) {
                        try {
                            str = new String(bs, 0, n, encoding2);
                        }
                        catch (UnsupportedEncodingException e2) {
                            if (!encoding2.equals(DEFAULT_HTTP_CHARSET)) {
                                try {
                                    str = new String(bs, 0, n, DEFAULT_HTTP_CHARSET);
                                }
                                catch (UnsupportedEncodingException e3) {
                                    str = new String(bs, 0, n);
                                }
                                break block24;
                            }
                            str = new String(bs, 0, n);
                        }
                        break block24;
                    }
                    if (!encoding1.equals(DEFAULT_HTTP_CHARSET)) {
                        try {
                            str = new String(bs, 0, n, DEFAULT_HTTP_CHARSET);
                        }
                        catch (UnsupportedEncodingException e4) {
                            str = new String(bs, 0, n);
                        }
                        break block24;
                    }
                    str = new String(bs, 0, n);
                }
            } else {
                str = new String(bs, 0, n);
            }
        }
        return str;
    }

    public static String unUrlDecode(String data) {
        return RequestUtil.unUrlDecode(data, true);
    }

    public static String unUrlDecode(String data, boolean query) {
        StringBuffer buf = new StringBuffer();
        block8: for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            switch (c) {
                case '+': {
                    if (query) {
                        buf.append(' ');
                        continue block8;
                    }
                    buf.append(c);
                    continue block8;
                }
                case '%': {
                    try {
                        if (data.charAt(i + 1) == 'u') {
                            buf.append("\\" + data.substring(i + 1, i + 6));
                            i += 5;
                            continue block8;
                        }
                        buf.append((char)Integer.parseInt(data.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block8;
                    }
                    catch (NumberFormatException e) {
                        buf.append(c);
                        continue block8;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = data.substring(i);
                        buf.append(rest);
                        if (rest.length() != 2) continue block8;
                        ++i;
                        continue block8;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3440) + " - " + data);
                    }
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String getCharsetFromContentType(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        String afterCharset = afterSemi.substring(charsetLocation + 8);
        String encoding = afterCharset.trim();
        if (encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding;
    }

    public static String getContentTypeWithoutCharset(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return type;
        }
        String contentType = type.substring(0, semi).trim();
        return contentType;
    }

    public static Enumeration getLocales(HttpServletRequest req) {
        String acceptLanguage = req.getHeader("Accept-Language");
        if (acceptLanguage == null) {
            Vector<Locale> def = new Vector<Locale>();
            def.addElement(Locale.getDefault());
            return def.elements();
        }
        TreeMap languages = new TreeMap();
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        while (languageTokenizer.hasMoreTokens()) {
            String language = languageTokenizer.nextToken().trim();
            int qValueIndex = language.indexOf(59);
            int qIndex = language.indexOf(113);
            int equalIndex = language.indexOf(61);
            Double qValue = new Double(1.0);
            if (qValueIndex > -1 && qValueIndex < qIndex && qIndex < equalIndex) {
                String qValueStr = language.substring(qValueIndex + 1);
                language = language.substring(0, qValueIndex);
                qValueStr = qValueStr.trim().toLowerCase();
                qValueIndex = qValueStr.indexOf(61);
                qValue = new Double(0.0);
                if (qValueStr.startsWith("q") && qValueIndex > -1) {
                    qValueStr = qValueStr.substring(qValueIndex + 1);
                    try {
                        qValue = new Double(qValueStr.trim());
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            if (language.equals("*") || qValue < 5.0E-5) continue;
            Double key = new Double(-qValue.doubleValue());
            Vector<Object> v = languages.containsKey(key) ? languages.get(key) : new Vector();
            v.addElement(language);
            languages.put(key, v);
        }
        if (languages.size() == 0) {
            Vector<String> v = new Vector<String>();
            v.addElement("en");
            languages.put(new Double(1.0), v);
        }
        Vector<Locale> l = new Vector<Locale>();
        for (Double key : languages.keySet()) {
            Vector v = (Vector)languages.get(key);
            Enumeration le = v.elements();
            while (le.hasMoreElements()) {
                String language = (String)le.nextElement();
                String country = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                }
                l.addElement(new Locale(language, country));
            }
        }
        return l.elements();
    }

    public static String getCharsetFromLocale(String loc) {
        return (String)map.get(loc);
    }

    public static String getStatusString(int status) {
        switch (status) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return null;
    }

    public static long toDate(String dateString) {
        Date date = null;
        try {
            date = rfc1123Format.parse(dateString);
        }
        catch (ParseException e) {
            // empty catch block
        }
        try {
            date = rfc1123Format_2.parse(dateString);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (date == null) {
            try {
                date = rfc1036Format.parse(dateString);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                date = asctimeFormat.parse(dateString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (path != null) {
            String path1;
            int idx = path.indexOf("://");
            if (idx < 0) {
                idx = 0;
                path1 = "";
            } else {
                path1 = path.substring(0, idx += 3);
            }
            String path2 = path.substring(idx);
            while (path2.indexOf("//", idx) >= 0) {
                path2 = path2.replaceFirst("//", "/");
            }
            path = path1 + path2;
        }
        int end = path.length();
        int queryIdx = path.indexOf(63);
        int start = path.lastIndexOf(47, queryIdx > 0 ? queryIdx : end);
        block9: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (path.charAt(start + 1) == '.') break block9;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block9;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block10: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    if (start < 0 && buf.length() > 2 && buf.charAt(1) == '/' && buf.charAt(2) == '/') break;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    if (end == buf.length()) {
                        ++delStart;
                    }
                    --start;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block10;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    --start;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block10;
                }
                default: {
                    if (skip <= 0 || --skip != 0) break;
                    int n = delStart = start >= 0 ? start : 0;
                    if (delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                    ++delStart;
                }
            }
            if (skip <= 0 && delStart >= 0 && delStart >= 0) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            --start;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        return buf.toString();
    }

    public static String removeDotDot(String path) {
        WebProperties props = PropertyUtil.getContextProperties();
        if (props.URL_ALLOW_DOTDOT.value) {
            return path;
        }
        if (path != null) {
            String path1;
            int idx = path.indexOf("://");
            if (idx < 0) {
                idx = 0;
                path1 = "";
            } else {
                path1 = path.substring(0, idx += 3);
            }
            String path2 = path.substring(idx);
            while (path2.indexOf("//", idx) >= 0) {
                path2 = path2.replaceFirst("//", "/");
            }
            path = path1 + path2;
        }
        if (path != null && path.indexOf("..") >= 0) {
            int size;
            StringTokenizer tok = new StringTokenizer(path, "/\\");
            ArrayList<String> list = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String e = tok.nextToken();
                if (e.equals("..")) {
                    size = list.size();
                    if (size > 0) {
                        String obj = (String)list.get(size - 1);
                        while (obj.equals(".") && size > 0) {
                            list.remove(size - 1);
                            if (--size == 0) break;
                            obj = (String)list.get(size - 1);
                        }
                    }
                    if ((size = list.size()) <= 0) continue;
                    list.remove(size - 1);
                    continue;
                }
                list.add(e);
            }
            StringBuffer result = new StringBuffer();
            size = list.size();
            if (size == 0) {
                return "/";
            }
            for (int i = 0; i < size; ++i) {
                result.append("/" + (String)list.get(i));
            }
            return result.toString();
        }
        return path;
    }

    public static String removeContextPathFromRequestURI(String ctxPath, String uri) {
        if (ctxPath == null || ctxPath.equals("") || ctxPath.equals("/")) {
            return uri;
        }
        return uri.substring(ctxPath.length());
    }

    public static Hashtable parseQueryString(String s, String encoding) throws UnsupportedEncodingException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Hashtable ht = new Hashtable();
        if (s != null && s.length() > 0) {
            byte[] bytes = null;
            try {
                if (encoding == null) {
                    encoding = DEFAULT_HTTP_CHARSET;
                }
                bytes = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            RequestUtil.parseParameters(ht, bytes, encoding);
        }
        return ht;
    }

    public static void parseParameters(Map map, byte[] data, String encoding) throws UnsupportedEncodingException {
        if (data != null && data.length > 0) {
            int ix = 0;
            int ox = 0;
            String key = null;
            String value = null;
            block6: while (ix < data.length) {
                byte c = data[ix++];
                switch ((char)c) {
                    case '&': {
                        value = new String(data, 0, ox, encoding);
                        if (key != null) {
                            RequestUtil.putMapEntry(map, key, value);
                            key = null;
                        }
                        ox = 0;
                        continue block6;
                    }
                    case '=': {
                        if (key == null) {
                            key = new String(data, 0, ox, encoding);
                            ox = 0;
                            continue block6;
                        }
                        data[ox++] = c;
                        continue block6;
                    }
                    case '+': {
                        data[ox++] = 32;
                        continue block6;
                    }
                    case '%': {
                        if (data[ix] == 61 || data[ix] == 62) {
                            data[ox++] = c;
                            data[ox++] = data[ix++];
                            continue block6;
                        }
                        data[ox++] = (byte)((RequestUtil.convertHexDigit(data[ix++]) << 4) + RequestUtil.convertHexDigit(data[ix++]));
                        continue block6;
                    }
                }
                data[ox++] = c;
            }
            if (key != null) {
                value = new String(data, 0, ox, encoding);
                RequestUtil.putMapEntry(map, key, value);
            }
        }
    }

    private static void putMapEntry(Map map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = (String[])map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static boolean isSchemeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.';
    }

    static {
        map.put("ar", "ISO-8859-6");
        map.put("be", "ISO-8859-5");
        map.put("bg", "ISO-8859-5");
        map.put("ca", DEFAULT_HTTP_CHARSET);
        map.put("cs", "ISO-8859-2");
        map.put("da", DEFAULT_HTTP_CHARSET);
        map.put("de", DEFAULT_HTTP_CHARSET);
        map.put("el", "ISO-8859-7");
        map.put("en", DEFAULT_HTTP_CHARSET);
        map.put("es", DEFAULT_HTTP_CHARSET);
        map.put("et", DEFAULT_HTTP_CHARSET);
        map.put("fi", DEFAULT_HTTP_CHARSET);
        map.put("fr", DEFAULT_HTTP_CHARSET);
        map.put("he", "ISO-8859-8");
        map.put("hr", "ISO-8859-2");
        map.put("hu", "ISO-8859-2");
        map.put("is", DEFAULT_HTTP_CHARSET);
        map.put("it", DEFAULT_HTTP_CHARSET);
        map.put("iw", "ISO-8859-8");
        map.put("ja", "Shift_JIS");
        map.put("ko", "EUC-KR");
        map.put("lt", "ISO-8859-2");
        map.put("lv", "ISO-8859-2");
        map.put("mk", "ISO-8859-5");
        map.put("nl", DEFAULT_HTTP_CHARSET);
        map.put("no", DEFAULT_HTTP_CHARSET);
        map.put("pl", "ISO-8859-2");
        map.put("pt", DEFAULT_HTTP_CHARSET);
        map.put("ro", "ISO-8859-2");
        map.put("ru", "ISO-8859-5");
        map.put("sh", "ISO-8859-5");
        map.put("sk", "ISO-8859-2");
        map.put("sl", "ISO-8859-2");
        map.put("sq", "ISO-8859-2");
        map.put("sr", "ISO-8859-5");
        map.put("sv", DEFAULT_HTTP_CHARSET);
        map.put("tr", "ISO-8859-9");
        map.put("uk", "ISO-8859-5");
        map.put("zh", "GB2312");
        map.put("zh_TW", "Big5");
        loc = Locale.US;
        zone = TimeZone.getTimeZone("GMT");
        rfc1123Format = new SimpleDateFormat(rfc1123Pattern, loc);
        rfc1123Format_2 = new SimpleDateFormat(rfc1123Pattern_2, loc);
        rfc1036Format = new SimpleDateFormat(rfc1036Pattern, loc);
        asctimeFormat = new SimpleDateFormat(asctimePattern, loc);
    }
}

