/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.File;

public class ResourceWrapper {
    private File resFile;
    private byte[] resBytes;
    private long lastAccessTime;
    private long lastModifiedTime;

    public ResourceWrapper(File f, byte[] bs) {
        this.resFile = f;
        this.resBytes = bs;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public byte[] getBytes() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.resBytes;
    }

    public File getFile() {
        return this.resFile;
    }

    public long getResourceSize() {
        return this.resBytes.length;
    }

    public boolean isIdleResource(long maxIdleTime) {
        long nowTime = System.currentTimeMillis();
        long idleTime = nowTime - this.lastAccessTime;
        return idleTime > maxIdleTime;
    }

    public synchronized void clear() {
        this.resBytes = null;
        this.resFile = null;
    }
}

