/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.servlets.JspServlet;

public class ServletMapper {
    private Hashtable prefixMaps = null;
    private Hashtable extensionMaps = null;
    private Hashtable pathMaps = null;
    private String servletPath = null;
    private String pathInfo = null;
    private ExecutionWrapper servletWrapper = null;

    ServletMapper() {
    }

    ServletMapper(ExecutionWrapper wrapper, String servletPath, String pathInfo) {
        this.servletWrapper = wrapper;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
    }

    public void setMapTables(Hashtable pathMaps, Hashtable prefixMaps, Hashtable extensionMaps) {
        this.pathMaps = pathMaps;
        this.prefixMaps = prefixMaps;
        this.extensionMaps = extensionMaps;
    }

    public void setDefaultServlet(ExecutionWrapper wrapper, String servletPath, String pathInfo) {
        this.servletWrapper = wrapper;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public ExecutionWrapper getExecutionWrapper() {
        return this.servletWrapper;
    }

    public ExecutionWrapper lookupServlet(String path) {
        this.servletWrapper = this.getPathMatch(path);
        if (this.servletWrapper == null) {
            this.servletWrapper = this.getPrefixMatch(path);
        }
        if (this.servletWrapper == null) {
            this.servletWrapper = this.getExtensionMatch(path);
        }
        if (this.servletWrapper instanceof JspServletWrapper) {
            ((JspServletWrapper)this.servletWrapper).setUsedFlag();
        }
        return this.servletWrapper;
    }

    private ExecutionWrapper getPathMatch(String path) {
        ExecutionWrapper wrapper = null;
        wrapper = (ExecutionWrapper)this.pathMaps.get(path);
        if (wrapper != null) {
            this.servletPath = path;
        }
        return wrapper;
    }

    private ExecutionWrapper getPrefixMatch(String path) {
        ExecutionWrapper wrapper = null;
        String s = path;
        while (s.length() > 0) {
            String suffix = s.endsWith("/") ? "*" : "/*";
            wrapper = (ExecutionWrapper)this.prefixMaps.get(s + suffix);
            if (wrapper != null) {
                if (s.equals("/")) {
                    this.servletPath = "";
                    this.pathInfo = path;
                    if (wrapper instanceof JspServlet) {
                        this.servletPath = path;
                        this.pathInfo = null;
                    }
                } else if (s.endsWith("/")) {
                    String t = s.substring(0, s.length() - 1);
                    this.servletPath = t.trim().length() == 0 ? null : t;
                    t = s.substring(s.length() - 1);
                    this.pathInfo = t.trim().length() == 0 ? null : t;
                } else {
                    String t = s;
                    this.servletPath = t.trim().length() == 0 ? null : t;
                    t = path.substring(s.length(), path.length());
                    String string = this.pathInfo = t.trim().length() == 0 ? null : t;
                    if (wrapper instanceof JspServlet) {
                        this.servletPath = path;
                        this.pathInfo = null;
                    }
                }
                s = "";
                continue;
            }
            int i = s.lastIndexOf("/");
            if (i > 0) {
                s = s.substring(0, i);
                continue;
            }
            if (i == 0 && !s.equals("/")) {
                s = "/";
                continue;
            }
            s = "";
        }
        return wrapper;
    }

    private ExecutionWrapper getExtensionMatch(String path) {
        ExecutionWrapper wrapper = null;
        int i = path.lastIndexOf(".");
        if (i >= 0) {
            String ext = path.substring(i);
            wrapper = (ExecutionWrapper)this.extensionMaps.get("*" + ext);
        }
        if (wrapper != null) {
            this.servletPath = path;
        }
        return wrapper;
    }

    public void printMappingTables() {
        ExecutionWrapper wrapper;
        String path;
        Enumeration enum1 = null;
        if (this.pathMaps != null) {
            enum1 = this.pathMaps.keys();
            while (enum1.hasMoreElements()) {
                path = (String)enum1.nextElement();
                wrapper = (ExecutionWrapper)this.pathMaps.get(path);
                System.out.println("Path : path = " + path + ", servlet = " + wrapper.getName());
            }
        }
        if (this.prefixMaps != null) {
            enum1 = this.prefixMaps.keys();
            while (enum1.hasMoreElements()) {
                path = (String)enum1.nextElement();
                wrapper = (ExecutionWrapper)this.prefixMaps.get(path);
                System.out.println("Prefix : path = " + path + ", servlet = " + wrapper.getName());
            }
        }
        if (this.extensionMaps != null) {
            enum1 = this.extensionMaps.keys();
            while (enum1.hasMoreElements()) {
                path = (String)enum1.nextElement();
                wrapper = (ExecutionWrapper)this.extensionMaps.get(path);
                System.out.println("Extension : path = " + path + ", servlet = " + wrapper.getName());
            }
        }
    }
}

