/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jeus.management.j2ee.WebModule;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.security.container.web.ServletSecurity;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.filter.FilterChainImpl;
import jeus.servlet.filter.FilterFactory;
import jeus.servlet.loader.ServletReloader;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;

public class ServletWrapper
implements ExecutionWrapper {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.engine");
    protected String servletName;
    protected Context context;
    protected ServletManager servletManager;
    protected ServletReloader reloader;
    protected long numTotalRequests;
    public static Method SERVLET_SERVICE_METHOD;
    private String userPrincial;
    protected TimeStatisticImpl serviceTimeStat;
    protected jeus.management.j2ee.Servlet servletMBean;

    public ServletWrapper(String name, ServletManager servletManager, ServletReloader reloader, String _userPrincial) {
        this.servletName = name;
        this.reloader = reloader;
        this.servletManager = servletManager;
        this.context = servletManager.getContext();
        this.userPrincial = _userPrincial;
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }

    void loadOnStartup() throws ServletException {
        this.reloader.getServlet();
    }

    public ServletReloader getReloader() {
        return this.reloader;
    }

    public String getServletName() {
        return this.servletName;
    }

    public ServletInfo getServletInfo() {
        return this.reloader.getServletInfo(this.servletName, this.numTotalRequests);
    }

    public boolean clearRequestCount() {
        this.numTotalRequests = 0L;
        return true;
    }

    public synchronized boolean execSuspend() {
        return this.reloader.suspend();
    }

    public synchronized boolean execResume() {
        return this.reloader.resume();
    }

    public void destroyServlet() {
        this.reloader.destroy();
    }

    public String getName() {
        return this.servletName;
    }

    public String getClassName() {
        return this.reloader.getClassName();
    }

    public boolean isResourceServlet() {
        return false;
    }

    public jeus.management.j2ee.Servlet getServletMBean() {
        return this.servletMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        WebAppContextSwitch.preContextSwitch(this.reloader.getParent());
        try {
            request.setAttribute("jeus.web.DISPATCHER_TYPE", FilterFactory.REQUEST_INTEGER);
            request.setAttribute("jeus.web.DISPATCHER_REQUEST_PATH", request.getLookupPath());
            FilterFactory factory = FilterFactory.getInstance();
            FilterChainImpl filterChain = factory.createFilterChain((ServletRequest)request, this);
            try {
                if (filterChain != null) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    this.executeServlet((ServletRequest)request, (ServletResponse)response);
                }
            }
            finally {
                if (filterChain != null) {
                    filterChain.release();
                }
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeServlet(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Servlet copy = null;
        try {
            copy = this.reloader.getServlet();
            long serviceStartTime = 0L;
            if (this.serviceTimeStat != null) {
                serviceStartTime = System.currentTimeMillis();
            }
            try {
                Boolean authorized;
                if (this.userPrincial != null) {
                    String domainName = null;
                    if (this.context != null) {
                        domainName = this.context.getDomainName();
                    }
                    ServletSecurity.setServletRunAsIdentity(domainName, this.userPrincial);
                }
                if ((authorized = (Boolean)request.getAttribute("jeus.servlet.request.authorized")) != null && authorized.booleanValue()) {
                    ServletSecurity.runServletBusinessCode(copy, SERVLET_SERVICE_METHOD, new Object[]{request, response});
                } else {
                    copy.service(request, response);
                }
            }
            finally {
                if (this.userPrincial != null) {
                    ServletSecurity.clearServletRunAsIdentity();
                }
            }
            if (this.serviceTimeStat != null) {
                this.serviceTimeStat.addData(System.currentTimeMillis() - serviceStartTime);
            }
        }
        catch (ServletException se) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3456_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3456_LEVEL, JeusMessage_WebContainer2._3456, (Object)this.servletName, (Throwable)se);
            }
            throw se;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3456_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3456_LEVEL, JeusMessage_WebContainer2._3456, (Object)this.servletName, (Throwable)ioe);
            }
            throw ioe;
        }
        catch (Throwable t) {
            String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3456, (Object)this.servletName);
            logger.log(JeusMessage_WebContainer2._3456_LEVEL, msg, t);
            throw new ServletException(msg, t);
        }
        finally {
            if (copy != null) {
                this.reloader.putServlet(copy);
            }
        }
        ++this.numTotalRequests;
    }

    public void registerMBean(WebModule webModule) {
        if (webModule == null) {
            return;
        }
        try {
            this.servletMBean = (jeus.management.j2ee.Servlet)jeus.management.j2ee.Servlet.createMBean(this.servletName, webModule.getObjectName(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.servletMBean != null) {
            this.serviceTimeStat = this.servletMBean.getALL_THREAD_COUNT();
        }
    }

    public void destroyMBean() {
        if (this.servletMBean != null) {
            this.servletMBean.destroyMBean();
        }
    }

    static {
        Class<Servlet> servletClass = Servlet.class;
        Class[] _params2 = new Class[]{ServletRequest.class, ServletResponse.class};
        try {
            SERVLET_SERVICE_METHOD = servletClass.getMethod("service", _params2);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

