/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.util.Vector;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.RequestProcessor;
import jeus.servlet.engine.TCPRequestProcessor;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.tcp.TCPDispatcherConfig;
import jeus.servlet.util.StandardQueue;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRootClassLoader;
import jeus.util.message.JeusMessage_WebContainer2;

public class TCPThreadPoolManager
extends ThreadPoolManager {
    private String dispatcherConfigClass;
    private TCPDispatcherConfig dispatcherConfig = null;

    public TCPThreadPoolManager(ContextGroup ctxgrp, ConnectionDescriptor desc) {
        super(ctxgrp, desc);
        this.connQueue = new StandardQueue(this, this.tpoolDesc.getMaxQueue());
        this.connQueue.setMaxWaitQueueSize(this.tpoolDesc.getMaxWaitQueue());
        this.threadPoolId = desc.getListenerId();
        this.dispatcherConfigClass = desc.getDispatcherConfigClass();
    }

    public synchronized void createPool() throws StartingException {
        if (this.isDestroyed) {
            return;
        }
        if (this.dispatcherConfigClass == null) {
            throw new StartingException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3388));
        }
        try {
            Class<?> klass = JeusRootClassLoader.loader.loadClass(this.dispatcherConfigClass);
            this.dispatcherConfig = (TCPDispatcherConfig)klass.newInstance();
            this.dispatcherConfig.init();
        }
        catch (Exception e) {
            throw new StartingException(JeusMessage_WebContainer2._3059, this.dispatcherConfigClass, (Throwable)e);
        }
        int minThreadNum = this.tpoolDesc.getMinThreadNum();
        try {
            for (int i = 0; i < minThreadNum; ++i) {
                RequestProcessor worker = this.getInstance();
                this.threadPool.addElement(worker);
                worker.start();
            }
            if (logger.isLoggable(JeusMessage_WebContainer2._3250_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3250_LEVEL, JeusMessage_WebContainer2._3250, (Object)this.threadPoolId);
            }
            if (logger.isLoggable(JeusMessage_WebContainer2._3251_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3251_LEVEL, JeusMessage_WebContainer2._3251, (Object[])new String[]{String.valueOf(minThreadNum), String.valueOf(this.tpoolDesc.getMaxThreadNum()), String.valueOf(this.tpoolDesc.getChangingRate()), String.valueOf(this.tpoolDesc.getMaxIdleTime())});
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3058_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3058_LEVEL, JeusMessage_WebContainer2._3058, (Throwable)e);
            }
            throw new StartingException(JeusMessage_WebContainer2._3058, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int createThreads() {
        if (this.isDestroyed) {
            return 0;
        }
        int diff = this.tpoolDesc.getMaxThreadNum() - this.threadPool.size();
        int changingRate = this.tpoolDesc.getChangingRate();
        if (diff > 0) {
            if (diff >= changingRate) {
                diff = changingRate;
            }
            Vector vector = this.threadPool;
            synchronized (vector) {
                for (int i = 0; i < diff; ++i) {
                    RequestProcessor worker = this.getInstance();
                    this.threadPool.addElement(worker);
                    worker.start();
                }
            }
        }
        return diff;
    }

    public synchronized void createThreads(int numCount) {
        if (this.isDestroyed) {
            return;
        }
        int diff = this.tpoolDesc.getMaxThreadNum() - this.threadPool.size();
        if (numCount < diff) {
            diff = numCount;
        }
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                RequestProcessor worker = this.getInstance();
                this.threadPool.addElement(worker);
                worker.start();
            }
        }
    }

    public synchronized void deleteAllThreads() {
        int size = this.threadPool.size();
        for (int i = size - 1; i >= 0; --i) {
            RequestProcessor worker = (RequestProcessor)this.threadPool.elementAt(i);
            this.threadPool.removeElementAt(i);
            worker.blocked = true;
            this.blockedThreadPool.insertElementAt(worker, 0);
            worker.interrupt();
        }
        int numBlocked = this.blockedThreadPool.size();
        if (numBlocked > 0) {
            for (int i = numBlocked - 1; i >= 0; --i) {
                RequestProcessor worker = (RequestProcessor)this.blockedThreadPool.elementAt(i);
                String state = worker.checkBlockedThreadState();
                if (state != null) {
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3314_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3314_LEVEL, JeusMessage_WebContainer2._3314, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), worker.getRequestURI()});
                    continue;
                }
                this.blockedThreadPool.removeElement(worker);
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3330_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3330_LEVEL, JeusMessage_WebContainer2._3330, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), String.valueOf(size)});
        }
        this.createThreads(this.tpoolDesc.getMinThreadNum());
        if (logger.isLoggable(JeusMessage_WebContainer2._3331_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3331_LEVEL, JeusMessage_WebContainer2._3331, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), String.valueOf(this.threadPool.size())});
        }
    }

    public synchronized void checkThreadPool() {
        int size;
        int numCreated;
        int numIdleDeleted;
        int numActiveDeleted;
        int minThreadNum;
        block20: {
            boolean moreIdleCheck;
            long maxIdleTime;
            int deleteCount;
            block19: {
                String engineName;
                if (this.isDestroyed) {
                    return;
                }
                if (this.dispatcherConfigClass == null) {
                    logger.log(JeusMessage_WebContainer2._3388_LEVEL, JeusMessage_WebContainer2._3388);
                    return;
                }
                minThreadNum = this.tpoolDesc.getMinThreadNum();
                int maxThreadNum = this.tpoolDesc.getMaxThreadNum();
                deleteCount = this.tpoolDesc.getChangingRate();
                maxIdleTime = this.tpoolDesc.getMaxIdleTime();
                long maxThreadActiveTime = this.tsnDesc == null ? 0L : this.tsnDesc.getMaxThreadActiveTime();
                moreIdleCheck = true;
                numActiveDeleted = 0;
                numIdleDeleted = 0;
                numCreated = 0;
                size = this.threadPool.size();
                if (maxIdleTime <= 0L) {
                    moreIdleCheck = false;
                }
                if (this.tsnDesc == null) break block19;
                for (int i = size - 1; i >= 0; --i) {
                    long idleTime;
                    TCPRequestProcessor worker = (TCPRequestProcessor)this.threadPool.elementAt(i);
                    if (worker.active && maxThreadActiveTime > 0L) {
                        long activeTime = worker.checkIdleTime(maxThreadActiveTime);
                        if (activeTime <= 0L) continue;
                        this.threadPool.removeElementAt(i);
                        worker.blocked = true;
                        this.blockedThreadPool.insertElementAt(worker, 0);
                        ++numActiveDeleted;
                        if (logger.isLoggable(JeusMessage_WebContainer2._3332_LEVEL)) {
                            logger.log(JeusMessage_WebContainer2._3332_LEVEL, JeusMessage_WebContainer2._3332, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), String.valueOf(activeTime), worker.getRequestURI()});
                        }
                        worker.interrupt();
                        continue;
                    }
                    if (!moreIdleCheck || this.threadPool.size() <= minThreadNum || worker.isSocketReused() || (idleTime = worker.checkIdleTime(maxIdleTime)) <= 0L) continue;
                    this.threadPool.removeElementAt(i);
                    worker.interrupt();
                    ++numIdleDeleted;
                    if (--deleteCount == 0) {
                        moreIdleCheck = false;
                    }
                    if (!logger.isLoggable(JeusMessage_WebContainer2._3333_LEVEL)) continue;
                    logger.log(JeusMessage_WebContainer2._3333_LEVEL, JeusMessage_WebContainer2._3333, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), String.valueOf(idleTime)});
                }
                String msg = "";
                int blockedThreads = 0;
                int numBlocked = this.blockedThreadPool.size();
                if (numBlocked > 0) {
                    for (int i = numBlocked - 1; i >= 0; --i) {
                        RequestProcessor worker = (RequestProcessor)this.blockedThreadPool.elementAt(i);
                        String state = worker.checkBlockedThreadState();
                        if (state != null) {
                            msg = msg + state + "\n";
                            ++blockedThreads;
                            if (!logger.isLoggable(JeusMessage_WebContainer2._3329_LEVEL)) continue;
                            logger.log(JeusMessage_WebContainer2._3329_LEVEL, JeusMessage_WebContainer2._3329, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), worker.getRequestURI()});
                            continue;
                        }
                        worker.blocked = false;
                        this.blockedThreadPool.removeElement(worker);
                    }
                }
                if (this.tsnDesc != null && this.tsnDesc.needNotify(blockedThreads, maxThreadNum)) {
                    WebContainerManager manager = this.contextGroup.getContainerManager();
                    engineName = manager.ENGINE_NAME;
                    if (logger.isLoggable(JeusMessage_WebContainer2._3319_LEVEL)) {
                        logger.sendEmailNotification(JeusMessage_WebContainer2._3319_LEVEL, this.tsnDesc.getNotifySubject(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3319, (Object[])new String[]{engineName, this.threadPoolId, msg}));
                    }
                }
                if (this.tsnDesc == null || !this.tsnDesc.needRestart(blockedThreads, maxThreadNum)) break block20;
                WebContainerManager manager = this.contextGroup.getContainerManager();
                engineName = manager.ENGINE_NAME;
                String restartMsg = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3320, (Object[])new String[]{engineName, this.threadPoolId, msg});
                logger.log(JeusMessage_WebContainer2._3320_LEVEL, restartMsg);
                if (logger.isLoggable(JeusMessage_WebContainer2._3320_LEVEL)) {
                    logger.sendEmailNotification(JeusMessage_WebContainer2._3320_LEVEL, this.tsnDesc.getRestartSubject(), restartMsg);
                }
                manager.restartEngine(this.contextGroup.getGroupName());
                break block20;
            }
            if (!moreIdleCheck) {
                return;
            }
            for (int i = size - 1; i >= 0; --i) {
                long idleTime;
                RequestProcessor worker = (RequestProcessor)this.threadPool.elementAt(i);
                if (!moreIdleCheck || this.threadPool.size() <= minThreadNum) break;
                if (this.socketReused(worker) || (idleTime = worker.checkIdleTime(maxIdleTime)) <= 0L) continue;
                this.threadPool.removeElementAt(i);
                worker.interrupt();
                ++numIdleDeleted;
                if (logger.isLoggable(JeusMessage_WebContainer2._3333_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3333_LEVEL, JeusMessage_WebContainer2._3333, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), worker.getThreadId(), String.valueOf(idleTime)});
                }
                if (--deleteCount != 0) continue;
                moreIdleCheck = false;
                break;
            }
        }
        size = this.threadPool.size();
        if (size < minThreadNum) {
            int diff = minThreadNum - size;
            for (int i = 0; i < diff; ++i) {
                RequestProcessor worker = this.getInstance();
                this.threadPool.addElement(worker);
                worker.start();
                ++numCreated;
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer2._3321_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3321_LEVEL, JeusMessage_WebContainer2._3321, (Object[])new String[]{this.threadPoolId, String.valueOf(this.threadPool.size()), String.valueOf(this.blockedThreadPool.size()), String.valueOf(numActiveDeleted), String.valueOf(numIdleDeleted), String.valueOf(numCreated)});
        }
    }

    protected boolean socketReused(RequestProcessor proc) {
        return ((TCPRequestProcessor)proc).isSocketReused();
    }

    public String getDispatcherConfigClass() {
        return this.dispatcherConfigClass;
    }

    public void setDispatcherConfigClass(String dispatcherConfigClass) {
        this.dispatcherConfigClass = dispatcherConfigClass;
    }

    public TCPDispatcherConfig getDispatcherConfig() {
        return this.dispatcherConfig;
    }

    protected RequestProcessor getInstance() {
        return new TCPRequestProcessor(this, this.contextGroup, this.dispatcherConfig);
    }
}

