/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine;

import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.engine.io.ChunkedInputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_WebContainer2;
import jeus.util.trace.GID;

public class WebServletRequest
extends HttpServletRequestImpl {
    private boolean SSL = false;
    private static final int MAX_REQUEST_LINES = 64;
    String name = null;

    public WebServletRequest(ContextGroup ctxGroup, ThreadPoolManager manager) {
        super(ctxGroup, manager);
    }

    final void setSSL(boolean flag) {
        this.SSL = flag;
    }

    public int readRequest(int readTimeout, int postdataReadTimeout) throws IOException, InterruptedException {
        int clen;
        String line;
        if (readTimeout >= 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(readTimeout);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (postdataReadTimeout > 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.parseRequestLine(line = this.readRequestLine())) {
            return -1;
        }
        if (this.protocol != null) {
            this.parseHeader();
        }
        GID gid = new GID();
        GID.setCurrentGID(gid);
        GID.increaseSeqNumber();
        this.processCommonRequest(this.requestURI, null, null);
        if (logger.isLoggable(JeusMessage_WebContainer2._3263_LEVEL)) {
            StringBuffer buf = new StringBuffer();
            buf.append("\n\tcontext-name : " + (this.context == null ? "null" : this.context.getContextName()) + StringUtil.lineSeparator);
            buf.append("\trequest-uri  : " + this.originalRequestURI + StringUtil.lineSeparator);
            buf.append("\tquery-string : " + this.queryString + StringUtil.lineSeparator);
            buf.append("\tserver-name  : " + this.getServerName() + StringUtil.lineSeparator);
            buf.append("\tprotocol     : " + this.protocol + StringUtil.lineSeparator);
            buf.append("\tcontent-len  : " + this.contentLength + StringUtil.lineSeparator);
            Enumeration enum1 = this.headers3.keys();
            while (enum1.hasMoreElements()) {
                String name1 = (String)enum1.nextElement();
                Vector values = (Vector)this.headers3.get(name1);
                Enumeration enum2 = values.elements();
                while (enum2.hasMoreElements()) {
                    String value1 = (String)enum2.nextElement();
                    buf.append("\theaders      : " + name1 + ":" + value1 + StringUtil.lineSeparator);
                }
            }
            logger.log(JeusMessage_WebContainer2._3263_LEVEL, JeusMessage_WebContainer2._3263, (Object)buf.toString());
        }
        if ((clen = this.getContentLength()) > 0) {
            this.in.setLimit(clen);
        } else {
            this.in.setLimit(0);
        }
        if (postdataReadTimeout >= 0) {
            try {
                if (this.socket != null) {
                    this.socket.setSoTimeout(postdataReadTimeout);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.getHeader("Transfer-Encoding") != null && this.getHeader("Transfer-Encoding").equalsIgnoreCase("chunked")) {
            this.in = new ChunkedInputStream(this.in.getInputStream());
        }
        return 1;
    }

    private String readRequestLine() throws IOException {
        String lines = "";
        byte[] buf = new byte[1024];
        boolean end = false;
        for (int lineCount = 0; !end && lineCount < 64; ++lineCount) {
            int count = this.in.readLine(buf, 0, buf.length);
            String line = null;
            if (count >= 0) {
                try {
                    line = new String(buf, 0, count, "ISO-8859-1");
                }
                catch (Exception e) {
                    line = new String(buf, 0, count);
                }
                if (line.charAt(count - 1) == '\n') {
                    end = true;
                }
                lines = lines + line;
                continue;
            }
            throw new EOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3325));
        }
        return lines;
    }

    private boolean parseRequestLine(String line) {
        String s;
        String buffer = line.trim();
        int firstDelim = buffer.indexOf(32);
        int lastDelim = buffer.lastIndexOf(32);
        if (firstDelim == -1 && lastDelim == -1 && buffer.trim().length() > 0) {
            firstDelim = buffer.trim().length();
            lastDelim = buffer.trim().length();
        }
        if (firstDelim != lastDelim && (s = buffer.substring(firstDelim, lastDelim)).trim().length() == 0) {
            firstDelim = lastDelim;
        }
        String requestString = null;
        if (firstDelim != lastDelim) {
            this.method.setString(buffer.substring(0, firstDelim).trim());
            this.protocol.setString(buffer.substring(lastDelim + 1).trim());
            requestString = buffer.substring(firstDelim + 1, lastDelim).trim();
            if (requestString.toLowerCase().startsWith("http://")) {
                requestString = requestString.substring(7);
                requestString = requestString.substring(requestString.indexOf("/"));
            }
        } else if (firstDelim != -1 && lastDelim != -1) {
            this.method.setString(buffer.substring(0, firstDelim).trim());
            this.protocol.setString(null);
            if (lastDelim < buffer.length()) {
                requestString = buffer.substring(lastDelim + 1).trim();
            }
        }
        if (!this.SSL && this.getProtocol() != null && !this.getProtocol().toLowerCase().startsWith("http/")) {
            requestString = requestString + " " + this.getProtocol();
            this.protocol.setString(null);
        }
        if (this.SSL && this.protocol != null) {
            this.protocol.setString("HTTPS");
        }
        int requestErrorCode = 0;
        try {
            int len = line.length();
            if (len < 2) {
                requestErrorCode = 400;
            } else if (line.charAt(len - 1) != '\n') {
                requestErrorCode = 414;
                this.protocol.setString("HTTP/1.0");
            }
        }
        catch (StringIndexOutOfBoundsException siobe) {
            // empty catch block
        }
        if (requestErrorCode == 0 && (requestString == null || requestString.indexOf(32) > -1 || requestString.indexOf(47) != 0)) {
            requestErrorCode = 400;
        }
        if (requestErrorCode != 0) {
            try {
                this.response.sendError(requestErrorCode);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return false;
        }
        int indexQ = requestString.indexOf("?");
        int rLen = requestString.length();
        if (indexQ > -1 && indexQ < rLen) {
            this.requestURI.setString(requestString.substring(0, indexQ));
            this.queryString.setString(requestString.substring(indexQ + 1, requestString.length()));
        } else {
            this.requestURI.setString(requestString);
        }
        return true;
    }

    private void parseHeader() throws IOException {
        byte[] buf = new byte[1024];
        int off = 0;
        while (true) {
            int start = off;
            while (true) {
                int len;
                if ((len = buf.length - off) > 0 && (len = this.in.readLine(buf, off, len)) == -1) {
                    throw new EOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3325));
                }
                if (len == 0 || buf[(off += len) - 1] == 10) break;
                byte[] tmp = new byte[buf.length * 2];
                System.arraycopy(buf, 0, tmp, 0, buf.length);
                buf = tmp;
            }
            if (--off > start && buf[off - 1] == 13) {
                --off;
            }
            if (off == start) break;
            this.parseHeaderLine(buf, start, off - start);
        }
    }

    private void parseHeaderLine(byte[] b, int off, int len) {
        byte c;
        int start = off;
        if (b[start] == 9 || b[start] == 32) {
            int n;
            byte c2;
            String oldValue = this.getHeader(this.name);
            String newValue = null;
            do {
                n = ++off;
                ++off;
            } while ((c2 = b[n]) == 9 || c2 == 32);
            try {
                newValue = new String(b, off - 1, len - (off - start - 1), "ISO-8859-1");
            }
            catch (Exception e) {
                newValue = new String(b, off - 1, len - (off - start - 1));
            }
            this.addHeader(this.name, oldValue + newValue);
            return;
        }
        while ((c = b[off++]) != 58 && c != 32) {
            if (c != 10) continue;
            if (logger.isLoggable(JeusMessage_WebContainer2._3326_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3326_LEVEL, JeusMessage_WebContainer2._3326);
            }
            return;
        }
        try {
            this.name = new String(b, start, off - start - 1, "ISO-8859-1");
        }
        catch (Exception e) {
            this.name = new String(b, start, off - start - 1);
        }
        while (c == 32) {
            c = b[off++];
        }
        if (c != 58) {
            if (logger.isLoggable(JeusMessage_WebContainer2._3326_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3326_LEVEL, JeusMessage_WebContainer2._3326);
            }
            return;
        }
        while ((c = b[off++]) == 32) {
        }
        String value = null;
        try {
            value = new String(b, off - 1, len - (off - start - 1), "ISO-8859-1");
        }
        catch (Exception e) {
            value = new String(b, off - 1, len - (off - start - 1));
        }
        this.addHeader(this.name, value);
    }
}

