/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import jeus.servlet.engine.Ajp13ServletRequest;
import jeus.servlet.engine.io.Ajp13Constants;
import jeus.servlet.engine.io.Ajp13OutputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class Ajp13InputStream
extends InputStream
implements Ajp13Constants {
    private static final byte[] GET_BODY_CHUNK = new byte[]{65, 66, 0, 3, 6, 31, -6};
    private InputStream in;
    private Ajp13OutputStream out;
    private byte[] ajp13Header;
    private byte[] rcvbuf;
    private int pos;
    private int count;
    private int payloadLength;
    private boolean httpHeaderRead;

    public Ajp13InputStream(InputStream in, Ajp13OutputStream out) {
        this.in = in;
        this.out = out;
        this.ajp13Header = new byte[4];
        this.rcvbuf = new byte[8192];
        this.clear();
    }

    public void reset(InputStream in, Ajp13OutputStream out) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = in;
        this.out = out;
        this.clear();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        this.clear();
    }

    public void clear() {
        this.pos = 0;
        this.count = 0;
        this.payloadLength = 0;
    }

    public void parseRequestHeader(Ajp13ServletRequest request) throws IOException {
        this.clear();
        this.httpHeaderRead = false;
        do {
            this.readAjp13PacketHeader();
        } while (this.payloadLength == 0);
        this.ensureCapacity(this.payloadLength);
        byte opcode = this.getByte();
        if (opcode != 2) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3730, (Object)String.valueOf(opcode)));
        }
        this.httpHeaderRead = true;
        request.parse();
        this.clear();
    }

    private void readAjp13PacketHeader() throws IOException {
        int n;
        for (int cnt = 0; cnt < 4; cnt += n) {
            n = this.in.read(this.ajp13Header, cnt, this.ajp13Header.length - cnt);
            if (n >= 0) continue;
            throw new EOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3731));
        }
        int magic = this.getHeaderShort(0);
        if (magic != 4660) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3732, (Object)Integer.toHexString(magic)));
        }
        this.payloadLength = this.getHeaderShort(2);
        if (this.payloadLength < 0) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3733, (Object)String.valueOf(this.payloadLength)));
        }
    }

    private void ensureCapacity(int len) throws IOException {
        do {
            int n;
            if ((n = this.fill(len)) >= 0) continue;
            throw new EOFException();
        } while (this.count - this.pos < len);
    }

    private int fill(int len) throws IOException {
        int n = 0;
        boolean newbody = false;
        if (this.httpHeaderRead && this.pos >= this.count && this.count >= this.payloadLength) {
            this.requestNextBody();
            newbody = true;
        }
        if (this.payloadLength <= 0) {
            throw new EOFException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3733, (Object)String.valueOf(this.payloadLength)));
        }
        while (this.count - this.pos < len) {
            n = this.in.read(this.rcvbuf, this.count, this.payloadLength - this.count);
            if (n < 0) {
                if (this.count > this.pos) break;
                return -1;
            }
            this.count += n;
            if (this.count < this.payloadLength) continue;
        }
        if (newbody) {
            this.getShort();
        }
        return this.count - this.pos;
    }

    private void requestNextBody() throws IOException {
        this.clear();
        this.out.writeCommand(GET_BODY_CHUNK);
        this.readAjp13PacketHeader();
    }

    public int read() throws IOException {
        this.ensureCapacity(1);
        return this.rcvbuf[this.pos++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.fill(len);
        if (this.pos + len <= this.count) {
            System.arraycopy(this.rcvbuf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }
        int toCopy = len;
        while (toCopy > 0) {
            int bytesRemaining = this.count - this.pos;
            if (bytesRemaining < 0) {
                bytesRemaining = 0;
            }
            int c = bytesRemaining < toCopy ? bytesRemaining : toCopy;
            System.arraycopy(this.rcvbuf, this.pos, b, off, c);
            off += c;
            this.pos += c;
            if ((toCopy -= c) <= 0) continue;
            this.fill(toCopy);
        }
        return len - toCopy;
    }

    public int getHeaderShort(int pos) {
        int b1 = this.ajp13Header[pos] & 0xFF;
        int b2 = this.ajp13Header[pos + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public int getShort() {
        int result = this.peekShort();
        this.pos += 2;
        return result;
    }

    public int peekShort() {
        int b1 = this.rcvbuf[this.pos] & 0xFF;
        int b2 = this.rcvbuf[this.pos + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public byte getByte() {
        byte res = this.rcvbuf[this.pos];
        ++this.pos;
        return res;
    }

    public byte peekByte() {
        return this.rcvbuf[this.pos];
    }

    public boolean getBool() {
        return this.getByte() == 1;
    }

    public String getString() {
        int length = this.getShort();
        if (length == 65535 || length == -1) {
            return null;
        }
        String s = new String(this.rcvbuf, this.pos, length);
        this.pos += length;
        ++this.pos;
        return s;
    }

    public String getString(String enc) {
        int length = this.getShort();
        if (length == 65535 || length == -1) {
            return null;
        }
        String s = null;
        try {
            s = new String(this.rcvbuf, this.pos, length, enc);
        }
        catch (UnsupportedEncodingException uee) {
            s = new String(this.rcvbuf, this.pos, length);
        }
        this.pos += length;
        ++this.pos;
        return s;
    }
}

