/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.servlet.engine.io.ResponseHeaderInfo;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class ChunkedOutputAdaptor
extends ProtocolOutputAdaptor {
    private static final int ALPHA = 32;
    private static final byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private static final byte[] CRLF = new byte[]{13, 10};
    protected byte[] chunkSizeField = new byte[]{32, 32, 32, 32, 13, 10};
    private int realBufferSize;
    protected int chunksizeStartOffset;

    protected ChunkedOutputAdaptor(OutputStream out, WebServerOutputStream webServer, byte[] header, byte[] body) {
        super(out, webServer, header, body);
        this.bufferCount = this.webServerHeaderSize + this.resizeChunkField(this.bufferSize);
        this.realBufferSize = this.bufferSize - 32;
    }

    private int resizeChunkField(int bufferSize) {
        String hex = Integer.toHexString(bufferSize);
        int n = hex.length();
        if (this.chunkSizeField.length != n + 2) {
            this.chunkSizeField = new byte[n + 2];
            for (int i = 0; i < n; ++i) {
                this.chunkSizeField[i] = 32;
            }
            this.chunkSizeField[n] = 13;
            this.chunkSizeField[n + 1] = 10;
        }
        this.chunksizeStartOffset = 0;
        return this.chunkSizeField.length;
    }

    public void setBodyBuffer(byte[] body) {
        super.setBodyBuffer(body);
        this.bufferCount = this.webServerHeaderSize + this.resizeChunkField(this.bufferSize);
        this.realBufferSize = this.bufferSize - 32;
    }

    boolean isEmpty() {
        return !this.committed && this.bufferCount <= this.webServerHeaderSize + this.chunkSizeField.length && this.headerCount <= this.webServerHeaderSize;
    }

    protected int prepareBuffer(int min, int max) throws IOException {
        int freeSpace = this.realBufferSize - this.bufferCount;
        if (freeSpace < min) {
            this.flush(true, false);
        }
        if ((freeSpace = this.realBufferSize - this.bufferCount) < min) {
            throw new IOException("buffer full. min = " + min);
        }
        return freeSpace;
    }

    protected void writeHeader() {
        if (this.headerCount > this.webServerHeaderSize) {
            return;
        }
        ResponseHeaderInfo header = this.webServer.getResponseHeader();
        this.headerCount = this.webServerHeaderSize;
        header.responseHeader.append("Transfer-Encoding: chunked\r\n");
        header.responseHeader.append("\r\n");
        byte[] content = null;
        byte[] statusLine = new byte[]{};
        WebProperties props = PropertyUtil.getContextProperties();
        String encoding = props.RESPONSE_HEADER_ENCODING.value;
        if (header.statusLine != null) {
            if (encoding == null) {
                statusLine = header.statusLine.toString().getBytes();
            } else {
                try {
                    statusLine = header.statusLine.toString().getBytes(encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    statusLine = header.statusLine.toString().getBytes();
                }
            }
        }
        if (encoding == null) {
            content = header.responseHeader.toString().getBytes();
        } else {
            try {
                content = header.responseHeader.toString().getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                content = header.responseHeader.toString().getBytes();
            }
        }
        if (statusLine.length + content.length > this.httpHeader.length - this.headerCount) {
            this.httpHeader = this.webServer.resizeHttpHeader(statusLine.length + content.length + this.webServerHeaderSize);
        }
        if (statusLine.length > 0) {
            System.arraycopy(statusLine, 0, this.httpHeader, this.headerCount, statusLine.length);
            this.headerCount += statusLine.length;
        }
        System.arraycopy(content, 0, this.httpHeader, this.headerCount, content.length);
        this.headerCount += content.length;
        if (logger.isLoggable(JeusMessage_WebContainer2._3272_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3272_LEVEL, JeusMessage_WebContainer2._3272, (Object[])new String[]{String.valueOf(this.headerCount), new String(this.httpHeader, this.webServerHeaderSize, this.headerCount - this.webServerHeaderSize)});
        }
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        boolean flushed = false;
        try {
            int contLen = this.bufferCount - this.webServerHeaderSize - this.chunkSizeField.length;
            if (!forced && !last && contLen <= 0) {
                return false;
            }
            int webServerContLen = 0;
            if (!this.committed) {
                this.writeHeader();
                webServerContLen = this.headerCount + this.setChunkField(last, contLen);
                this.webServer.setWebServerHeader(last, webServerContLen, 0, this.httpHeader);
                this.out.write(this.httpHeader, 0, this.headerCount);
                if (contLen > 0 || last) {
                    this.out.write(this.httpBody, this.webServerHeaderSize + this.chunksizeStartOffset, this.bufferCount - (this.webServerHeaderSize + this.chunksizeStartOffset));
                }
                this.out.flush();
                flushed = true;
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
            } else {
                webServerContLen = this.setChunkField(last, contLen);
                this.webServer.setWebServerHeader(last, webServerContLen + this.webServerHeaderSize, 0, this.httpBody);
                if (webServerContLen > 0) {
                    if (this.chunksizeStartOffset > 0) {
                        this.out.write(this.httpBody, 0, this.webServerHeaderSize);
                        int off = this.webServerHeaderSize + this.chunksizeStartOffset;
                        this.out.write(this.httpBody, off, this.bufferCount - off);
                    } else {
                        this.out.write(this.httpBody, 0, this.bufferCount);
                    }
                    this.out.flush();
                    flushed = true;
                }
            }
            if (flushed) {
                this.bufferCount = this.webServerHeaderSize + this.chunkSizeField.length;
            }
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        return flushed;
    }

    protected int setChunkField(boolean last, int contLen) {
        int len = 0;
        if (contLen > 0) {
            System.arraycopy(this.chunkSizeField, 0, this.httpBody, this.webServerHeaderSize, this.chunkSizeField.length);
            byte[] chunksize = Integer.toHexString(contLen).getBytes();
            this.chunksizeStartOffset = this.chunkSizeField.length - 2 - chunksize.length;
            System.arraycopy(chunksize, 0, this.httpBody, this.webServerHeaderSize + this.chunksizeStartOffset, chunksize.length);
            System.arraycopy(CRLF, 0, this.httpBody, this.bufferCount, CRLF.length);
            this.bufferCount += CRLF.length;
            len = this.bufferCount - this.webServerHeaderSize;
        }
        if (last) {
            if (len > 0) {
                System.arraycopy(LAST_CHUNK, 0, this.httpBody, this.bufferCount, LAST_CHUNK.length);
                this.bufferCount += LAST_CHUNK.length;
                len = this.bufferCount - this.webServerHeaderSize;
            } else {
                System.arraycopy(LAST_CHUNK, 0, this.httpBody, this.webServerHeaderSize, LAST_CHUNK.length);
                this.bufferCount = this.webServerHeaderSize + LAST_CHUNK.length;
                len = LAST_CHUNK.length;
                this.chunksizeStartOffset = 0;
            }
        }
        return len - this.chunksizeStartOffset;
    }

    protected void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.headerCount = this.webServerHeaderSize;
        this.bufferCount = this.webServerHeaderSize + this.chunkSizeField.length;
        this.chunksizeStartOffset = 0;
        this.contentCount = 0;
    }

    protected void resetContent() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize + this.chunkSizeField.length;
        this.chunksizeStartOffset = 0;
        this.contentCount = 0;
    }
}

