/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.servlet.engine.io.ResponseHeaderInfo;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class FullBufferedOutputAdaptor
extends ProtocolOutputAdaptor {
    protected ResponseHeaderInfo responseHeaderInfo;

    protected FullBufferedOutputAdaptor(OutputStream out, WebServerOutputStream webServer, byte[] header, byte[] body) {
        super(out, webServer, header, body);
        this.bufferCount = 0;
    }

    public void setBodyBuffer(byte[] body) {
        this.httpBody = body;
        this.bufferSize = body.length;
        this.headerCount = this.webServerHeaderSize;
        this.bufferCount = 0;
    }

    boolean isEmpty() {
        return !this.committed && this.bufferCount == 0;
    }

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    protected int prepareBuffer(int min, int max) throws IOException {
        int freeSpace = this.httpBody.length - this.bufferCount;
        if (freeSpace < max) {
            int diff = max - freeSpace;
            int newlen = diff <= this.bufferSize ? this.httpBody.length + this.bufferSize : this.httpBody.length + diff + this.bufferSize;
            byte[] tmpBuffer = new byte[newlen];
            System.arraycopy(this.httpBody, 0, tmpBuffer, 0, this.bufferCount);
            this.httpBody = tmpBuffer;
            tmpBuffer = null;
            return this.httpBody.length - this.bufferCount;
        }
        return freeSpace;
    }

    protected void writeHeader() {
        int webServerHeaderSize = this.webServer.getWebServerHeaderSize();
        if (this.headerCount > webServerHeaderSize) {
            return;
        }
        this.responseHeaderInfo = this.webServer.getResponseHeader();
        byte[] content = null;
        byte[] statusLine = new byte[]{};
        WebProperties props = PropertyUtil.getContextProperties();
        String encoding = props.RESPONSE_HEADER_ENCODING.value;
        if (this.responseHeaderInfo.statusLine != null) {
            if (encoding == null) {
                statusLine = this.responseHeaderInfo.statusLine.toString().getBytes();
            } else {
                try {
                    statusLine = this.responseHeaderInfo.statusLine.toString().getBytes(encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    statusLine = this.responseHeaderInfo.statusLine.toString().getBytes();
                }
            }
        }
        if (encoding == null) {
            content = this.responseHeaderInfo.responseHeader.toString().getBytes();
        } else {
            try {
                content = this.responseHeaderInfo.responseHeader.toString().getBytes(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                content = this.responseHeaderInfo.responseHeader.toString().getBytes();
            }
        }
        if (statusLine.length + content.length > this.httpHeader.length - webServerHeaderSize) {
            this.httpHeader = this.webServer.resizeHttpHeader(32 + statusLine.length + content.length + webServerHeaderSize);
        }
        if (statusLine.length > 0) {
            System.arraycopy(statusLine, 0, this.httpHeader, this.headerCount, statusLine.length);
            this.headerCount += statusLine.length;
        }
        System.arraycopy(content, 0, this.httpHeader, this.headerCount, content.length);
        this.headerCount += content.length;
    }

    protected void writeContentLength() {
        String str;
        byte[] b;
        int contentLength = this.bufferCount;
        if (this.responseHeaderInfo.contentLength >= 0) {
            contentLength = this.responseHeaderInfo.contentLength;
        }
        if ((b = (str = "Content-Length: " + String.valueOf(contentLength) + "\r\n\r\n").getBytes()).length > this.httpHeader.length - this.headerCount) {
            byte[] tmp = this.httpHeader;
            this.httpHeader = this.webServer.resizeHttpHeader(this.httpHeader.length + b.length);
            System.arraycopy(tmp, 0, this.httpHeader, 0, this.headerCount);
            tmp = null;
        }
        System.arraycopy(b, 0, this.httpHeader, this.headerCount, b.length);
        this.headerCount += b.length;
        if (logger.isLoggable(JeusMessage_WebContainer2._3273_LEVEL)) {
            logger.log(JeusMessage_WebContainer2._3273_LEVEL, JeusMessage_WebContainer2._3273, (Object)new String(this.httpHeader, this.webServerHeaderSize, this.headerCount - this.webServerHeaderSize));
        }
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        try {
            if (last) {
                this.writeHeader();
                this.writeContentLength();
                this.webServer.setWebServerHeader(last, this.bufferCount + this.headerCount, 0, this.httpHeader);
                this.out.write(this.httpHeader, 0, this.headerCount);
                this.out.write(this.httpBody, 0, this.bufferCount);
                this.out.flush();
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
                return true;
            }
            if (forced) {
                this.writeHeader();
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
                return false;
            }
            this.committed = true;
            return false;
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
    }

    protected void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = 0;
        this.headerCount = this.webServerHeaderSize;
        this.contentCount = 0;
    }

    protected void resetContent() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = 0;
        this.contentCount = 0;
    }
}

