/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.Cookie;
import jeus.servlet.property.PropertyUtil;
import jeus.servlet.property.WebProperties;
import jeus.servlet.util.CookieUtil;

public class ResponseHeaderInfo {
    private HashMap headers;
    private Vector userCookies;
    private String customHeader;
    Vector customHeaderVector;
    String encoding;
    int status;
    StringBuffer statusLine;
    int contentLength;
    StringBuffer responseHeader;

    public ResponseHeaderInfo(int status, StringBuffer sline, HashMap headers, Vector cookies, String customHeader, Vector cv, int len, String encoding) {
        this.status = status;
        this.statusLine = sline;
        this.headers = headers;
        this.userCookies = cookies;
        this.customHeader = customHeader;
        this.customHeaderVector = cv;
        this.contentLength = len;
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            this.headers.put(name, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concatHeaderValue(String name, String value) {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> values = (ArrayList<String>)this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                values.add(value);
                this.headers.put(name, values);
            } else {
                String oldValue = null;
                if (values.size() > 0) {
                    oldValue = (String)values.get(0);
                }
                values = new ArrayList();
                if (oldValue != null) {
                    String newValue = oldValue + ", " + value;
                    values.add(newValue);
                    this.headers.put(name, values);
                } else {
                    values.add(value);
                    this.headers.put(name, values);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processResponseHeader() {
        StringBuffer headersSB = new StringBuffer();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList clen = (ArrayList)this.headers.remove("Content-Length");
            ArrayList clen2 = (ArrayList)this.headers.remove("content-length");
            Enumeration keys = new Hashtable(this.headers).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                ArrayList values = (ArrayList)this.headers.get(key);
                int size = values.size();
                if (size <= 0) continue;
                for (int i = 0; i < size; ++i) {
                    String value = (String)values.get(i);
                    headersSB.append(key).append(": ").append(value).append("\r\n");
                }
            }
            if (clen != null) {
                this.headers.put("Content-Length", clen);
            }
            if (clen2 != null) {
                this.headers.put("content-length", clen);
            }
        }
        Enumeration cookieEnum = this.userCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            String cookieValue;
            String cookieName;
            Cookie c = (Cookie)cookieEnum.nextElement();
            WebProperties props = PropertyUtil.getContextProperties();
            if (props.COOKIE_VERSION0_STYLE.value) {
                cookieName = "Set-Cookie";
                cookieValue = CookieUtil.getCookieHeaderValueWithVersion0(c);
                headersSB.append(cookieName).append(": ").append(cookieValue).append("\r\n");
                continue;
            }
            cookieName = CookieUtil.getCookieHeaderName(c);
            cookieValue = CookieUtil.getCookieHeaderValue(c);
            headersSB.append(cookieName).append(": ").append(cookieValue).append("\r\n");
            if (c.getVersion() != 1) continue;
            Cookie c0 = (Cookie)c.clone();
            if (!WebProperties.J2EE_COMPATIBLE.value) {
                c0.setVersion(0);
            }
            cookieName = CookieUtil.getCookieHeaderName(c0);
            cookieValue = CookieUtil.getCookieHeaderValue(c0);
            headersSB.append(cookieName).append(": ").append(cookieValue).append("\r\n");
        }
        if (this.customHeader != null) {
            headersSB.append(this.customHeader);
        }
        this.responseHeader = headersSB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList processResponseHeader2() {
        ArrayList<String> result = new ArrayList<String>();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            Enumeration keys = new Hashtable(this.headers).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                ArrayList values = (ArrayList)this.headers.get(key);
                int size = values.size();
                if (size <= 0) continue;
                for (int i = 0; i < size; ++i) {
                    String value = (String)values.get(i);
                    result.add(key);
                    result.add(value);
                }
            }
        }
        Enumeration cookieEnum = this.userCookies.elements();
        while (cookieEnum.hasMoreElements()) {
            Cookie c = (Cookie)cookieEnum.nextElement();
            String cookieName = CookieUtil.getCookieHeaderName(c);
            String cookieValue = CookieUtil.getCookieHeaderValue(c);
            result.add(cookieName);
            result.add(cookieValue);
            if (c.getVersion() != 1) continue;
            Cookie c0 = (Cookie)c.clone();
            c0.setVersion(0);
            cookieName = CookieUtil.getCookieHeaderName(c0);
            cookieValue = CookieUtil.getCookieHeaderValue(c0);
            result.add(cookieName);
            result.add(cookieValue);
        }
        if (this.customHeaderVector != null) {
            Enumeration enum1 = this.customHeaderVector.elements();
            while (enum1.hasMoreElements()) {
                String field = (String)enum1.nextElement();
                int pos = field.indexOf(":");
                if (pos <= 0) continue;
                String name = field.substring(0, pos);
                String value = field.substring(pos + 1);
                name = name.trim();
                value = value.trim();
                result.add(name);
                result.add(value);
            }
        }
        return result;
    }
}

