/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.IOException;
import java.io.Writer;
import jeus.servlet.engine.io.ServletStreamWriter;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public final class UnbufferedServletStreamWriter
extends ServletStreamWriter {
    private Writer out;

    public UnbufferedServletStreamWriter(Writer out) {
        super(out);
        if (out == null) {
            throw new NullPointerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3735));
        }
        this.out = out;
        this.flushed = false;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3736));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flushed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.out.write(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.out.write(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len, boolean autoFlush) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.out.write(s, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.out.close();
            this.out = null;
        }
    }

    public void clear() throws IOException {
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3510));
    }

    public void clearBuffer() throws IOException {
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3510));
    }

    public int getUsed() {
        return 0;
    }
}

