/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.engine.io;

import java.io.OutputStream;
import jeus.servlet.engine.WebtobServletRequest;
import jeus.servlet.engine.WebtobSocketInfo;
import jeus.servlet.engine.io.WebServerOutputStream;
import jeus.servlet.engine.io.WebtobHeader;

public class WebtobOutputStream
extends WebServerOutputStream
implements WebtobHeader {
    private int webtobClenCount = 0;

    public WebtobOutputStream(OutputStream out, int bufsize) {
        super(out, bufsize);
        this.initializeAdaptor();
    }

    public int getWebServerHeaderSize() {
        return 96;
    }

    public void setWebServerHeader(boolean last, int totalCount, int off, byte[] buf) {
        for (int i = off; i < off + 96; ++i) {
            buf[i] = 0;
        }
        this.webtobClenCount += (totalCount -= 96);
        WebtobServletRequest webtobreq = (WebtobServletRequest)this.request;
        buf[off + 0] = 0;
        buf[off + 1] = 0;
        buf[off + 2] = 39;
        buf[off + 3] = 15;
        buf[off + 84] = (byte)(totalCount >> 24);
        buf[off + 84 + 1] = (byte)(totalCount >> 16);
        buf[off + 84 + 2] = (byte)(totalCount >> 8);
        buf[off + 84 + 3] = (byte)totalCount;
        int type = 1301;
        if (this.bufferedMode) {
            type = last ? 5302 : 5301;
        }
        buf[off + 16] = (byte)(type >> 24);
        buf[off + 16 + 1] = (byte)(type >> 16);
        buf[off + 16 + 2] = (byte)(type >> 8);
        buf[off + 16 + 3] = (byte)type;
        int value = webtobreq.getWebtobSequenceNumber();
        buf[off + 4] = (byte)(value >> 24);
        buf[off + 4 + 1] = (byte)(value >> 16);
        buf[off + 4 + 2] = (byte)(value >> 8);
        buf[off + 4 + 3] = (byte)value;
        value = this.response.getStatus();
        buf[off + 20] = (byte)(value >> 24);
        buf[off + 20 + 1] = (byte)(value >> 16);
        buf[off + 20 + 2] = (byte)(value >> 8);
        buf[off + 20 + 3] = (byte)value;
        value = webtobreq.getWebtobClientId();
        buf[off + 24] = (byte)(value >> 24);
        buf[off + 24 + 1] = (byte)(value >> 16);
        buf[off + 24 + 2] = (byte)(value >> 8);
        buf[off + 24 + 3] = (byte)value;
        value = webtobreq.getWebtobEtc();
        buf[off + 28] = (byte)(value >> 24);
        buf[off + 28 + 1] = (byte)(value >> 16);
        buf[off + 28 + 2] = (byte)(value >> 8);
        buf[off + 28 + 3] = (byte)value;
        value = webtobreq.getWebtobSvciFlags();
        buf[off + 88] = (byte)(value >> 24);
        buf[off + 88 + 1] = (byte)(value >> 16);
        buf[off + 88 + 2] = (byte)(value >> 8);
        buf[off + 88 + 3] = (byte)value;
        value = webtobreq.getWebtobSvciCd();
        buf[off + 92] = (byte)(value >> 24);
        buf[off + 92 + 1] = (byte)(value >> 16);
        buf[off + 92 + 2] = (byte)(value >> 8);
        buf[off + 92 + 3] = (byte)value;
        if (last) {
            this.webtobClenCount -= this.adaptor.getHttpHeaderSize();
            buf[off + 32] = (byte)(this.webtobClenCount >> 24);
            buf[off + 32 + 1] = (byte)(this.webtobClenCount >> 16);
            buf[off + 32 + 2] = (byte)(this.webtobClenCount >> 8);
            buf[off + 32 + 3] = (byte)this.webtobClenCount;
            this.webtobClenCount = 0;
        }
    }

    public void requestShutdown() {
        if (this.out == null) {
            return;
        }
        byte[] header = new byte[96];
        int msglen = 0;
        header[0] = 0;
        header[1] = 0;
        header[2] = 39;
        header[3] = 15;
        header[16] = 0;
        header[17] = 0;
        header[18] = 0;
        header[19] = 105;
        header[84] = (byte)(msglen >> 24);
        header[85] = (byte)(msglen >> 16);
        header[86] = (byte)(msglen >> 8);
        header[87] = (byte)msglen;
        this.setUrgentMessage(header);
    }

    public void requestSuspend(WebtobSocketInfo info) {
        if (this.out == null) {
            return;
        }
        byte[] header = new byte[96];
        int msglen = 0;
        header[0] = 0;
        header[1] = 0;
        header[2] = 39;
        header[3] = 15;
        header[16] = 0;
        header[17] = 0;
        header[18] = 0;
        header[19] = 124;
        header[84] = (byte)(msglen >> 24);
        header[85] = (byte)(msglen >> 16);
        header[86] = (byte)(msglen >> 8);
        header[87] = (byte)msglen;
        this.fillWebtobInfo(header, info);
        this.setUrgentMessage(header);
    }

    public void requestResume(WebtobSocketInfo info) {
        if (this.out == null) {
            return;
        }
        byte[] header = new byte[96];
        int msglen = 0;
        header[0] = 0;
        header[1] = 0;
        header[2] = 39;
        header[3] = 15;
        header[16] = 0;
        header[17] = 0;
        header[18] = 0;
        header[19] = 125;
        header[84] = (byte)(msglen >> 24);
        header[85] = (byte)(msglen >> 16);
        header[86] = (byte)(msglen >> 8);
        header[87] = (byte)msglen;
        this.fillWebtobInfo(header, info);
        this.setUrgentMessage(header);
        this.sendUrgentMessage();
    }

    private void fillWebtobInfo(byte[] header, WebtobSocketInfo info) {
        if (info != null) {
            int value = info.getThreadId();
            header[28] = (byte)(value >> 24);
            header[29] = (byte)(value >> 16);
            header[30] = (byte)(value >> 8);
            header[31] = (byte)value;
            value = info.getSvri();
            header[20] = (byte)(value >> 24);
            header[21] = (byte)(value >> 16);
            header[22] = (byte)(value >> 8);
            header[23] = (byte)value;
            value = info.getClid();
            header[24] = (byte)(value >> 24);
            header[25] = (byte)(value >> 16);
            header[26] = (byte)(value >> 8);
            header[27] = (byte)value;
            value = info.getSpri();
            header[92] = (byte)(value >> 24);
            header[93] = (byte)(value >> 16);
            header[94] = (byte)(value >> 8);
            header[95] = (byte)value;
        }
    }

    protected void webServerFinish() {
    }
}

