/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.filter;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jeus.servlet.engine.ExecutionWrapper;
import jeus.servlet.filter.FilterConfigImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer2;

public class FilterChainImpl
implements FilterChain {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.filter");
    public static final int INCREMENT = 10;
    private FilterConfigImpl[] filters = new FilterConfigImpl[0];
    private int pos = 0;
    private int n = 0;
    private ExecutionWrapper wrapper = null;

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (System.getSecurityManager() != null) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        FilterChainImpl.this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            FilterConfigImpl filterConfig = this.filters[this.pos++];
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                if (filter == null) {
                    return;
                }
                filter.doFilter(request, response, (FilterChain)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                ServletException se = new ServletException("failed to filter a request", e);
                if (logger.isLoggable(JeusMessage_WebContainer2._3958_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3958_LEVEL, JeusMessage_WebContainer2._3958, (Throwable)se);
                }
                throw se;
            }
            return;
        }
        if (this.wrapper != null) {
            this.wrapper.executeServlet(request, response);
        }
    }

    void addFilter(FilterConfigImpl filterConfig) {
        if (this.n == this.filters.length) {
            FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 10];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    public void release() {
        this.n = 0;
        this.pos = 0;
        this.wrapper = null;
    }

    void setExecutionWrapper(ExecutionWrapper wrapper) {
        this.wrapper = wrapper;
    }
}

