/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.filter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import jeus.servlet.engine.Context;
import jeus.servlet.filter.FilterDef;
import jeus.servlet.filter.FilterWrapper;
import jeus.servlet.filter.util.Enumerator;
import jeus.servlet.loader.ContextLoader;

public class FilterConfigImpl
implements FilterConfig {
    private Context context;
    private transient Filter filter = null;
    private FilterDef filterDef = null;

    public FilterConfigImpl(Context context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getInitParameter(String name) {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(name);
    }

    public Enumeration getInitParameterNames() {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator(new ArrayList());
        }
        return new Enumerator(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClass());
        sb.append("]");
        return sb.toString();
    }

    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        if (this.filter != null) {
            return this.filter;
        }
        ContextLoader loader = this.context.getContextLoader();
        if (loader == null) {
            return null;
        }
        FilterWrapper filterWrapper = loader.createFilter(this.filterDef.getFilterName(), this.filterDef.getFilterClass(), this);
        this.filter = filterWrapper.getFilter();
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    public void release() {
        if (this.filter != null) {
            this.filter.destroy();
        }
        this.filter = null;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            this.release();
        } else {
            this.getFilter();
        }
    }
}

