/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.filter;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.container.web.ServletSecurity;
import jeus.security.util.Base64Coder;
import jeus.security.util.MD5Encoder;
import jeus.servlet.connection.SSLSupport;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.filter.DigestLoginInfo;
import jeus.servlet.filter.LoginInfo;
import jeus.sessionmanager.util.SecureSessionIdGenerator;

public final class LoginFilter
implements Filter {
    public static final String J_SECURITY_CHECK = "j_security_check";
    public static final String J_SECURITY_CHECK_WITH_SLASH = "/j_security_check";
    public static final String J_USERNAME = "j_username";
    public static final String J_PASSWORD = "j_password";
    public static final String JEUS_SECURITY_AUTHORIZED = "jeus.servlet.request.authorized";
    public static final String BASIC_AUTHORIZATION_VALUE = "Basic ";
    public static final String DIGEST_AUTHORIZATION_VALUE = "Digest ";
    public static final String AUTH_METHOD_PARAM = "auth-method";
    public static final String FORM_LOGIN_PAGE_PARAM = "form-login-page";
    public static final String FORM_ERROR_PAGE_PARAM = "form-error-page";
    public static final String REALM_NAME_PARAM = "realm-name";
    public static final String AUTH_METHOD_BASIC = "BASIC";
    public static final String AUTH_METHOD_FORM = "FORM";
    public static final String AUTH_METHOD_DIGEST = "DIGEST";
    public static final String AUTH_METHOD_CLIENT_CERT = "CLIENT-CERT";
    private static final int AUTH_METHOD_BASIC_INT = 1;
    private static final int AUTH_METHOD_FORM_INT = 2;
    private static final int AUTH_METHOD_DIGEST_INT = 3;
    private static final int AUTH_METHOD_CLIENT_CERT_INT = 4;
    private static final MD5Encoder md5Encoder = new MD5Encoder();
    private static MessageDigest md5Helper = null;
    private boolean doCheck = false;
    private int loginType = 1;
    private String formLoginPage = null;
    private String formErrorPage = null;
    private String realmName = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.realmName = filterConfig.getInitParameter(REALM_NAME_PARAM);
        String authMethod = filterConfig.getInitParameter(AUTH_METHOD_PARAM);
        if (authMethod == null) {
            this.doCheck = false;
            return;
        }
        if (authMethod.equals(AUTH_METHOD_FORM)) {
            this.loginType = 2;
            this.formLoginPage = filterConfig.getInitParameter(FORM_LOGIN_PAGE_PARAM);
            this.formErrorPage = filterConfig.getInitParameter(FORM_ERROR_PAGE_PARAM);
            this.doCheck = this.formLoginPage != null;
        } else if (authMethod.equals(AUTH_METHOD_DIGEST)) {
            this.loginType = 3;
            try {
                if (md5Helper == null) {
                    md5Helper = MessageDigest.getInstance("MD5");
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new IllegalStateException();
            }
            this.doCheck = true;
        } else if (authMethod.equals(AUTH_METHOD_CLIENT_CERT)) {
            this.loginType = 4;
            this.doCheck = true;
        } else {
            this.loginType = 1;
            this.doCheck = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(this.doCheck && request instanceof HttpServletRequestImpl && response instanceof HttpServletResponseImpl)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequestImpl jeusRequest = (HttpServletRequestImpl)request;
        HttpServletResponseImpl jeusResponse = (HttpServletResponseImpl)response;
        Context context = jeusRequest.getContext();
        if (context == null) {
            chain.doFilter(request, response);
            return;
        }
        if (!jeusRequest.getRequestURI().endsWith(J_SECURITY_CHECK)) {
            ServletSecurity.setServletSecurityContext(context.getAppPolicyID(), jeusRequest);
            try {
                if (this.checkUserDataPermission(jeusRequest) && this.checkResourcePermission(jeusRequest)) {
                    jeusRequest.setAttribute(JEUS_SECURITY_AUTHORIZED, Boolean.TRUE);
                    chain.doFilter(request, response);
                    return;
                }
            }
            finally {
                ServletSecurity.clearServletSecurityContext();
            }
        }
        if (!this.login(jeusRequest, jeusResponse)) {
            return;
        }
        try {
            ServletSecurity.setServletSecurityContext(context.getAppPolicyID(), jeusRequest);
            try {
                if (this.checkUserDataPermission(jeusRequest) && this.checkResourcePermission(jeusRequest)) {
                    jeusRequest.setAttribute(JEUS_SECURITY_AUTHORIZED, Boolean.TRUE);
                    chain.doFilter(request, response);
                } else {
                    this.internalSendError(request, jeusResponse, 403, this.formErrorPage, "Access Denied");
                }
            }
            finally {
                ServletSecurity.clearServletSecurityContext();
            }
        }
        finally {
            try {
                ServletSecurity.logoutServletCaller();
            }
            catch (ServiceException e) {
            }
            catch (SecurityException e) {}
        }
    }

    public void destroy() {
    }

    private boolean checkUserDataPermission(HttpServletRequestImpl request) {
        WebUserDataPermission wudPerm;
        if (request.getServletPath() != null) {
            wudPerm = new WebUserDataPermission((HttpServletRequest)request);
        } else {
            String[] httpMethods = new String[]{request.getMethod()};
            String transportType = null;
            transportType = request.isSecure() ? "CONFIDENTIAL" : "NONE";
            wudPerm = new WebUserDataPermission(request.getPathInfo(), httpMethods, transportType);
        }
        try {
            ServletSecurity.checkServletUserDataPermission(wudPerm);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            try {
                if (!ServletSecurity.isAnonymousSubject()) {
                    e.printStackTrace();
                }
            }
            catch (SecurityException e1) {
            }
            catch (ServiceException e1) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private boolean checkResourcePermission(HttpServletRequestImpl request) {
        WebResourcePermission wudPerm;
        if (request.getServletPath() != null) {
            wudPerm = new WebResourcePermission((HttpServletRequest)request);
        } else {
            String[] httpMethods = new String[]{request.getMethod()};
            wudPerm = new WebResourcePermission(request.getPathInfo(), httpMethods);
        }
        try {
            ServletSecurity.checkServletAccessPermission(wudPerm);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            try {
                if (!ServletSecurity.isAnonymousSubject()) {
                    e.printStackTrace();
                }
            }
            catch (SecurityException e1) {
            }
            catch (ServiceException e1) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private boolean login(HttpServletRequestImpl request, HttpServletResponseImpl response) {
        try {
            switch (this.loginType) {
                case 1: {
                    return this.loginBasic(request, response);
                }
                case 2: {
                    return this.loginForm(request, response);
                }
                case 3: {
                    return this.loginDigest(request, response);
                }
                case 4: {
                    return this.loginCertificate(request, response);
                }
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ServletException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loginForm(HttpServletRequestImpl request, HttpServletResponseImpl response) throws IOException, ServletException {
        String password;
        HttpSession session = request.getSession();
        LoginInfo info = (LoginInfo)session.getAttribute(J_SECURITY_CHECK);
        String domainName = this.getDomainNameFromContext(request.getContext());
        if (!request.getRequestURI().endsWith(J_SECURITY_CHECK)) {
            if (info == null) {
                info = new LoginInfo();
                info.orgURL = request.getRequestURI();
                info.queryString = request.getQueryString();
                session.setAttribute(J_SECURITY_CHECK, (Object)info);
                RequestDispatcher dispatcher = request.getRequestDispatcher(this.formLoginPage);
                if (dispatcher != null) {
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    this.internalSendError((ServletRequest)request, response, 404, this.formErrorPage, "login page not found : " + this.formLoginPage);
                }
                return false;
            }
            if (this.authenticate(info.subject)) {
                request.setUserPrincipal(info.subject.getPrincipal());
                request.setAuthType(AUTH_METHOD_FORM);
                return true;
            }
            this.internalSendError((ServletRequest)request, response, 403, this.formLoginPage, "login failed");
            return false;
        }
        String username = request.getParameter(J_USERNAME);
        if (this.authenticate(domainName, username, password = request.getParameter(J_PASSWORD))) {
            try {
                if (info == null) {
                    info = new LoginInfo();
                }
                info.username = username;
                info.password = password;
                info.subject = ServletSecurity.getCurrentSubject();
                request.setUserPrincipal(info.subject.getPrincipal());
                request.setAuthType(AUTH_METHOD_FORM);
                session.setAttribute(J_SECURITY_CHECK, (Object)info);
            }
            finally {
                try {
                    ServletSecurity.logoutServletCaller();
                }
                catch (ServiceException e) {
                }
                catch (SecurityException e) {}
            }
            response.sendRedirect(this.getRedirectPathInForm(request, info));
            return false;
        }
        this.internalSendError((ServletRequest)request, response, 403, this.formErrorPage, "login failed");
        return false;
    }

    private boolean loginBasic(HttpServletRequestImpl request, HttpServletResponseImpl response) throws IOException, ServletException {
        LoginInfo requestHeaderInfo = LoginFilter.getBasicLoginInfoFromRequestHeader(request);
        HttpSession session = request.getSession();
        LoginInfo info = (LoginInfo)session.getAttribute(J_SECURITY_CHECK);
        String domainName = this.getDomainNameFromContext(request.getContext());
        if (this.authenticate(domainName, requestHeaderInfo.username, requestHeaderInfo.password)) {
            if (info == null) {
                info = new LoginInfo();
            }
            info.username = requestHeaderInfo.username;
            info.password = requestHeaderInfo.password;
            info.subject = ServletSecurity.getCurrentSubject();
            request.setUserPrincipal(info.subject.getPrincipal());
            request.setAuthType(AUTH_METHOD_BASIC);
            session.setAttribute(J_SECURITY_CHECK, (Object)info);
            return true;
        }
        if (info != null && this.authenticate(info.subject)) {
            request.setUserPrincipal(info.subject.getPrincipal());
            request.setAuthType(AUTH_METHOD_BASIC);
            return true;
        }
        this.internalSendError(request, response);
        return false;
    }

    private boolean loginDigest(HttpServletRequestImpl request, HttpServletResponseImpl response) throws IOException, ServletException {
        DigestLoginInfo requestHeaderInfo = LoginFilter.getDigestLoginInfoFromRequestHeader(request);
        HttpSession session = request.getSession();
        LoginInfo info = (LoginInfo)session.getAttribute(J_SECURITY_CHECK);
        String domainName = this.getDomainNameFromContext(request.getContext());
        if (this.authenticate(domainName, requestHeaderInfo)) {
            if (info == null || !(info instanceof DigestLoginInfo)) {
                info = new DigestLoginInfo();
            }
            DigestLoginInfo digestInfo = (DigestLoginInfo)info;
            digestInfo.username = requestHeaderInfo.username;
            digestInfo.subject = ServletSecurity.getCurrentSubject();
            digestInfo.realm = requestHeaderInfo.realm;
            digestInfo.nonce = requestHeaderInfo.nonce;
            digestInfo.nc = requestHeaderInfo.nc;
            digestInfo.cnonce = requestHeaderInfo.cnonce;
            digestInfo.qop = requestHeaderInfo.qop;
            digestInfo.uri = requestHeaderInfo.uri;
            digestInfo.response = requestHeaderInfo.response;
            request.setUserPrincipal(digestInfo.subject.getPrincipal());
            request.setAuthType(AUTH_METHOD_DIGEST);
            session.setAttribute(J_SECURITY_CHECK, (Object)digestInfo);
            return true;
        }
        if (info != null && this.authenticate(info.subject)) {
            request.setUserPrincipal(info.subject.getPrincipal());
            request.setAuthType(AUTH_METHOD_DIGEST);
            return true;
        }
        this.internalSendError(request, response);
        return false;
    }

    private boolean loginCertificate(HttpServletRequestImpl request, HttpServletResponseImpl response) throws IOException, ServletException {
        SSLSupport sslSupport;
        HttpSession session = request.getSession();
        LoginInfo info = (LoginInfo)session.getAttribute(J_SECURITY_CHECK);
        String domainName = this.getDomainNameFromContext(request.getContext());
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if ((certs == null || certs.length < 1) && (sslSupport = request.getSslSupport()) != null) {
            try {
                certs = (X509Certificate[])sslSupport.getPeerCertificateChain(true);
                if (certs != null) {
                    request.setAttribute("javax.servlet.request.X509Certificate", certs);
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (certs == null || certs.length < 1) {
            this.internalSendError(request, response, 400, "No certificates included with this request");
            return false;
        }
        if (this.authenticate(domainName, certs)) {
            if (info == null) {
                info = new LoginInfo();
            }
            info.subject = ServletSecurity.getCurrentSubject();
            request.setUserPrincipal(info.subject.getPrincipal());
            request.setAuthType("CLIENT_CERT");
            session.setAttribute(J_SECURITY_CHECK, (Object)info);
            return true;
        }
        if (info != null && this.authenticate(info.subject)) {
            request.setUserPrincipal(info.subject.getPrincipal());
            request.setAuthType("CLIENT_CERT");
            return true;
        }
        this.internalSendError(request, response);
        return false;
    }

    private boolean authenticate(String domainName, String username, String password) {
        if (username == null || username.length() == 0) {
            return false;
        }
        try {
            ServletSecurity.loginServletCaller(domainName, username, password);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean authenticate(Subject subject) {
        if (subject == null) {
            return false;
        }
        try {
            ServletSecurity.loginServletCaller(subject);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(String domainName, DigestLoginInfo digestInfo) {
        if (digestInfo == null || digestInfo.username == null || digestInfo.username.length() == 0) {
            return false;
        }
        String a2 = digestInfo.method + ":" + digestInfo.uri;
        byte[] buffer = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(a2.getBytes());
        }
        String md5a2 = md5Encoder.encode(buffer);
        try {
            ServletSecurity.loginServletCaller(domainName, digestInfo.username, digestInfo.response, digestInfo.nonce, digestInfo.nc, digestInfo.cnonce, digestInfo.qop, digestInfo.realm, md5a2);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean authenticate(String domainName, X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return false;
        }
        try {
            ServletSecurity.loginServletCaller(domainName, certs);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void internalSendError(ServletRequest request, HttpServletResponse response, int status, String pageName, String errorMessage) throws IOException, ServletException {
        RequestDispatcher dispatcher = request.getRequestDispatcher(pageName);
        if (dispatcher == null) {
            response.setStatus(status);
            response.sendError(status, errorMessage);
        } else {
            response.setStatus(status);
            dispatcher.forward(request, (ServletResponse)response);
        }
    }

    private void internalSendError(HttpServletRequestImpl request, HttpServletResponseImpl response) throws IOException {
        this.internalSendError(request, response, 401, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSendError(HttpServletRequestImpl request, HttpServletResponseImpl response, int status, String message) throws IOException {
        String realmMsg = this.realmName != null ? this.realmName : request.getServerName() + ":" + request.getServerPort();
        String authenticateHeader = null;
        if (message == null) {
            message = request.getRequestURI() + " is unauthorized to " + request.getRemoteUser();
        }
        switch (this.loginType) {
            case 1: {
                authenticateHeader = "Basic realm=\"" + realmMsg + "\"";
                break;
            }
            case 3: {
                byte[] buffer = null;
                String nonce = request.getRemoteAddr() + ":" + SecureSessionIdGenerator.generateId();
                MessageDigest messageDigest = md5Helper;
                synchronized (messageDigest) {
                    buffer = md5Helper.digest(nonce.getBytes());
                }
                nonce = md5Encoder.encode(buffer);
                messageDigest = md5Helper;
                synchronized (messageDigest) {
                    buffer = md5Helper.digest(nonce.getBytes());
                }
                authenticateHeader = "Digest realm=\"" + realmMsg + "\", " + "qop=\"auth\", nonce=\"" + nonce + "\", " + "opaque=\"" + md5Encoder.encode(buffer) + "\"";
                break;
            }
            case 4: {
                break;
            }
        }
        response.sendAuthRequest(status, authenticateHeader, message);
    }

    private String getDomainNameFromContext(Context context) {
        if (context == null) {
            return null;
        }
        return context.getDomainName();
    }

    private String getRedirectPathInForm(HttpServletRequestImpl request, LoginInfo info) {
        String redirectPath;
        String contextPath = request.getContextPath();
        if (info == null || info.orgURL == null) {
            redirectPath = contextPath;
        } else {
            String fullLoginPage = !contextPath.endsWith("/") && this.formLoginPage != null && !this.formLoginPage.startsWith("/") ? contextPath + "/" + this.formLoginPage : contextPath + this.formLoginPage;
            if (info.orgURL.equals(fullLoginPage)) {
                redirectPath = contextPath;
            } else {
                redirectPath = info.orgURL;
                if (info.queryString != null) {
                    redirectPath = redirectPath + "?" + info.queryString;
                }
            }
        }
        return redirectPath;
    }

    public static LoginInfo getBasicLoginInfoFromRequestHeader(HttpServletRequest request) {
        LoginInfo info = new LoginInfo();
        if (request == null) {
            return info;
        }
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.length() > BASIC_AUTHORIZATION_VALUE.length()) {
            String authorizationPrefix = authorization.substring(0, BASIC_AUTHORIZATION_VALUE.length());
            if (authorizationPrefix.equalsIgnoreCase(BASIC_AUTHORIZATION_VALUE)) {
                String enAuthorizationValue = authorization.substring(BASIC_AUTHORIZATION_VALUE.length());
                String deAuthorizationValue = Base64Coder.decode(enAuthorizationValue);
                int pos = deAuthorizationValue.indexOf(":");
                if (pos < 0) {
                    info.username = deAuthorizationValue;
                    info.password = null;
                } else {
                    info.username = deAuthorizationValue.substring(0, pos);
                    info.password = deAuthorizationValue.substring(pos + 1);
                }
            } else {
                info.clear();
            }
        } else {
            info.clear();
        }
        return info;
    }

    public static DigestLoginInfo getDigestLoginInfoFromRequestHeader(HttpServletRequest request) {
        DigestLoginInfo info = new DigestLoginInfo();
        if (request == null) {
            return info;
        }
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.length() > DIGEST_AUTHORIZATION_VALUE.length()) {
            String authorizationPrefix = authorization.substring(0, DIGEST_AUTHORIZATION_VALUE.length());
            if (authorizationPrefix.equalsIgnoreCase(DIGEST_AUTHORIZATION_VALUE)) {
                StringTokenizer commaTokenizer = new StringTokenizer(authorization.substring(DIGEST_AUTHORIZATION_VALUE.length()), ",");
                while (commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    int equalSign = currentToken.indexOf(61);
                    if (equalSign < 0) {
                        info.clear();
                        return info;
                    }
                    String currentTokenName = currentToken.substring(0, equalSign).trim();
                    String currentTokenValue = currentToken.substring(equalSign + 1).trim();
                    if ("username".equals(currentTokenName)) {
                        info.username = LoginFilter.removeQuotes(currentTokenValue, false);
                    }
                    if ("realm".equals(currentTokenName)) {
                        info.realm = LoginFilter.removeQuotes(currentTokenValue, true);
                    }
                    if ("nonce".equals(currentTokenName)) {
                        info.nonce = LoginFilter.removeQuotes(currentTokenValue, false);
                    }
                    if ("nc".equals(currentTokenName)) {
                        info.nc = LoginFilter.removeQuotes(currentTokenValue, false);
                    }
                    if ("cnonce".equals(currentTokenName)) {
                        info.cnonce = LoginFilter.removeQuotes(currentTokenValue, false);
                    }
                    if ("qop".equals(currentTokenName)) {
                        info.qop = LoginFilter.removeQuotes(currentTokenValue, false);
                    }
                    if ("uri".equals(currentTokenName)) {
                        info.uri = LoginFilter.removeQuotes(currentTokenValue, false);
                    }
                    if (!"response".equals(currentTokenName)) continue;
                    info.response = LoginFilter.removeQuotes(currentTokenValue, false);
                }
                String string = info.method = request != null ? request.getMethod() : null;
                if (info.username == null || info.realm == null || info.nonce == null || info.uri == null || info.response == null) {
                    info.clear();
                }
            } else {
                info.clear();
            }
        } else {
            info.clear();
        }
        return info;
    }

    private static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return new String();
    }
}

