/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class JspMethodProxy {
    private static Object convert(String name, String value, Class type, Class editorClass) throws JspEngineException {
        try {
            if (value == null) {
                if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                    value = "false";
                } else {
                    return null;
                }
            }
            if (editorClass != null) {
                return JspMethodProxy.getValueWithPropertyEditor(type, name, value, editorClass);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                value = value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true") ? "true" : "false";
                return new Boolean(value);
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return new Byte(value);
            }
            if (type.equals(Character.class) || type.equals(Character.TYPE)) {
                return value.length() > 0 ? new Character(value.charAt(0)) : null;
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return new Short(value);
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return new Integer(value);
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return new Float(value);
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return new Long(value);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return new Double(value);
            }
            if (type.equals(String.class)) {
                return value;
            }
            if (type.equals(File.class)) {
                return new File(value);
            }
            if (type.getName().equals("java.lang.Object")) {
                return new Object[]{value};
            }
            return JspMethodProxy.getValueWithPropertyEditorManager(type, name, value);
        }
        catch (Exception ex) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5504, (Object[])new String[]{name, type.toString()}), ex);
        }
    }

    public static void setProperty(Object bean, ServletRequest request) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getParameter(name);
            if (value == null || value.equals("")) continue;
            try {
                JspMethodProxy.setProperty(bean, name, request);
            }
            catch (JspEngineException jee) {}
        }
    }

    private static Object[] findSetMethod(Object bean, String prop) throws JspEngineException {
        try {
            char[] tmp;
            Class<?> pec;
            Class<Object> type;
            Method method;
            Object[] result;
            block11: {
                int i;
                PropertyDescriptor[] pd;
                block10: {
                    BeanInfo info = Introspector.getBeanInfo(bean.getClass());
                    if (info == null) {
                        return new Object[3];
                    }
                    pd = info.getPropertyDescriptors();
                    result = new Object[3];
                    method = null;
                    type = null;
                    pec = null;
                    Method method2 = null;
                    Class<?> type2 = null;
                    Class<?> pec2 = null;
                    if (WebProperties.J2EE_COMPATIBLE.value) break block10;
                    for (i = 0; i < pd.length; ++i) {
                        if (pd[i].getName().equals(prop)) {
                            method = pd[i].getWriteMethod();
                            type = pd[i].getPropertyType();
                            pec = pd[i].getPropertyEditorClass();
                            break;
                        }
                        if (method2 != null || !pd[i].getName().equalsIgnoreCase(prop)) continue;
                        method2 = pd[i].getWriteMethod();
                        type2 = pd[i].getPropertyType();
                        pec2 = pd[i].getPropertyEditorClass();
                    }
                    if (method != null) break block11;
                    method = method2;
                    type = type2;
                    pec = pec2;
                    break block11;
                }
                for (i = 0; i < pd.length; ++i) {
                    if (!pd[i].getName().equals(prop)) continue;
                    method = pd[i].getWriteMethod();
                    type = pd[i].getPropertyType();
                    pec = pd[i].getPropertyEditorClass();
                    break;
                }
            }
            if (method == null && (tmp = prop.toCharArray()).length > 0) {
                tmp[0] = Character.toUpperCase(tmp[0]);
                String methodName = "set" + new String(tmp);
                type = String.class;
                try {
                    method = bean.getClass().getMethod(methodName, type);
                }
                catch (NoSuchMethodException nme) {
                    method = null;
                }
            }
            if (method == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5501, (Object[])new String[]{prop, bean.getClass().getName()}));
            }
            result[0] = method;
            result[1] = type;
            result[2] = pec;
            return result;
        }
        catch (Exception e) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5501, (Object[])new String[]{prop, bean.getClass().getName()}), e);
        }
    }

    public static void setProperty(Object bean, String prop, ServletRequest request) throws JspEngineException {
        try {
            Method method = null;
            Class type = null;
            Class propertyEditorClass = null;
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            method = (Method)result[0];
            type = (Class)result[1];
            propertyEditorClass = (Class)result[2];
            if (type.isArray()) {
                if (request == null) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5500));
                }
                Class<?> t = type.getComponentType();
                String[] values = request.getParameterValues(prop);
                if (values == null) {
                    return;
                }
                if (t.equals(String.class)) {
                    method.invoke(bean, new Object[]{values});
                } else {
                    Object tmpval = null;
                    JspMethodProxy.createTypedArray(bean, method, values, t);
                }
            } else {
                String value = request.getParameter(prop);
                if (value == null || value.equals("")) {
                    return;
                }
                Object oval = JspMethodProxy.convert(prop, value, type, propertyEditorClass);
                if (oval != null) {
                    method.invoke(bean, oval);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty(Object bean, String prop, ServletRequest request, String param) throws JspEngineException {
        try {
            Method method = null;
            Class type = null;
            Class propertyEditorClass = null;
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            method = (Method)result[0];
            type = (Class)result[1];
            propertyEditorClass = (Class)result[2];
            if (type.isArray()) {
                if (request == null) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5500));
                }
                Class<?> t = type.getComponentType();
                String[] values = request.getParameterValues(param);
                if (values == null) {
                    return;
                }
                if (t.equals(String.class)) {
                    method.invoke(bean, new Object[]{values});
                } else {
                    Object tmpval = null;
                    JspMethodProxy.createTypedArray(bean, method, values, t);
                }
            } else {
                String value = request.getParameter(param);
                if (value == null || value.equals("")) {
                    return;
                }
                Object oval = JspMethodProxy.convert(prop, value, type, propertyEditorClass);
                if (oval != null) {
                    method.invoke(bean, oval);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty(Object bean, String prop, String value) throws JspEngineException {
        try {
            Method method = null;
            Class type = null;
            Class propertyEditorClass = null;
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            method = (Method)result[0];
            type = (Class)result[1];
            propertyEditorClass = (Class)result[2];
            if (value == null || value.equals("")) {
                return;
            }
            Object oval = JspMethodProxy.convert(prop, value, type, propertyEditorClass);
            if (oval != null) {
                method.invoke(bean, oval);
            }
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void createTypedArray(Object bean, Method method, String[] values, Class t) throws JspEngineException {
        try {
            if (t.equals(Integer.class)) {
                Integer[] tmpval = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Integer(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Byte.class)) {
                Byte[] tmpval = new Byte[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Byte(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Boolean.class)) {
                Boolean[] tmpval = new Boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Boolean(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Short.class)) {
                Short[] tmpval = new Short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Short(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Long.class)) {
                Long[] tmpval = new Long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Long(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Double.class)) {
                Double[] tmpval = new Double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Double(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Float.class)) {
                Float[] tmpval = new Float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Float(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Character.class)) {
                Character[] tmpval = new Character[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = new Character(values[i].charAt(0));
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Integer.TYPE)) {
                int[] tmpval = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Integer.parseInt(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Byte.TYPE)) {
                byte[] tmpval = new byte[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Byte.parseByte(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Boolean.TYPE)) {
                boolean[] tmpval = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Boolean.getBoolean(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Short.TYPE)) {
                short[] tmpval = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Short.parseShort(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Long.TYPE)) {
                long[] tmpval = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Long.parseLong(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Double.TYPE)) {
                double[] tmpval = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Double.valueOf(values[i]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Float.TYPE)) {
                float[] tmpval = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = Float.valueOf(values[i]).floatValue();
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Character.TYPE)) {
                char[] tmpval = new char[values.length];
                for (int i = 0; i < values.length; ++i) {
                    tmpval[i] = values[i].charAt(0);
                }
                method.invoke(bean, new Object[]{tmpval});
            }
        }
        catch (Exception ex) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5502, (Object[])new String[]{method.getName()}), ex);
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "&;`'\"|*?~<>^()[]{}$\\\n";
        for (int index = 0; index < unescString.length(); ++index) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = escString + "\\";
            }
            escString = escString + nextChar;
        }
        return escString;
    }

    public static void setProperty2(Object bean, String prop, Object value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, int value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Integer(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, short value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Short(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, long value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Long(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, double value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Double(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, float value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Float(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, char value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Character(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, byte value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Byte(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    public static void setProperty2(Object bean, String prop, boolean value) throws JspEngineException {
        try {
            Object[] result = JspMethodProxy.findSetMethod(bean, prop);
            Method method = (Method)result[0];
            method.invoke(bean, new Boolean(value));
        }
        catch (Exception ex) {
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5503, (Object[])new String[]{prop, bean.getClass().getName()}), ex);
        }
    }

    private static Object getValueWithPropertyEditor(Class type, String name, String value, Class editorClass) throws JspEngineException {
        try {
            PropertyEditor pe = (PropertyEditor)editorClass.newInstance();
            pe.setAsText(value);
            return pe.getValue();
        }
        catch (Exception ex) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5650, (Object[])new String[]{value, type.getName(), name}), ex);
        }
    }

    private static Object getValueWithPropertyEditorManager(Class type, String name, String value) throws JspEngineException {
        try {
            PropertyEditor propEditor = PropertyEditorManager.findEditor(type);
            if (propEditor != null) {
                propEditor.setAsText(value);
                return propEditor.getValue();
            }
            throw new IllegalArgumentException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5492));
        }
        catch (IllegalArgumentException ex) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5650, (Object[])new String[]{value, type.getName(), name}), ex);
        }
    }

    public static String getProperty(String beanName, Object obj, String property) throws JspEngineException {
        String methodName = null;
        try {
            if (obj == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5579, (Object)beanName));
            }
            Class<?> cls = obj.getClass();
            Method method = null;
            try {
                methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
                method = cls.getMethod(methodName, null);
            }
            catch (NoSuchMethodException e) {
                try {
                    methodName = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
                    method = cls.getMethod(methodName, null);
                }
                catch (NoSuchMethodException e2) {
                    methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5629, (Object[])new String[]{beanName, methodName}), e);
                }
            }
            if (method == null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5628, (Object[])new String[]{beanName, methodName}));
            }
            Object result = method.invoke(obj, null);
            return JspMethodProxy.toString(result);
        }
        catch (Exception ex) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5629, (Object[])new String[]{beanName, methodName}), ex);
        }
    }

    public static String toString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static String toString(byte b) {
        return new Byte(b).toString();
    }

    public static String toString(boolean b) {
        return new Boolean(b).toString();
    }

    public static String toString(short s) {
        return new Short(s).toString();
    }

    public static String toString(int i) {
        return new Integer(i).toString();
    }

    public static String toString(float f) {
        return new Float(f).toString();
    }

    public static String toString(long l) {
        return new Long(l).toString();
    }

    public static String toString(double d) {
        return new Double(d).toString();
    }

    public static String toString(char c) {
        return new Character(c).toString();
    }
}

