/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class CommentParser
extends Parser {
    private static final String OPEN_COMMENT = "<%--";
    private static final String CLOSE_COMMENT = "--%>";
    private static final String XML_OPEN_COMMENT = "<!--";
    private static final String XML_CLOSE_COMMENT = "-->";

    CommentParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        String close;
        String open;
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (xmlViewer == null) {
            open = XML_OPEN_COMMENT;
            close = XML_CLOSE_COMMENT;
        } else {
            open = OPEN_COMMENT;
            close = CLOSE_COMMENT;
        }
        if (reader.matches(open)) {
            reader.advance(open.length());
            Mark start = reader.mark();
            Mark stop = reader.skipUntil(close);
            if (stop == null) {
                if (!isJspDocument) {
                    reader.reset(start);
                    stop = reader.skipUntil(XML_CLOSE_COMMENT);
                }
                if (stop == null) {
                    throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5556));
                }
            }
            parser.flushCharData(start, stop);
            return true;
        }
        return false;
    }
}

