/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class DirectiveParser
extends Parser {
    private static final String OPEN_DIRECTIVE = "<%@";
    private static final String CLOSE_DIRECTIVE = "%>";
    private static final String OPEN_DIRECTIVE_2 = "<jsp:directive.";
    private static final String CLOSE_DIRECTIVE_2 = "/>";
    static final String[] directives = new String[]{"page", "include", "taglib", "tag"};
    private static final String[] validAttributes = new String[]{"language", "extends", "implements", "import", "session", "buffer", "autoFlush", "isThreadSafe", "info", "errorPage", "errpage", "isErrorPage", "contentType", "pageEncoding", "file", "uri", "prefix", "isELIgnored", "tagdir"};

    DirectiveParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        String open = null;
        String close = null;
        if (reader.matches(OPEN_DIRECTIVE)) {
            open = OPEN_DIRECTIVE;
            close = CLOSE_DIRECTIVE;
        } else if (reader.matches(OPEN_DIRECTIVE_2)) {
            open = OPEN_DIRECTIVE_2;
            close = CLOSE_DIRECTIVE_2;
        } else {
            return false;
        }
        Mark start = reader.mark();
        reader.reset(start);
        reader.advance(open.length());
        reader.skipSpaces();
        String match = null;
        for (int i = 0; i < directives.length; ++i) {
            if (reader.matches(directives[i])) {
                match = directives[i];
                break;
            }
            if (reader.matches("attribute")) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)"attribute"));
            }
            if (reader.matches("tag")) {
                throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)"tag"));
            }
            if (!reader.matches("variable")) continue;
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)"variable"));
        }
        if (match != null) {
            reader.advance(match.length());
        } else {
            match = "page";
        }
        Hashtable attrs = reader.parseTagAttributes2();
        JspParser.checkAttributes("Directive", attrs.keys(), validAttributes);
        reader.skipSpaces();
        if (!reader.matches(close)) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5570));
        }
        reader.advance(close.length());
        Mark stop = reader.mark();
        xmlViewer.addDirective(match, attrs);
        codeGen.handleDirective(match, start, stop, attrs);
        return true;
    }
}

