/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspbodyParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.PluginParser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class FallbackParser
extends Parser {
    static final String FALLBACK_START = "<jsp:fallback>";
    private static final String FALLBACK_END = "</jsp:fallback>";

    public FallbackParser() {
    }

    public FallbackParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public static boolean match(JspReader reader) {
        if (!reader.matches(FALLBACK_START)) {
            return false;
        }
        reader.advance(FALLBACK_START.length());
        return true;
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!FallbackParser.match(reader)) {
            return false;
        }
        if (this.isInvalidated) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)FALLBACK_START));
        }
        this.process(xmlViewer, reader, parser, codeGen, parentParser);
        return true;
    }

    private void process(JspXmlViewer xmlViewer, JspReader reader, JspParser parser, CodeGenerator codeGen, Parser _parentParser) throws JspEngineException {
        reader.skipSpaces();
        Mark fallBackStart = reader.mark();
        Mark fallBackStop = reader.skipUntil(FALLBACK_END);
        if (fallBackStop == null) {
            throw new JspParseException(fallBackStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)FALLBACK_START));
        }
        reader.reset(fallBackStart);
        reader.skipSpaces();
        parser.flushCharData();
        if (!(_parentParser instanceof PluginParser)) {
            throw new JspParseException(fallBackStart, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5678));
        }
        FallbackGenerator gen = new FallbackGenerator(fallBackStart, fallBackStop);
        JspbodyParser.parse(this, xmlViewer, reader, parser, codeGen, gen, "jsp:fallback", null, null, false);
        reader.skipSpaces();
        parser.flushCharData();
        codeGen.addGenerator(gen, "ServiceMethodPhase");
    }

    static class FallbackGenerator
    extends Generator {
        FallbackGenerator(Mark start, Mark stop) {
            this.start = start;
            this.stop = stop;
        }

        public boolean generate(ServletWriter out, String phase) throws JspEngineException {
            if (!this.hasChildren()) {
                return false;
            }
            Enumeration enum1 = this.children.elements();
            while (enum1.hasMoreElements()) {
                Generator gen = (Generator)enum1.nextElement();
                gen.generateCode(out, phase);
            }
            return true;
        }
    }
}

