/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;

final class HtmlCommentParser
extends Parser {
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";

    HtmlCommentParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (parser.isInHtmlScript()) {
            return false;
        }
        if (!reader.matches(COMMENT_START)) {
            return false;
        }
        Mark start = null;
        Mark stop = null;
        start = reader.mark();
        int ch = 0;
        reader.advance(COMMENT_START.length());
        while (ch >= 0) {
            if (reader.matches(COMMENT_END)) {
                reader.advance(COMMENT_END.length());
                stop = reader.mark();
                break;
            }
            if (reader.matches(COMMENT_START)) {
                reader.reset(start);
                return false;
            }
            ch = reader.nextChar();
        }
        if (stop == null) {
            reader.reset(start);
            return false;
        }
        parser.flushCharData();
        char[] data = reader.getChars(start, stop);
        codeGen.handleCharData(data);
        return true;
    }
}

