/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.File;
import java.util.StringTokenizer;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.util.logging.JeusLogger;

public abstract class JavaCompiler {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    protected String errorMessage = null;
    protected String classPath;
    protected String encoding;
    protected String outDir;
    protected String source;
    protected String[] option;

    public JavaCompiler(String cp, String en, String out, String option, String src) {
        this.classPath = cp;
        this.encoding = en;
        this.outDir = out;
        this.source = src;
        this.errorMessage = null;
        this.parseOption(option);
    }

    private void parseOption(String opt) {
        this.option = new String[0];
        if (opt == null) {
            return;
        }
        if ((opt = opt.trim()).equals("")) {
            return;
        }
        StringTokenizer token = new StringTokenizer(opt);
        int count = token.countTokens();
        if (count <= 0) {
            return;
        }
        this.option = new String[count];
        int i = 0;
        while (token.hasMoreTokens()) {
            this.option[i++] = token.nextToken();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void moveClassFiles(String srcdir, String destdir, String prefix, String suffix) {
        String fs = System.getProperty("file.separator");
        File outputDir = new File(srcdir);
        String[] dirList = outputDir.list();
        if (dirList == null || dirList.length <= 0) {
            return;
        }
        boolean result = false;
        for (int i = 0; i < dirList.length; ++i) {
            if (!dirList[i].startsWith(prefix) || !dirList[i].endsWith(suffix)) continue;
            File destClassFile = new File(destdir + fs + dirList[i]);
            File srcClassFile = new File(srcdir + fs + dirList[i]);
            if (!srcClassFile.exists()) continue;
            if (destClassFile.exists()) {
                destClassFile.delete();
            }
            result = srcClassFile.renameTo(destClassFile);
        }
    }

    protected void checkOutputDirectory() {
        File file = new File(this.outDir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public abstract void compile() throws JspCompileException;
}

