/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.FragmentClassGenerator;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.TrimEnable;

public class JspAttribute
extends Attribute {
    private Generator generator;
    private String fragmentClassName;

    public JspAttribute(String attr, String varname, boolean trim, boolean jspFragment, CodeGenerator codeGen) {
        super(attr, varname, trim, jspFragment);
        if (jspFragment) {
            this.fragmentClassName = codeGen.getJspFragmentClassName();
            this.generator = new FragmentClassGenerator(this, this.fragmentClassName);
        } else {
            this.generator = new JspattributeParser.JspAttributeGenerator(this);
        }
    }

    Generator getGenerator() {
        return this.generator;
    }

    public String generate(ServletWriter out, CodeGenerator codeGen, boolean isJspDocument, String defaultNamespace, Class returnType, Class propEditor, String pageContextName, String parentTagName) throws JspEngineException {
        this.generate(out, codeGen, pageContextName, parentTagName);
        return null;
    }

    public void trim() {
        if (!this.trim) {
            return;
        }
        int size = this.generator.children.size();
        if (size == 0) {
            return;
        }
        Generator gen = (Generator)this.generator.children.get(0);
        if (gen instanceof TrimEnable) {
            ((TrimEnable)((Object)gen)).forwardTrim();
        }
        if ((gen = (Generator)this.generator.children.get(size - 1)) instanceof TrimEnable) {
            ((TrimEnable)((Object)gen)).backwardTrim();
        }
    }

    public void generate(ServletWriter out, CodeGenerator codeGen, String pageContextName, String parentTagName) throws JspEngineException {
        if (this.jspFragment) {
            out.println(this.fragmentClassName + " " + this.variableName + " = new " + this.fragmentClassName + "(" + pageContextName + ", " + parentTagName + ");");
            codeGen.addGenerator(this.generator, "SplittedServiceMethodPhase");
        } else {
            this.generator.generate(out, "ServiceMethodPhase");
        }
    }
}

