/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.jsp.JspDefaultConstants;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineContext;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.InfoGenerator;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class JspCodeGenerator
extends CodeGenerator {
    public static final String GET_JSP_SOURCE_FILES_METHOD_NAME = "__jeusGetIncludedJspFiles";
    public static final String GET_JSP2_SOURCE_FILES_METHOD_NAME = "getDependants";
    private JspEngineContext ctxt;
    private String jspServletBase = "jeus.servlet.jsp.HttpJspBase";
    private String serviceMethodName = "_jspService";
    private int bufferSize = 8192;
    private String extendsClass = "";
    private Vector interfaces = new Vector();
    private String error = "";
    private String info = "";
    private boolean singleThreaded = false;
    private boolean autoFlush = true;
    private boolean extendsDir = false;
    private boolean sessionDir = false;
    private boolean bufferDir = false;
    private boolean threadsafeDir = false;
    private boolean errorpageDir = false;
    private boolean iserrorpageDir = false;
    private boolean infoDir = false;
    private boolean autoFlushDir = false;
    private boolean contentTypeDir = false;

    public JspCodeGenerator(JspEngine engine, JspEngineContext ctxt, String encoding) {
        super(engine, ctxt.getReloader().getJspURI(), ctxt.getReader(), ctxt.getWriter());
        this.ctxt = ctxt;
        this.jspPropertyEncoding = encoding;
    }

    public void beginPageProcessing() {
        for (int i = 0; i < JspDefaultConstants.STANDARD_IMPORTS.length; ++i) {
            this.imports.addElement(JspDefaultConstants.STANDARD_IMPORTS[i]);
        }
    }

    public void endPageProcessing() throws JspEngineException {
        this.servletContentType = this.checkCharset(this.servletContentType);
        this.generateHeader();
        this.writer.println();
        this.generateAll("ServiceMethodPhase");
        this.writer.println();
        this.generateFooter();
    }

    private String checkCharset(String contentType) {
        if (contentType == null) {
            return contentType;
        }
        ContextGroup ctxgrp = ((Context)this.ctxt.getServletContext()).getVirtualHost().getContextGroup();
        String defaultenc = ctxgrp.getDefaultResponseEncoding();
        String forcedenc = ctxgrp.getForcedResponseEncoding();
        if (this.reader.isJspDocument() && contentType.equals("text/html")) {
            contentType = "text/xml";
        }
        String type = null;
        String charset = null;
        int semi = contentType.indexOf(";");
        if (semi < 0) {
            type = contentType;
            charset = null;
        } else {
            type = contentType.substring(0, semi);
            String afterSemi = contentType.substring(semi + 1);
            int charsetLocation = afterSemi.indexOf("charset=");
            if (charsetLocation < 0) {
                charset = null;
            } else {
                String afterCharset = afterSemi.substring(charsetLocation + 8);
                charset = afterCharset.trim();
            }
        }
        if (forcedenc != null) {
            charset = forcedenc;
        } else if (charset == null || charset.equals("")) {
            if (this.reader.isJspDocument()) {
                charset = "UTF-8";
            } else if (this.jspPropertyEncoding != null) {
                charset = this.jspPropertyEncoding;
            } else if (this.servletPageEncoding != null) {
                charset = this.servletPageEncoding;
            } else {
                charset = defaultenc;
                if (charset == null && WebProperties.J2EE_COMPATIBLE.value) {
                    charset = "ISO-8859-1";
                }
            }
        }
        if (charset == null) {
            return contentType;
        }
        return type + ";charset=" + charset;
    }

    private void generateHeader() throws JspEngineException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        if (!"".equals(servletPackageName) && servletPackageName != null) {
            this.writer.println("package " + servletPackageName + ";");
            this.writer.println();
        }
        if (!this.extendsClass.equals("") && this.extendsClass.indexOf(".") == -1) {
            this.imports.addElement(this.extendsClass);
        }
        Enumeration e2 = this.interfaces.elements();
        while (e2.hasMoreElements()) {
            String inf = (String)e2.nextElement();
            if (inf.equals("") || inf.indexOf(".") != -1) continue;
            this.imports.addElement(inf);
        }
        Enumeration e = this.imports.elements();
        Hashtable<String, Boolean> dup = new Hashtable<String, Boolean>();
        while (e.hasMoreElements()) {
            String imp = (String)e.nextElement();
            if (dup.get(imp) != null) continue;
            dup.put(imp, new Boolean(true));
            this.writer.println("import " + imp + ";");
        }
        this.writer.println();
        this.writer.println();
        this.writer.print("public class " + servletClassName + " extends ");
        this.writer.print(this.extendsClass.equals("") ? this.jspServletBase : this.extendsClass);
        if (this.singleThreaded) {
            this.interfaces.addElement("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.print("     implements ");
            dup = new Hashtable();
            e2 = this.interfaces.elements();
            boolean first = true;
            while (e2.hasMoreElements()) {
                String inf = (String)e2.nextElement();
                if (dup.get(inf) != null) continue;
                dup.put(inf, new Boolean(true));
                if (first) {
                    first = false;
                    this.writer.print(" " + inf);
                    continue;
                }
                this.writer.print(", " + inf);
            }
            this.writer.println();
        }
        this.writer.println(" {");
        this.writer.pushIndent();
        this.writer.println();
        this.generateJeusSpecificMethod();
        this.generateAll("ClassDeclarationPhase");
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws ServletException, IOException {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("JspFactory\t_jspxFactory = null;");
        this.writer.println("PageContext\tpageContext = null;");
        if (this.genSessionVariable) {
            this.writer.println("HttpSession\tsession = null;");
        }
        if (this.ctxt.isErrorPage()) {
            this.writer.println("Throwable\texception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.writer.println("ServletContext\tapplication = null;");
        this.writer.println("ServletConfig\tconfig = null;");
        this.writer.println("JspWriter\tout = null;");
        this.writer.println("Object\t\tpage = this;");
        this.writer.println("String\t\t_value = null;");
        this.writer.println();
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println("_jspxFactory = JspFactory.getDefaultFactory();");
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response, " + ServletWriter.quoteString(this.error) + ", " + this.genSessionVariable + ", " + this.bufferSize + ", " + this.autoFlush + ");");
        if (this.genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        this.writer.println("out = pageContext.getOut();");
        this.writer.println();
        this.writer.println("response.setContentType(" + ServletWriter.quoteString(this.servletContentType) + ");");
    }

    private void generateJeusSpecificMethod() {
        Vector sourceFiles = this.reader.getSourceFiles();
        this.writer.println("public final String[] __jeusGetIncludedJspFiles() {");
        this.writer.pushIndent();
        if (sourceFiles == null || sourceFiles.size() <= 1) {
            this.writer.println("return null;");
        } else {
            this.writer.println("return new String[] {");
            this.writer.pushIndent();
            int i = 0;
            if (sourceFiles.size() == 2) {
                String src = (String)sourceFiles.elementAt(1);
                src = src.replace(File.separatorChar, '/');
                this.writer.println("\"" + src + "\"");
            } else {
                String src = null;
                for (i = 1; i < sourceFiles.size() - 1; ++i) {
                    src = (String)sourceFiles.elementAt(i);
                    src = src.replace(File.separatorChar, '/');
                    this.writer.println("\"" + src + "\",");
                }
                src = (String)sourceFiles.elementAt(i);
                src = src.replace(File.separatorChar, '/');
                this.writer.println("\"" + src + "\"");
            }
            this.writer.popIndent();
            this.writer.println("};");
        }
        this.writer.popIndent();
        this.writer.println("}");
    }

    private void generateFooter() throws JspEngineException {
        this.writer.popIndent();
        this.writer.println("} catch (Throwable t) {");
        this.writer.pushIndent();
        this.writer.println("if (!(t instanceof SkipPageException)) {");
        this.writer.pushIndent();
        this.writer.println("if (out.getBufferSize() != 0) {");
        this.writer.pushIndent();
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println("out.clear();");
        this.writer.popIndent();
        this.writer.println("} catch (Exception _exc) { }");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("pageContext.handlePageException(t);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("} finally {");
        this.writer.pushIndent();
        this.writer.println("_jspxFactory.releasePageContext(pageContext);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.generateSplittedFunctions();
        this.generateStaticFields();
        this.generateAll("TemplateStringDeclarationPhase");
        this.writer.popIndent();
        this.writer.println("}");
    }

    public void handleDirective(String directive, Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        if (directive.equals("page")) {
            this.handlePageDirective(start, stop, attrs);
        }
        if (directive.equals("taglib")) {
            this.handleTaglibDirective(start, stop, attrs);
        }
        if (directive.equals("include")) {
            this.handleIncludeDirective(start, stop, attrs);
        }
    }

    private void handlePageDirective(Mark start, Mark stop, Hashtable attrs) throws JspEngineException {
        this.parser.flushCharData();
        Enumeration e = attrs.keys();
        while (e.hasMoreElements()) {
            Vector value;
            String attr = (String)e.nextElement();
            if (attr.equalsIgnoreCase("language")) {
                value = (Vector)attrs.get(attr);
                this.languageHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("extends")) {
                value = (Vector)attrs.get(attr);
                this.extendsHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("import")) {
                value = (Vector)attrs.get(attr);
                this.importHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("implements")) {
                value = (Vector)attrs.get(attr);
                this.implementsHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("session")) {
                value = (Vector)attrs.get(attr);
                this.sessionHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("buffer")) {
                value = (Vector)attrs.get(attr);
                this.bufferHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("autoFlush")) {
                value = (Vector)attrs.get(attr);
                this.autoFlushHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("isThreadSafe")) {
                value = (Vector)attrs.get(attr);
                this.isThreadSafeHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("info")) {
                value = (Vector)attrs.get(attr);
                this.infoHandler(value, start, stop);
                continue;
            }
            if (attr.equalsIgnoreCase("errorPage")) {
                value = (Vector)attrs.get(attr);
                this.errorPageHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("errpage")) {
                value = (Vector)attrs.get(attr);
                this.errorPageHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("contentType")) {
                value = (Vector)attrs.get(attr);
                this.contentTypeHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("pageEncoding")) {
                value = (Vector)attrs.get(attr);
                Object _contentType = attrs.get("contentType");
                this.pageEncodingHandler(value);
                continue;
            }
            if (attr.equalsIgnoreCase("isErrorPage")) {
                value = (Vector)attrs.get(attr);
                this.isErrorPageHandler(value);
                continue;
            }
            if (!attr.equalsIgnoreCase("isELIgnored")) continue;
            value = (Vector)attrs.get(attr);
            this.isELIgnoredHandler(value);
        }
        if (this.bufferSize == 0 && !this.autoFlush) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5527));
        }
    }

    private boolean hasCharset(Vector vector) {
        Enumeration enum1 = vector.elements();
        while (enum1.hasMoreElements()) {
            String o = (String)enum1.nextElement();
            if (o == null || o.indexOf("charset=") < 0) continue;
            return true;
        }
        return false;
    }

    private void extendsHandler(Vector extendsClasses) throws JspEngineException {
        if (extendsClasses == null) {
            return;
        }
        Enumeration enum1 = extendsClasses.elements();
        while (enum1.hasMoreElements()) {
            String value = (String)enum1.nextElement();
            if (value == null) continue;
            if (!this.extendsDir) {
                this.extendsDir = true;
                this.extendsClass = value;
                continue;
            }
            if (!WebProperties.J2EE_COMPATIBLE.value) continue;
            if (!value.equals(this.extendsClass)) {
                throw new JspEngineException("different value of extends attribute not allowed");
            }
            this.extendsClass = value;
        }
    }

    private void implementsHandler(Vector implementsClasses) {
        if (implementsClasses != null) {
            int size = implementsClasses.size();
            for (int i = 0; i < size; ++i) {
                StringTokenizer tokenizer = new StringTokenizer((String)implementsClasses.get(i), " ,;\n\t\r");
                while (tokenizer.hasMoreTokens()) {
                    String implementsStr = tokenizer.nextToken();
                    if (implementsStr.equals("implements")) continue;
                    this.interfaces.addElement(implementsStr);
                }
            }
        }
    }

    private void sessionHandler(Vector sessions) throws JspEngineException {
        if (sessions == null) {
            return;
        }
        Enumeration enum1 = sessions.elements();
        while (enum1.hasMoreElements()) {
            String session = (String)enum1.nextElement();
            boolean cur = false;
            if (session.equalsIgnoreCase("true")) {
                cur = true;
            } else if (session.equalsIgnoreCase("false")) {
                cur = false;
            } else {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5536, (Object)session));
            }
            if (!this.sessionDir) {
                this.sessionDir = true;
                this.genSessionVariable = cur;
                continue;
            }
            if (WebProperties.J2EE_COMPATIBLE.value) {
                if (this.genSessionVariable == cur) continue;
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5382));
            }
            this.genSessionVariable = cur;
        }
    }

    private void bufferHandler(Vector buffers) throws JspEngineException {
        if (buffers == null) {
            return;
        }
        Enumeration enum1 = buffers.elements();
        while (enum1.hasMoreElements()) {
            String buffer = (String)enum1.nextElement();
            int cur = -1;
            if (buffer.equalsIgnoreCase("none")) {
                cur = 0;
            } else {
                Integer i = null;
                try {
                    int ind = buffer.indexOf("k");
                    String num = ind == -1 ? buffer : buffer.substring(0, ind);
                    i = new Integer(num);
                }
                catch (NumberFormatException n) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5538, (Object)buffer));
                }
                cur = i * 1024;
            }
            if (!this.bufferDir) {
                this.bufferDir = true;
                this.bufferSize = cur;
                continue;
            }
            if (WebProperties.J2EE_COMPATIBLE.value) {
                if (cur == this.bufferSize) continue;
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5383));
            }
            this.bufferSize = cur;
        }
    }

    private void autoFlushHandler(Vector autoflushs) throws JspEngineException {
        if (autoflushs == null) {
            return;
        }
        Enumeration enum1 = autoflushs.elements();
        while (enum1.hasMoreElements()) {
            String value = (String)enum1.nextElement();
            boolean cur = false;
            if (value.equalsIgnoreCase("true")) {
                cur = true;
            } else if (value.equalsIgnoreCase("false")) {
                cur = false;
            } else {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5542, (Object)value));
            }
            if (!this.autoFlushDir) {
                this.autoFlushDir = true;
                this.autoFlush = cur;
                continue;
            }
            if (WebProperties.J2EE_COMPATIBLE.value) {
                if (cur == this.autoFlush) continue;
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5384));
            }
            this.autoFlush = cur;
        }
    }

    private void isThreadSafeHandler(Vector threadsafes) throws JspEngineException {
        if (threadsafes == null) {
            return;
        }
        Enumeration enum1 = threadsafes.elements();
        while (enum1.hasMoreElements()) {
            String threadsafe = (String)enum1.nextElement();
            if (threadsafe == null) continue;
            boolean cur = false;
            if (threadsafe.equalsIgnoreCase("true")) {
                cur = false;
            } else if (threadsafe.equalsIgnoreCase("false")) {
                cur = true;
            } else {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5545, (Object)threadsafe));
            }
            if (!this.threadsafeDir) {
                this.threadsafeDir = true;
                this.singleThreaded = cur;
                continue;
            }
            if (WebProperties.J2EE_COMPATIBLE.value) {
                if (cur == this.singleThreaded) continue;
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5385));
            }
            this.singleThreaded = cur;
        }
    }

    private void infoHandler(Vector infos, Mark start, Mark stop) throws JspEngineException {
        if (infos == null) {
            return;
        }
        Enumeration enum1 = infos.elements();
        while (enum1.hasMoreElements()) {
            String value = (String)enum1.nextElement();
            if (value == null) continue;
            if (!this.infoDir) {
                this.infoDir = true;
                this.info = value;
                InfoGenerator gen = new InfoGenerator(this.info, start, stop);
                this.addGenerator(gen, "ClassDeclarationPhase");
                continue;
            }
            if (!WebProperties.J2EE_COMPATIBLE.value || value.equals(this.info)) continue;
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5386));
        }
    }

    private void errorPageHandler(Vector errorpages) throws JspEngineException {
        if (errorpages == null) {
            return;
        }
        Enumeration enum1 = errorpages.elements();
        while (enum1.hasMoreElements()) {
            String value = (String)enum1.nextElement();
            if (value == null) continue;
            if (!this.errorpageDir) {
                this.errorpageDir = true;
                this.error = value;
                continue;
            }
            if (WebProperties.J2EE_COMPATIBLE.value) {
                if (value.equals(this.error)) continue;
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5548));
            }
            this.error = value;
        }
    }

    private void contentTypeHandler(Vector contentTypes) throws JspEngineException {
        if (contentTypes == null) {
            return;
        }
        if (this.contentTypeDir) {
            if (!WebProperties.J2EE_COMPATIBLE.value) {
                return;
            }
            boolean _keepGoing = false;
            if (contentTypes != null && contentTypes.size() > 0) {
                String _contentTypeNew = (String)contentTypes.elementAt(0);
                if (this.servletContentType != null && _contentTypeNew != null && this.servletContentType.equalsIgnoreCase(_contentTypeNew)) {
                    _keepGoing = true;
                }
            }
            if (!_keepGoing) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5549));
            }
        }
        if (contentTypes.size() > 1 && WebProperties.J2EE_COMPATIBLE.value) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5549));
        }
        this.contentTypeDir = true;
        String contentType = (String)contentTypes.elementAt(0);
        if (contentType == null) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5550));
        }
        this.servletContentType = contentType;
    }

    private void isErrorPageHandler(Vector iserrorpages) throws JspEngineException {
        if (iserrorpages == null) {
            return;
        }
        Enumeration enum1 = iserrorpages.elements();
        while (enum1.hasMoreElements()) {
            String iserrorpage = (String)enum1.nextElement();
            if (iserrorpage == null) continue;
            boolean cur = false;
            if (iserrorpage.equalsIgnoreCase("true")) {
                cur = true;
            } else if (iserrorpage.equalsIgnoreCase("false")) {
                cur = false;
            } else {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5553, (Object)iserrorpage));
            }
            if (!this.iserrorpageDir) {
                this.iserrorpageDir = true;
                this.ctxt.setErrorPage(cur);
                continue;
            }
            if (WebProperties.J2EE_COMPATIBLE.value) {
                if (this.ctxt.isErrorPage() == cur) continue;
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5387));
            }
            this.ctxt.setErrorPage(cur);
        }
    }

    public JspEngineContext getCtxt() {
        return this.ctxt;
    }
}

