/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletContext;
import jeus.apache.xerces.parsers.DOMParser;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.RequestUtil;
import jeus.servlet.jsp.DummyOutputStream;
import jeus.servlet.jsp.JspEngine;
import jeus.servlet.jsp.JspEngineContext;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.JspCodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.TagFileInfoImpl;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;
import jeus.xml.util.DomProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class JspReader {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    protected char[] stream = null;
    protected Mark current = null;
    protected boolean jspDocument;
    String master = null;
    Vector sourceFiles = new Vector();
    Stack includeStack;
    int size = 0;
    private String jspPropertyEncoding = null;
    private String finalEncoding = null;
    private ServletContext context;
    private JspParser parser;
    private Element documentElement;
    private Document document;
    private File currentFile;
    private JspEngine jspEngine;
    public boolean isTemp = false;

    public JspReader(ServletContext ctx, JspEngine jspEngine, String encoding) {
        this.context = ctx;
        this.jspEngine = jspEngine;
        this.jspPropertyEncoding = encoding;
    }

    public JspReader(ServletContext ctx, JspEngine jspEngine, String encoding, boolean staticEncoding) {
        this.context = ctx;
        this.jspEngine = jspEngine;
        if (staticEncoding) {
            this.finalEncoding = encoding;
        }
    }

    public void startsWith(JspParser parser, String file, String encoding) throws JspEngineException, FileNotFoundException {
        this.parser = parser;
        this.pushFile(file, false, encoding);
    }

    public void startsWith(JspParser parser, String file, boolean included, String encoding) throws JspEngineException, FileNotFoundException {
        this.parser = parser;
        this.pushFile(file, included, encoding);
    }

    public void startsWith(JspParser parser, TagFileInfoImpl tfi) throws JspEngineException, FileNotFoundException {
        this.parser = parser;
        this.pushInputStream(tfi.getInputStream(), tfi.getPathInfo());
    }

    boolean isJspDocument() {
        return this.jspDocument;
    }

    String getFile(int fileid) {
        return (String)this.sourceFiles.elementAt(fileid);
    }

    public final Vector getSourceFiles() {
        return this.sourceFiles;
    }

    protected int registerSourceFile(String file) {
        int ind;
        if (file != null && (ind = file.indexOf(":\\")) >= 0) {
            file = file.substring(ind + 1);
        }
        this.sourceFiles.addElement(file);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    public void pushFile(String name, boolean included, String encoding) throws JspEngineException, FileNotFoundException {
        name = JspUtil.trimTrailingSpace(name);
        String ps = System.getProperty("file.separator");
        String parent = this.master == null ? null : this.master.substring(0, this.master.lastIndexOf("/") + 1);
        boolean isAbsolute = name.startsWith("/");
        String cwd = null;
        if (this.current != null) {
            cwd = this.current.getFile();
            cwd = cwd.substring(0, cwd.lastIndexOf(ps) + 1);
        }
        if (cwd == null || isAbsolute) {
            this.pushFile(new File(RequestUtil.removeDotDot(name)), included, encoding);
        } else {
            try {
                this.pushFile(new File(RequestUtil.removeDotDot((cwd == null ? "" : cwd) + name)), included, encoding);
            }
            catch (FileNotFoundException fnfe) {
                int size = this.sourceFiles.size();
                if (size > 0) {
                    this.sourceFiles.remove(size - 1);
                }
                try {
                    this.pushFile(new File(RequestUtil.removeDotDot((parent == null ? "" : parent) + name)), included, encoding);
                }
                catch (FileNotFoundException fnfe2) {
                    throw fnfe;
                }
            }
        }
        if (this.master == null) {
            this.master = name;
        }
    }

    private void pushInputStream(InputStream in, String fileInfo) throws JspEngineException {
        String encoding = "8859_1";
        int fileid = this.registerSourceFile(fileInfo);
        Reader reader = null;
        boolean noretry = false;
        CharArrayWriter caw = null;
        try {
            while (true) {
                int bufSize = 1024;
                if (in == null) {
                    throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5391, (Object)fileInfo));
                }
                bufSize += in.available();
                try {
                    reader = new InputStreamReader(in, encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    if (WebProperties.J2EE_COMPATIBLE.value) {
                        throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5392, (Object)encoding));
                    }
                    String encoding2 = System.getProperty("file.encoding", "8859_1");
                    reader = new InputStreamReader(in, encoding2);
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5627_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5627_LEVEL, JeusMessage_WebContainer5_4._5627, (Object[])new String[]{fileInfo, encoding, encoding2});
                    }
                    noretry = true;
                }
                catch (Exception ex) {
                    throw new FileNotFoundException(fileInfo + ": " + ex.getMessage());
                }
                caw = new CharArrayWriter();
                char[] buf = new char[bufSize];
                try {
                    int i = 0;
                    while ((i = reader.read(buf)) != -1) {
                        caw.write(buf, 0, i);
                    }
                    caw.close();
                }
                catch (Exception e) {
                    if (noretry) {
                        throw e;
                    }
                    String encoding2 = System.getProperty("file.encoding", "8859_1");
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5627_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5627_LEVEL, JeusMessage_WebContainer5_4._5627, (Object[])new String[]{fileInfo, encoding, encoding2});
                    }
                    encoding = encoding2;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception any) {
                            // empty catch block
                        }
                    }
                    if (caw != null) {
                        try {
                            caw.close();
                        }
                        catch (Exception any) {
                            // empty catch block
                        }
                    }
                    noretry = true;
                    continue;
                }
                break;
            }
            IncludeState state = new IncludeState();
            this.stream = caw.toCharArray();
            this.current = new Mark(this, fileid);
            this.jspDocument = this.parser.isJspDocument();
            if (this.includeStack == null) {
                this.includeStack = new Stack();
            } else {
                this.includeStack.push(state);
            }
        }
        catch (Throwable ex) {
            System.err.println("STACK TRACE: ");
            ex.printStackTrace();
            this.popFile();
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5588, (Object)fileInfo));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception any) {}
            }
        }
    }

    Element getDocumentElement() throws SAXException {
        if (this.documentElement != null) {
            return this.documentElement;
        }
        int _current = this.current.cursor;
        CharArrayReader careader = null;
        careader = _current > 0 ? new CharArrayReader(this.stream, _current, this.stream.length - _current) : new CharArrayReader(this.stream);
        InputSource inputSrc = new InputSource(careader);
        DOMParser domParser = new DOMParser();
        try {
            try {
                domParser.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            try {
                domParser.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            domParser.parse(inputSrc);
            Document doc = domParser.getDocument();
            this.documentElement = doc.getDocumentElement();
            return this.documentElement;
        }
        catch (SAXParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    String getXmlEncoding() {
        if (this.document == null) {
            return null;
        }
        return this.document.getXmlEncoding();
    }

    Element getDocumentElement2() throws SAXException {
        if (this.documentElement != null) {
            return this.documentElement;
        }
        try {
            InputStream fis;
            String fileName = this.currentFile.toString();
            if (System.getProperty("file.separator").equals("\\")) {
                fileName = fileName.replace('\\', '/');
            }
            if ((fis = this.context.getResourceAsStream(fileName)) == null) {
                throw new FileNotFoundException(fileName);
            }
            this.document = DomProcessor.parse(fis);
            this.documentElement = this.document.getDocumentElement();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DomProcessor.serialize(this.document, output);
            char[] data = output.toString().toCharArray();
            this.stream = data;
            this.current = new Mark(this, this.sourceFiles.size() - 1);
            return this.documentElement;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void pushFile(File file, boolean included, String parentEncoding) throws JspEngineException, FileNotFoundException {
        String encoding;
        JspEngineContext ctxt = this.parser.getCodeGen().getCtxt();
        String initialEncoding = "8859_1";
        String contentType = null;
        if (this.finalEncoding == null) {
            int loc;
            try {
                FileInputStream fis = new FileInputStream(((Context)this.context).getCtxDocBase().toString().substring(5) + file.getPath());
                byte[] seq = new byte[4];
                try {
                    fis.read(seq, 0, 4);
                }
                catch (IOException e) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object[])new Object[]{this.finalEncoding, this.jspPropertyEncoding}));
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
                initialEncoding = seq[0] == 60 && seq[1] == 63 && seq[2] == 120 && seq[3] == 109 ? "8859_1" : (seq[0] == 76 && seq[1] == 111 ? "Cp933" : (seq[0] == 0 && seq[1] == 0 && seq[2] == 0 && seq[3] == 60 ? "UCS-4" : (seq[0] == 60 && seq[1] == 0 && seq[2] == 0 && seq[3] == 0 ? "UCS-4" : (seq[0] == 0 && seq[1] == 0 && seq[2] == 60 && seq[3] == 0 ? "UCS-4" : (seq[0] == 0 && seq[1] == 60 && seq[2] == 0 && seq[3] == 0 ? "UCS-4" : (seq[0] == -17 && seq[1] == -69 && seq[2] == -65 ? "UTF-8" : (seq[0] == -2 && seq[1] == -1 ? "UTF-16" : (seq[0] == -1 && seq[1] == -2 ? "UTF-16" : (seq[0] == 0 && seq[1] == 60 && seq[2] == 0 && seq[3] == 63 ? "UTF-16" : (seq[0] == 60 && seq[1] == 0 && seq[2] == 63 && seq[3] == 0 ? "UTF-16LE" : "8859_1"))))))))));
            }
            catch (FileNotFoundException e) {
                initialEncoding = "8859_1";
            }
            encoding = initialEncoding;
            JspReader tempReader = new JspReader(ctxt.getServletContext(), this.jspEngine, encoding, true);
            tempReader.isTemp = true;
            DummyOutputStream os = new DummyOutputStream();
            ServletWriter writer = new ServletWriter(new PrintWriter(new OutputStreamWriter(os)));
            ctxt.setReader(tempReader);
            ctxt.setWriter(writer);
            JspCodeGenerator codeGen = new JspCodeGenerator(this.jspEngine, ctxt, null);
            JspParser parser = new JspParser(tempReader, codeGen, true);
            tempReader.startsWith(parser, file.getPath(), included, parentEncoding);
            try {
                codeGen.beginPageProcessing();
                parser.parse();
                codeGen.endPageProcessing();
            }
            catch (Exception e) {
                // empty catch block
            }
            String[] result = new String[2];
            String jspContentType = codeGen.getContentType();
            String jspPageEncoding = codeGen.getPageEncoding();
            if (jspContentType != null && (loc = jspContentType.indexOf("charset=")) != -1) {
                result[1] = jspContentType.substring(loc + 8);
            }
            if (!parser.isJspDocument) {
                result[0] = this.jspPropertyEncoding;
                if (jspPageEncoding != null) {
                    if (result[0] != null) {
                        if (!result[0].equals(jspPageEncoding)) {
                            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object[])new Object[]{jspPageEncoding, this.jspPropertyEncoding}));
                        }
                    } else {
                        result[0] = jspPageEncoding;
                    }
                }
                if (result[0] == null) {
                    result[0] = result[1];
                }
                if (result[0] == null) {
                    result[0] = included && parentEncoding != null && !WebProperties.J2EE_COMPATIBLE.value ? parentEncoding : "8859_1";
                }
            } else {
                result[0] = codeGen.pageEncodingInXml;
                if (result[0] == null) {
                    result[0] = encoding;
                }
                if (jspPageEncoding != null && this.jspPropertyEncoding != null && !jspPageEncoding.equals(this.jspPropertyEncoding)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object[])new Object[]{jspPageEncoding, this.jspPropertyEncoding}));
                }
                if (jspPageEncoding != null && codeGen.pageEncodingInXml != null && !jspPageEncoding.equals(codeGen.pageEncodingInXml)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object[])new Object[]{jspPageEncoding, this.jspPropertyEncoding}));
                }
                if (codeGen.pageEncodingInXml != null && this.jspPropertyEncoding != null && !this.jspPropertyEncoding.equals(codeGen.pageEncodingInXml)) {
                    throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5350, (Object[])new Object[]{jspPageEncoding, this.jspPropertyEncoding}));
                }
            }
            contentType = result[1];
            this.finalEncoding = result[0];
        }
        encoding = this.finalEncoding;
        if (!included) {
            this.parser.getCodeGen().setEncoding(encoding, contentType);
        }
        this.currentFile = file;
        int fileid = this.registerSourceFile(file.getAbsolutePath());
        Reader reader = null;
        InputStream in = null;
        boolean noretry = false;
        CharArrayWriter caw = null;
        try {
            while (true) {
                int bufSize = 1024;
                if (this.context == null) {
                    in = new FileInputStream(file);
                    try {
                        reader = new InputStreamReader(in, encoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        String encoding2 = System.getProperty("file.encoding", "8859_1");
                        reader = new InputStreamReader(in, encoding2);
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5627_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5627_LEVEL, JeusMessage_WebContainer5_4._5627, (Object[])new String[]{file.toString(), encoding, encoding2});
                        }
                        noretry = true;
                    }
                    catch (Exception ex) {
                        throw new FileNotFoundException(file.toString() + ": " + ex.getMessage());
                    }
                    bufSize += (int)file.length();
                } else {
                    String fileName = file.toString();
                    if (System.getProperty("file.separator").equals("\\")) {
                        fileName = fileName.replace('\\', '/');
                    }
                    if (!fileName.startsWith("/")) {
                        fileName = "/" + fileName;
                    }
                    if ((in = this.context.getResourceAsStream(fileName)) == null) {
                        throw new FileNotFoundException(fileName);
                    }
                    bufSize += in.available();
                    try {
                        reader = new InputStreamReader(in, encoding);
                    }
                    catch (UnsupportedEncodingException uee) {
                        if (WebProperties.J2EE_COMPATIBLE.value) {
                            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5392, (Object)encoding));
                        }
                        String encoding2 = System.getProperty("file.encoding", "8859_1");
                        reader = new InputStreamReader(in, encoding2);
                        if (logger.isLoggable(JeusMessage_WebContainer5_4._5627_LEVEL)) {
                            logger.log(JeusMessage_WebContainer5_4._5627_LEVEL, JeusMessage_WebContainer5_4._5627, (Object[])new String[]{file.toString(), encoding, encoding2});
                        }
                        noretry = true;
                    }
                    catch (Exception ex) {
                        throw new FileNotFoundException(fileName + ": " + ex.getMessage());
                    }
                }
                caw = new CharArrayWriter();
                char[] buf = new char[bufSize];
                try {
                    int i = 0;
                    while ((i = reader.read(buf)) != -1) {
                        caw.write(buf, 0, i);
                    }
                    caw.close();
                }
                catch (Exception e) {
                    if (noretry) {
                        throw e;
                    }
                    String encoding2 = System.getProperty("file.encoding", "8859_1");
                    if (logger.isLoggable(JeusMessage_WebContainer5_4._5627_LEVEL)) {
                        logger.log(JeusMessage_WebContainer5_4._5627_LEVEL, JeusMessage_WebContainer5_4._5627, (Object[])new String[]{file.toString(), encoding, encoding2});
                    }
                    encoding = encoding2;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception any) {
                            // empty catch block
                        }
                    }
                    if (caw != null) {
                        try {
                            caw.close();
                        }
                        catch (Exception any) {
                            // empty catch block
                        }
                    }
                    noretry = true;
                    continue;
                }
                break;
            }
            IncludeState state = new IncludeState();
            this.stream = caw.toCharArray();
            this.current = new Mark(this, fileid);
            this.jspDocument = this.parser.isJspDocument();
            if (this.includeStack == null) {
                this.includeStack = new Stack();
            } else {
                this.includeStack.push(state);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (Throwable ex) {
            System.err.println("STACK TRACE: ");
            ex.printStackTrace();
            this.popFile();
            if (ex instanceof JspEngineException) {
                throw (JspEngineException)((Object)ex);
            }
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5588, (Object)file.toString()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception any) {}
            }
        }
        this.finalEncoding = null;
    }

    public boolean popFile() {
        if (this.includeStack == null) {
            return false;
        }
        if (this.includeStack.size() == 0) {
            return false;
        }
        --this.size;
        IncludeState state = (IncludeState)this.includeStack.pop();
        state.restore();
        return true;
    }

    public boolean hasMoreInput() {
        return this.current.cursor < this.stream.length;
    }

    public int nextChar() {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char ch = this.stream[this.current.cursor];
        ++this.current.cursor;
        if (ch == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return ch;
    }

    String nextContent() {
        int ch;
        int cur_cursor = this.current.cursor;
        int len = this.stream.length;
        int before = 0;
        if (this.peekChar() == 10) {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        while (++this.current.cursor < len && (ch = this.stream[this.current.cursor]) != 60 && (ch != 36 || before == 92)) {
            if (ch == 10) {
                ++this.current.line;
                this.current.col = 0;
            } else {
                ++this.current.col;
            }
            before = ch;
        }
        return new String(this.stream, cur_cursor, this.current.cursor - cur_cursor);
    }

    char[] getChars(Mark start, Mark stop) {
        Mark oldstart = this.mark();
        this.reset(start);
        CharArrayWriter caw = new CharArrayWriter();
        while (!stop.equals(this.mark())) {
            caw.write(this.nextChar());
        }
        caw.close();
        this.reset(oldstart);
        return caw.toCharArray();
    }

    public int peekChar() {
        return this.stream[this.current.cursor];
    }

    public Mark mark() {
        return new Mark(this.current);
    }

    public void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    public boolean matchesIgnoreCase(String string) {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        while (i < string.length()) {
            ch = this.nextChar();
            if (Character.toLowerCase((char)ch) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        }
        this.reset(mark);
        return true;
    }

    public boolean matches(String string) {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        while (i < string.length()) {
            ch = this.nextChar();
            if ((char)ch == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        }
        this.reset(mark);
        return true;
    }

    public void advance(int n) {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public int skipSpaces() {
        int i = 0;
        while (this.current.cursor < this.stream.length && this.isSpace()) {
            ++i;
            this.nextChar();
        }
        return i;
    }

    public String printRemaining() {
        if (this.current.cursor >= this.stream.length) {
            return null;
        }
        return new String(this.stream, this.current.cursor, this.stream.length - this.current.cursor);
    }

    public Mark skipUntil(String limit) {
        Mark ret = null;
        int limlen = limit.length();
        ret = this.mark();
        int ch = this.nextChar();
        while (ch != -1) {
            block3: {
                if (ch == limit.charAt(0)) {
                    Mark m = this.mark();
                    for (int i = 1; i < limlen; ++i) {
                        if (Character.toLowerCase((char)this.nextChar()) == limit.charAt(i)) continue;
                        this.reset(m);
                        break block3;
                    }
                    return ret;
                }
            }
            ret = this.mark();
            ch = this.nextChar();
        }
        return null;
    }

    public final boolean isSpace() {
        return this.peekChar() <= 32 || this.peekChar() == 65279;
    }

    public String parseTagName() throws JspParseException {
        return this.parseToken(false, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String parseToken(boolean quoted, boolean processComment) throws JspParseException {
        int ch;
        StringBuffer stringBuffer;
        block12: {
            block11: {
                stringBuffer = new StringBuffer();
                this.skipSpaces();
                stringBuffer.setLength(0);
                ch = this.peekChar();
                if (quoted) break block11;
                if (!this.isDelimiter()) {
                    do {
                        if ((ch = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                            ch = this.nextChar();
                        }
                        stringBuffer.append((char)ch);
                    } while (!this.isDelimiter());
                    return stringBuffer.toString();
                }
                break block12;
            }
            if (ch != 34 && ch != 39) {
                if (!WebProperties.J2EE_COMPATIBLE.value) return stringBuffer.toString();
                throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5590));
            }
            int endQuote = ch == 34 ? 34 : 39;
            ch = this.nextChar();
            ch = this.nextChar();
            while (true) {
                block16: {
                    block14: {
                        block15: {
                            block13: {
                                if (ch == -1 || ch == endQuote) break block13;
                                if (ch == 92) {
                                    ch = this.nextChar();
                                }
                                if (ch != 60) break block14;
                                stringBuffer.append((char)ch);
                                ch = this.nextChar();
                                if (ch == 34) break block13;
                                if (ch == 37) break block15;
                                stringBuffer.append((char)ch);
                                break block16;
                            }
                            if (ch != -1) return stringBuffer.toString();
                            throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5589));
                        }
                        do {
                            stringBuffer.append((char)ch);
                            ch = this.nextChar();
                            while (ch != -1 && ch != 37) {
                                if (ch == 92) {
                                    ch = this.nextChar();
                                }
                                stringBuffer.append((char)ch);
                                ch = this.nextChar();
                            }
                            stringBuffer.append((char)ch);
                        } while ((ch = this.nextChar()) != 62);
                    }
                    stringBuffer.append((char)ch);
                }
                ch = this.nextChar();
            }
        }
        if (!processComment) return stringBuffer.toString();
        if (!this.matches("//")) return stringBuffer.toString();
        do {
            if (this.matches("%>")) return null;
            if (this.matches(">")) {
                return null;
            }
            ch = this.nextChar();
            if (ch != 92 || this.peekChar() != 62 && this.peekChar() != 37) continue;
            ch = this.nextChar();
        } while (ch != -1);
        throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5592));
    }

    private void parseAttributeValue(Hashtable into, boolean nameIgnoreCase) throws JspParseException {
        this.parseAttributeValue(into, nameIgnoreCase, false);
    }

    private void parseAttributeValue(Hashtable into, boolean nameIgnoreCase, boolean valueTrim) throws JspParseException {
        this.skipSpaces();
        String name = this.parseToken(false, true);
        if (name == null) {
            return;
        }
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5591, (Object)name));
        }
        this.nextChar();
        this.skipSpaces();
        String value = this.parseToken(true, true);
        this.skipSpaces();
        if (nameIgnoreCase) {
            into.put(name.toLowerCase(), valueTrim ? value.trim() : value);
        } else {
            into.put(name, valueTrim ? value.trim() : value);
        }
    }

    private void parseAttributeValue2(Hashtable into) throws JspParseException {
        this.skipSpaces();
        String name = this.parseToken(false, true);
        if (name == null) {
            return;
        }
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5591, (Object)name));
        }
        this.nextChar();
        this.skipSpaces();
        String value = this.parseToken(true, true);
        this.skipSpaces();
        Vector<String> values = (Vector<String>)into.get(name);
        if (values == null) {
            values = new Vector<String>();
        }
        values.add(value);
        into.put(name, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable parseTagAttributesBean() throws JspParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            this.skipSpaces();
            int ch = this.peekChar();
            if (ch == 62) {
                return values;
            }
            if (ch == 47) {
                Mark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable = values;
                        return hashtable;
                    }
                }
                finally {
                    this.reset(mark);
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values, false, true);
        }
        throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5592));
    }

    public Hashtable parseTagAttributes() throws JspParseException {
        return this.parseTagAttributes(false);
    }

    public Hashtable parseTagAttributesInXmlDeclaration() throws JspParseException {
        return this.parseTagAttributesInXmlDeclaration(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable parseTagAttributesInXmlDeclaration(boolean nameIgnoreCase) throws JspParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            this.skipSpaces();
            int ch = this.peekChar();
            if (ch == 62) {
                return values;
            }
            if (ch == 63) {
                Mark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        Hashtable hashtable = values;
                        return hashtable;
                    }
                }
                finally {
                    this.reset(mark);
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values, nameIgnoreCase);
        }
        throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5592));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable parseTagAttributes(boolean nameIgnoreCase) throws JspParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            int ch;
            block17: {
                Mark mark;
                this.skipSpaces();
                ch = this.peekChar();
                if (ch == 62) {
                    return values;
                }
                if (ch == 45) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 45 && this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == 37) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == 47) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                    }
                    finally {
                        this.reset(mark);
                    }
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values, nameIgnoreCase);
        }
        throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5592));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable parseTagAttributes2() throws JspParseException {
        Hashtable values = new Hashtable(11);
        while (true) {
            int ch;
            block17: {
                Mark mark;
                this.skipSpaces();
                ch = this.peekChar();
                if (ch == 62) {
                    return values;
                }
                if (ch == 45) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 45 && this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == 37) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (ch == 47) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            Hashtable hashtable = values;
                            return hashtable;
                        }
                    }
                    finally {
                        this.reset(mark);
                    }
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue2(values);
        }
        throw new JspParseException(this.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5592));
    }

    static void refreshParamInfo(Hashtable into, String name, String value) {
        String[] oldval = (String[])into.get(name);
        if (oldval == null) {
            String[] newval = new String[]{value};
            into.put(name, newval);
        } else {
            String[] newval = new String[oldval.length + 1];
            System.arraycopy(oldval, 0, newval, 0, oldval.length);
            newval[oldval.length] = value;
            into.put(name, newval);
        }
    }

    private boolean isDelimiter() {
        if (!this.isSpace()) {
            int ch = this.peekChar();
            if (ch == 61 || ch == 62 || ch == 34 || ch == 39 || ch == 47) {
                return true;
            }
            if (ch == 45) {
                Mark mark = this.mark();
                ch = this.nextChar();
                if (ch == 62 || ch == 45 && this.nextChar() == 62) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    class IncludeState {
        Mark current;
        char[] stream = null;
        boolean jspDocument;
        Element documentElement;

        void restore() {
            JspReader.this.current = this.current;
            JspReader.this.stream = this.stream;
            JspReader.this.jspDocument = this.jspDocument;
            JspReader.this.documentElement = this.documentElement;
        }

        IncludeState() {
            this.current = JspReader.this.current;
            this.stream = JspReader.this.stream;
            this.jspDocument = JspReader.this.jspDocument;
            this.documentElement = JspReader.this.documentElement;
            JspReader.this.documentElement = null;
        }
    }
}

