/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.servlet.jsp.JspEngineException;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer5_4;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JspUtil {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.jsp");
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String OPEN_EXPR_2 = "<jsp:expression>";
    private static final String CLOSE_EXPR_2 = "</jsp:expression>";
    private static final String XML_OPEN_EXPR = "%=";
    private static final String XML_CLOSE_EXPR = "%";

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%' && chars[i + 1] == '\\' && chars[i + 2] == '>') {
                caw.write(37);
                caw.write(62);
                i += 2;
                continue;
            }
            caw.write(chars[i]);
        }
        return caw.toCharArray();
    }

    public static char[] addQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"' || chars[i] == '\\') {
                caw.write(92);
            }
            caw.write(chars[i]);
        }
        return caw.toCharArray();
    }

    public static String addQuotes(String s) {
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\"' || s.charAt(i) == '\\') {
                caw.write(92);
            } else if (s.charAt(i) == '\n') continue;
            caw.write(s.charAt(i));
        }
        return caw.toString();
    }

    public static String removeQuotation(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(s.trim());
        if (sb.charAt(0) == '\"') {
            sb.deleteCharAt(0);
        }
        if (sb.charAt(sb.length() - 1) == '\"') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String addQuotation(String s) {
        if (s == null) {
            return "";
        }
        char[] chars = s.toCharArray();
        int starting = 0;
        int limit = chars.length;
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        block7: for (int i = starting; i < limit; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\r': {
                    if (i + 1 != limit && chars[i + 1] == '\n') continue block7;
                    sb.append("\\r\\n");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\r\\n");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static boolean isExpression(String token, boolean isJspDocument) {
        return isJspDocument ? token.startsWith(XML_OPEN_EXPR) && token.endsWith(XML_CLOSE_EXPR) : token.startsWith(OPEN_EXPR) || token.startsWith(OPEN_EXPR_2) && (token.endsWith(CLOSE_EXPR) || token.endsWith(CLOSE_EXPR_2));
    }

    public static String getExprString(String page, boolean isJspDocument) {
        StringBuffer pageStr = new StringBuffer();
        StringTokenizer st = new StringTokenizer(page, "&");
        pageStr.append("\"");
        while (st.hasMoreTokens()) {
            int idxBegin;
            String closeExpr;
            String openExpr;
            String token = st.nextToken();
            if (token.indexOf(OPEN_EXPR_2) > 0) {
                openExpr = OPEN_EXPR_2;
                closeExpr = CLOSE_EXPR_2;
            } else {
                openExpr = OPEN_EXPR;
                closeExpr = CLOSE_EXPR;
            }
            while ((idxBegin = token.indexOf(openExpr)) >= 0) {
                pageStr.append(token.substring(0, idxBegin));
                token = token.substring(idxBegin);
                idxBegin = token.indexOf(closeExpr);
                pageStr.append("\" + (" + JspUtil.getExpr(token.substring(0, idxBegin + closeExpr.length()), isJspDocument) + ") + \"");
                token = token.substring(idxBegin + closeExpr.length());
            }
            pageStr.append(token);
            if (!st.hasMoreTokens()) continue;
            pageStr.append("&");
        }
        pageStr.append("\"");
        return pageStr.toString();
    }

    public static String getExpr(String expression, boolean isJspDocument) {
        String returnString = "";
        if (isJspDocument) {
            if (expression.startsWith(XML_OPEN_EXPR)) {
                returnString = expression.substring(XML_OPEN_EXPR.length());
            }
            int length = returnString.length();
            if (expression.endsWith(XML_CLOSE_EXPR)) {
                returnString = returnString.substring(0, length - XML_CLOSE_EXPR.length());
            }
        } else {
            if (expression.startsWith(OPEN_EXPR)) {
                returnString = expression.substring(OPEN_EXPR.length());
            } else if (expression.startsWith(OPEN_EXPR_2)) {
                returnString = expression.substring(OPEN_EXPR_2.length());
            }
            int length = returnString.length();
            if (expression.endsWith(CLOSE_EXPR)) {
                returnString = returnString.substring(0, length - CLOSE_EXPR.length());
            } else if (expression.endsWith(CLOSE_EXPR_2)) {
                returnString = returnString.substring(0, length - CLOSE_EXPR_2.length());
            }
        }
        return returnString;
    }

    public static Document parseXMLDoc(InputStream in, boolean validating) throws JspEngineException {
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactoryImpl.newInstance();
        dbf.setValidating(validating);
        dbf.setNamespaceAware(false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(in);
        }
        catch (SAXException sx) {
            sx.printStackTrace();
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5595, (Object)sx.getMessage()));
        }
        catch (IOException io) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5596, (Object)io.getMessage()), io);
        }
        catch (Exception ex) {
            throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5595, (Object)ex.getMessage()), ex);
        }
        return doc;
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "&;`'\"|*?~<>^()[]{}$\\\n";
        for (int index = 0; index < unescString.length(); ++index) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = escString + "\\";
            }
            escString = escString + nextChar;
        }
        return escString;
    }

    static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                b.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                b.append('\\').append('r');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String trim(String input) {
        if (input == null || input.equals("")) {
            return input;
        }
        String output = input.trim();
        while (output.length() > 0) {
            if (output.startsWith("\n") || output.startsWith("\r")) {
                output = output.substring(1);
                continue;
            }
            if (!output.endsWith("\n") && !output.endsWith("\r")) break;
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    public static String trimTrailingSpace(String input) {
        int len;
        if (input == null || input.equals("")) {
            return input;
        }
        char[] val = input.toCharArray();
        for (len = val.length; len > 0 && val[len - 1] == ' '; --len) {
        }
        return len < val.length ? input.substring(0, len) : input;
    }
}

