/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import jeus.servlet.jsp.compiler.Mark;

public class ServletWriter {
    public static int TAB_WIDTH = 2;
    public static String SPACES = "                              ";
    int indent = 0;
    int indent2 = 0;
    PrintWriter writer;

    public ServletWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void pushIndent() {
        this.indent2 += TAB_WIDTH;
        this.indent = this.indent2 > SPACES.length() ? SPACES.length() : this.indent2;
    }

    public void popIndent() {
        this.indent2 -= TAB_WIDTH;
        if (this.indent2 > SPACES.length()) {
            this.indent = SPACES.length();
        } else if (this.indent2 <= 0) {
            this.indent2 = 0;
            this.indent = 0;
        } else {
            this.indent = this.indent2;
        }
    }

    public void printComment(Mark start, Mark stop, char[] chars) {
        if (start != null && stop != null) {
            this.println("// from=" + start);
            this.println("//   to=" + stop);
        }
        if (chars != null) {
            int i = 0;
            while (i < chars.length) {
                this.indent();
                this.print("// ");
                while (chars[i] != '\n' && i < chars.length) {
                    this.writer.print(chars[i++]);
                }
            }
        }
    }

    public static String quoteString(String s) {
        if (s == null) {
            return "null";
        }
        if (s.indexOf(34) < 0 && s.indexOf(92) < 0 && s.indexOf(10) < 0 && s.indexOf(13) < 0) {
            return "\"" + s + "\"";
        }
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                sb.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                sb.append('\\').append('r');
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    public void printlnNoIndent(String line) {
        this.writer.println(line);
    }

    public void println(String line) {
        this.writer.println(SPACES.substring(0, this.indent) + line);
    }

    public void println() {
        this.writer.println("");
    }

    public void indent() {
        this.writer.print(SPACES.substring(0, this.indent));
    }

    public void print(String s) {
        this.writer.print(s);
    }

    public void printMultiLn(String multiline) {
        BufferedReader reader = new BufferedReader(new StringReader(multiline));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.println(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

