/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.Attribute;
import jeus.servlet.jsp.compiler.BeanCache;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.ExpressionEvaluatorParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.JspAttribute;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspUtil;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.JspattributeParser;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.StringAttribute;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class SetPropertyParser
extends Parser {
    private static final String OPEN_SETPROPERTY = "<jsp:setProperty";
    private static final String OPEN_SETPROPERTY_CLOSE = ">";
    private static final String CLOSE_SETPROPERTY = "/>";
    private static final String CLOSE_SETPROPERTY2 = "</jsp:setProperty>";
    private static final String[] validAttributes = new String[]{"name", "property", "value", "param"};

    SetPropertyParser() {
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        boolean isJspDocument;
        boolean bl = isJspDocument = xmlViewer == null;
        if (reader.matches(OPEN_SETPROPERTY)) {
            parser.flushCharData();
            Mark start = reader.mark();
            reader.advance(OPEN_SETPROPERTY.length());
            Hashtable attrs = reader.parseTagAttributes();
            reader.skipSpaces();
            if (!reader.matches(CLOSE_SETPROPERTY)) {
                if (!reader.matches(OPEN_SETPROPERTY_CLOSE)) {
                    throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:setProperty>"));
                }
                reader.advance(OPEN_SETPROPERTY_CLOSE.length());
                SetPropertyJspAttributeInfo rtmap = new SetPropertyJspAttributeInfo();
                Attribute jspAttribute = null;
                while ((jspAttribute = JspattributeParser.parse(xmlViewer, reader, parser, codeGen, this, rtmap)) != null) {
                    attrs.put(jspAttribute.attributeName, jspAttribute);
                }
                Mark m = reader.mark();
                if (reader.skipUntil(CLOSE_SETPROPERTY2.toLowerCase()) == null) {
                    throw new JspParseException(m, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)"<jsp:setProperty>"));
                }
            } else {
                reader.advance(CLOSE_SETPROPERTY.length());
            }
            JspParser.checkAttributes("setProperty", attrs.keys(), validAttributes);
            Mark stop = reader.mark();
            parser.flushCharData();
            if (!isJspDocument) {
                xmlViewer.addSetProperty(reader, start, stop);
            }
            BeanCache beanInfo = codeGen.getBeanCache();
            SetPropertyGenerator gen = new SetPropertyGenerator(attrs, beanInfo, start, stop, isJspDocument, codeGen);
            codeGen.addGenerator(gen, "ServiceMethodPhase");
            return true;
        }
        return false;
    }

    class SetPropertyGenerator
    extends Generator {
        Hashtable attrs;
        BeanCache beanInfo;
        boolean isJspDocument;
        private String elIgnore;
        private CodeGenerator codeGen;

        public SetPropertyGenerator(Hashtable attrs, BeanCache beanInfo, Mark start, Mark stop, boolean isJspDocument, CodeGenerator codeGen) {
            this.start = start;
            this.stop = stop;
            this.attrs = attrs;
            this.beanInfo = beanInfo;
            this.isJspDocument = isJspDocument;
            this.codeGen = codeGen;
            this.elIgnore = codeGen.isELIgnored;
        }

        public boolean generate(ServletWriter writer, String phase) throws JspEngineException {
            Object o = this.getAttribute("value");
            boolean valueIsJspAttribute = o != null && o instanceof JspAttribute;
            this.processAttribute(writer);
            String name = (String)this.getAttribute("name");
            String property = (String)this.getAttribute("property");
            String param = (String)this.getAttribute("param");
            String value = (String)this.getAttribute("value");
            if (!this.beanInfo.checkVariable(name)) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5606, (Object)name));
            }
            if (property.equals("*")) {
                writer.println("jeus.servlet.jsp.JspMethodProxy.setProperty( pageContext.findAttribute(\"" + name + "\"), request);");
            } else if (value == null) {
                if (param == null) {
                    param = property;
                }
                writer.println("jeus.servlet.jsp.JspMethodProxy.setProperty( pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", request, \"" + param + "\");");
            } else if (valueIsJspAttribute) {
                writer.println("jeus.servlet.jsp.JspMethodProxy.setProperty2( pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", \"" + value + "\");");
            } else if (JspUtil.isExpression(value, this.isJspDocument)) {
                writer.println("jeus.servlet.jsp.JspMethodProxy.setProperty2( pageContext.findAttribute(\"" + name + "\"), \"" + property + "\"," + JspUtil.getExpr(value, this.isJspDocument) + ");");
            } else if (ExpressionEvaluatorParser.checkEL(value, this.elIgnore)) {
                writer.println("jeus.servlet.jsp.JspRuntimeLibrary.handleSetPropertyExpression( pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", \"" + value + "\", pageContext, null);");
            } else {
                writer.println("jeus.servlet.jsp.JspMethodProxy.setProperty( pageContext.findAttribute(\"" + name + "\"), \"" + property + "\", \"" + JspUtil.escape(value) + "\");");
            }
            return true;
        }

        private void processAttribute(ServletWriter writer) throws JspEngineException {
            if (this.attrs == null) {
                return;
            }
            Hashtable attrs0 = (Hashtable)this.attrs.clone();
            Enumeration enum1 = attrs0.keys();
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                Object value = attrs0.get(key);
                if (value instanceof StringAttribute) {
                    value = ((StringAttribute)value).getAttributeValue();
                    this.attrs.put(key, value);
                    continue;
                }
                if (!(value instanceof JspAttribute)) continue;
                JspAttribute attr = (JspAttribute)value;
                attr.generate(writer, this.codeGen, CodeGenerator.getPageContextName(this.parent), null);
                value = attr.variableName;
                this.attrs.put(key, value);
            }
        }

        public Object getAttribute(String name) {
            return this.attrs != null ? this.attrs.get(name) : null;
        }
    }

    private class SetPropertyJspAttributeInfo
    implements JspattributeParser.JspAttributeInfo {
        private SetPropertyJspAttributeInfo() {
        }

        public boolean isRTExprAttribute(String attrname) {
            return attrname.equalsIgnoreCase("value");
        }

        public boolean isEnableScript(String attrname) {
            return true;
        }

        public boolean isJspFragment(String attrname) {
            return false;
        }
    }
}

