/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Hashtable;
import java.util.Vector;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.servlet.property.WebProperties;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class TagFileAttributeDirectiveParser
extends Parser {
    private static final String OPEN_DIRECTIVE = "<%@";
    private static final String CLOSE_DIRECTIVE = "%>";
    public static final String DIRECTIVE = "attribute";
    private static final String[] validAttributes = new String[]{"description", "name", "required", "fragment", "rtexprvalue", "type"};

    public TagFileAttributeDirectiveParser() {
    }

    public TagFileAttributeDirectiveParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!reader.matches(OPEN_DIRECTIVE)) {
            return false;
        }
        Mark start = reader.mark();
        reader.advance(OPEN_DIRECTIVE.length());
        reader.skipSpaces();
        String match = null;
        if (reader.matches(DIRECTIVE)) {
            match = DIRECTIVE;
        }
        if (match == null) {
            reader.reset(start);
            return false;
        }
        reader.advance(match.length());
        if (this.isInvalidated) {
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5213));
        }
        Hashtable attrs = reader.parseTagAttributes2();
        JspParser.checkAttributes("AttributeDirective", attrs.keys(), validAttributes);
        if (WebProperties.J2EE_COMPATIBLE.value) {
            this.checkAttributes(attrs);
        }
        reader.skipSpaces();
        if (!reader.matches(CLOSE_DIRECTIVE)) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5570));
        }
        reader.advance(CLOSE_DIRECTIVE.length());
        Mark stop = reader.mark();
        xmlViewer.addDirective(match, attrs);
        codeGen.handleDirective(DIRECTIVE, start, stop, attrs);
        return true;
    }

    private void checkAttributes(Hashtable attrs) throws JspEngineException {
        Vector fragAttrV = (Vector)attrs.get("fragment");
        String fragAttr = null;
        if (fragAttrV != null && fragAttrV.size() > 0) {
            fragAttr = (String)fragAttrV.get(0);
        }
        if (fragAttr != null && fragAttr.equalsIgnoreCase("true")) {
            Object typeAttr = attrs.get("type");
            if (typeAttr != null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)"type"));
            }
            Object rtAttr = attrs.get("rtexprvalue");
            if (rtAttr != null) {
                throw new JspEngineException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5681, (Object)"rtexprvalue"));
            }
        }
    }
}

