/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class TagFileDirectiveParser
extends Parser {
    private static final String OPEN_DIRECTIVE = "<%@";
    private static final String CLOSE_DIRECTIVE = "%>";
    static final String[] directives = new String[]{"taglib", "include", "tag", "attribute", "variable"};
    private static final String[] validAttributes = new String[]{"display-name", "body-content", "dynamic-attributes", "small-icon", "large-icon", "description", "example", "language", "import", "pageEncoding", "isELIgnored", "name", "required", "fragment", "rtexprvalue", "type", "name-given", "name-from-attribute", "alias", "variable-class", "declare", "scope", "file", "uri", "prefix", "tagdir"};

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!reader.matches(OPEN_DIRECTIVE)) {
            return false;
        }
        Mark start = reader.mark();
        reader.advance(OPEN_DIRECTIVE.length());
        reader.skipSpaces();
        String match = null;
        for (int i = 0; i < directives.length; ++i) {
            if (!reader.matches(directives[i])) continue;
            match = directives[i];
            break;
        }
        if (match != null) {
            reader.advance(match.length());
        } else {
            match = "page";
        }
        Hashtable attrs = reader.parseTagAttributes2();
        JspParser.checkAttributes("TagFile Directive", attrs.keys(), validAttributes);
        reader.skipSpaces();
        if (!reader.matches(CLOSE_DIRECTIVE)) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5570));
        }
        reader.advance(CLOSE_DIRECTIVE.length());
        Mark stop = reader.mark();
        xmlViewer.addDirective(match, attrs);
        codeGen.handleDirective(match, start, stop, attrs);
        return true;
    }
}

