/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.TagInfoData;
import jeus.servlet.jsp.compiler.TagFileClassHandler;
import jeus.servlet.jsp.compiler.TagLibraryInfoImpl;

public class TagFileInfoImpl
extends TagFileInfo {
    private String contextRealDocBase;
    private String taglibRelativePath;
    private TagFileClassHandler classHandler;
    private TagInfoData tagInfoData;

    public TagFileInfoImpl(String name, String path, TagInfo tagInfo, Context context, String taglibRelativePath) throws JspEngineException {
        super(name, path, tagInfo);
        this.contextRealDocBase = context.getDocBase();
        this.taglibRelativePath = taglibRelativePath;
        ServletManager servletManager = context.getServletManager();
        if (servletManager == null) {
            throw new JspEngineException("the servlet manager must be initialized");
        }
        this.classHandler = new TagFileClassHandler(servletManager.getJspEngine(), this, path, taglibRelativePath);
        this.createTagInfo();
    }

    private void createTagInfo() {
        String path = this.getPath();
        if (path.startsWith("/META-INF/tags")) {
            // empty if block
        }
    }

    public void checkHandlerClass(String _contentType) throws JspEngineException {
        this.classHandler.checkHandlerClass(_contentType);
    }

    public void setTagInfoData(TagInfoData info) {
        this.tagInfoData = info;
    }

    public TagInfoData getTagInfoData() {
        return this.tagInfoData;
    }

    public TagInfo getTagInfo(TagLibraryInfoImpl tli) {
        return new TagInfo(this.tagInfoData.tagName, this.tagInfoData.tagClassName, this.tagInfoData.bodyContent, this.tagInfoData.infoString, (TagLibraryInfo)tli, null, this.tagInfoData.attributeInfo, this.tagInfoData.displayName, this.tagInfoData.smallIcon, this.tagInfoData.largeIcon, this.tagInfoData.tvi, this.tagInfoData.dynamicAttributes);
    }

    public String getPathInfo() {
        return this.taglibRelativePath == null ? this.getPath() : this.taglibRelativePath + this.getPath();
    }

    public InputStream getInputStream() {
        String _path = this.getPath();
        if (_path == null) {
            return null;
        }
        if (_path.startsWith("/")) {
            _path = _path.substring(1);
        }
        if (this.taglibRelativePath != null && this.taglibRelativePath.endsWith(".jar")) {
            try {
                AbstractArchive arc = JarArchiveFactory.openArchiveStatic((String)(this.contextRealDocBase + this.taglibRelativePath));
                return arc.getEntry(_path);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            AbstractArchive arc = FileArchiveFactory.openArchiveStatic((String)this.contextRealDocBase);
            return arc.getEntry(_path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

