/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Hashtable;
import jeus.servlet.jsp.JspEngineException;
import jeus.servlet.jsp.compiler.CodeGenerator;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspParser;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.JspXmlViewer;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.Parser;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class TagFileVariableDirectiveParser
extends Parser {
    private static final String OPEN_DIRECTIVE = "<%@";
    private static final String CLOSE_DIRECTIVE = "%>";
    public static final String DIRECTIVE = "variable";
    private static final String[] validAttributes = new String[]{"name-given", "name-from-attribute", "alias", "variable-class", "declare", "scope", "description"};

    public TagFileVariableDirectiveParser() {
    }

    public TagFileVariableDirectiveParser(boolean _isInvalidated) {
        super(_isInvalidated);
    }

    public boolean accept(CodeGenerator codeGen, JspReader reader, JspParser parser, JspXmlViewer xmlViewer, Parser parentParser) throws JspEngineException {
        if (!reader.matches(OPEN_DIRECTIVE)) {
            return false;
        }
        Mark start = reader.mark();
        reader.advance(OPEN_DIRECTIVE.length());
        reader.skipSpaces();
        String match = null;
        if (reader.matches(DIRECTIVE)) {
            match = DIRECTIVE;
        }
        if (match == null) {
            reader.reset(start);
            return false;
        }
        reader.advance(match.length());
        if (this.isInvalidated) {
            throw new JspParseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5223));
        }
        Hashtable attrs = reader.parseTagAttributes2();
        JspParser.checkAttributes("AttributeDirective", attrs.keys(), validAttributes);
        reader.skipSpaces();
        if (!reader.matches(CLOSE_DIRECTIVE)) {
            throw new JspParseException(reader.mark(), ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5570));
        }
        reader.advance(CLOSE_DIRECTIVE.length());
        Mark stop = reader.mark();
        xmlViewer.addDirective(match, attrs);
        codeGen.handleDirective(DIRECTIVE, start, stop, attrs);
        return true;
    }
}

