/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import jeus.servlet.jsp.compiler.Checker;
import jeus.servlet.jsp.compiler.CustomTagParser;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.ScriptingVariableChecker;
import jeus.servlet.jsp.compiler.ScriptingVariableGroup;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.loader.JspReloader;

abstract class TagGenerator
extends Generator {
    private Hashtable tagVarNumbers;
    private ScriptingVariableChecker svChecker;
    private ScriptingVariableGroup group;
    private Stack tagOutStack;
    private Stack tagContentStack;

    protected TagGenerator(Stack outputStack, Stack contentStack, Hashtable table, ScriptingVariableChecker svChecker) {
        this.tagOutStack = outputStack;
        this.tagContentStack = contentStack;
        this.tagVarNumbers = table;
        this.svChecker = svChecker;
        this.group = svChecker.getMyGroup();
    }

    protected String getOutName() {
        return (String)this.tagOutStack.peek();
    }

    protected void pushOutName(String out) {
        this.tagOutStack.push(out);
    }

    protected void popOutName() {
        this.tagOutStack.pop();
    }

    protected String getContentName() {
        return (String)this.tagContentStack.peek();
    }

    protected void pushContentName(String content) {
        this.tagContentStack.push(content);
    }

    protected void popContentName() {
        this.tagContentStack.pop();
    }

    protected CustomTagParser.TagBeginGenerator getParentTag() {
        Generator gen = this.parent;
        while (gen != null) {
            if (gen instanceof CustomTagParser.TagBeginGenerator) {
                return (CustomTagParser.TagBeginGenerator)gen;
            }
            gen = gen.parent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTagVarName(String prefix, String shortTagName) {
        Hashtable hashtable = this.tagVarNumbers;
        synchronized (hashtable) {
            String tag = prefix + ":" + shortTagName;
            String prefix2 = JspReloader.convertSpecialCharacter(prefix);
            String shortTagName2 = JspReloader.convertSpecialCharacter(shortTagName);
            String varName = prefix2 + "_" + shortTagName2 + "_";
            if (this.tagVarNumbers.get(tag) != null) {
                Integer i = (Integer)this.tagVarNumbers.get(tag);
                varName = varName + i;
                this.tagVarNumbers.put(tag, new Integer(i + 1));
                return varName;
            }
            this.tagVarNumbers.put(tag, new Integer(1));
            return varName + "0";
        }
    }

    protected void declareVariables(ServletWriter writer, VariableInfo[] vi, TagVariableInfo[] tvi, boolean declare, boolean update, int scope, Checker braceCheck, Checker customTagCheck) {
        block6: {
            block5: {
                if (tvi == null || tvi.length <= 0) break block5;
                for (int i = 0; i < tvi.length; ++i) {
                    if (tvi[i].getScope() != scope) continue;
                    String varName = tvi[i].getNameGiven();
                    if (varName == null || varName == "") {
                        varName = tvi[i].getNameFromAttribute();
                    }
                    if (tvi[i].getDeclare() && declare && this.group.isDeclarable(varName, tvi[i].getScope(), braceCheck, customTagCheck)) {
                        writer.println(tvi[i].getClassName() + " " + varName + " = null;");
                    }
                    if (!update) continue;
                    writer.println(varName + " = (" + tvi[i].getClassName() + ") pageContext.findAttribute(" + ServletWriter.quoteString(varName) + ");");
                }
                break block6;
            }
            if (vi == null || vi.length <= 0) break block6;
            for (int i = 0; i < vi.length; ++i) {
                if (vi[i].getScope() != scope) continue;
                if (vi[i].getDeclare() && declare && this.group.isDeclarable(vi[i].getVarName(), vi[i].getScope(), braceCheck, customTagCheck)) {
                    writer.println(vi[i].getClassName() + " " + vi[i].getVarName() + " = null;");
                }
                if (!update) continue;
                writer.println(vi[i].getVarName() + " = (" + vi[i].getClassName() + ") pageContext.findAttribute(" + ServletWriter.quoteString(vi[i].getVarName()) + ");");
            }
        }
    }

    static class TagVariableData {
        String tagHandlerInstanceName;
        String tagEvalVarName;
        boolean isImplementsSimpleTag;

        TagVariableData(String tagHandlerInstanceName, String tagEvalVarName, boolean isImplementsSimpleTag) {
            this.tagHandlerInstanceName = tagHandlerInstanceName;
            this.tagEvalVarName = tagEvalVarName;
            this.isImplementsSimpleTag = isImplementsSimpleTag;
        }
    }
}

