/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.util.Stack;
import jeus.servlet.jsp.compiler.Generator;
import jeus.servlet.jsp.compiler.Mark;
import jeus.servlet.jsp.compiler.ServletWriter;
import jeus.servlet.jsp.compiler.TrimEnable;

public class VariableCharDataGenerator
extends Generator
implements TrimEnable {
    public static final int ONE_WRITE_LIMIT = 4096;
    private boolean isTextPlain;
    String variable;
    String contents;
    int limit;
    int starting;
    private Stack outStack;
    private char[] chars;

    public VariableCharDataGenerator(String variable, char[] chars, Mark start, Mark stop, int limit, int starting, Stack outStack) {
        this.isTextPlain = false;
        this.limit = limit;
        this.starting = starting;
        this.variable = variable;
        this.contents = null;
        this.chars = chars;
        this.start = start;
        this.stop = stop;
        this.outStack = outStack;
    }

    public VariableCharDataGenerator(String variable, char[] chars, Mark start, Mark stop, int limit, int starting, boolean isTextPlain, Stack outStack) {
        this.limit = limit;
        this.starting = starting;
        this.variable = variable;
        this.start = start;
        this.stop = stop;
        this.outStack = outStack;
        this.isTextPlain = isTextPlain;
        this.contents = null;
        this.chars = chars;
    }

    public void generate(StringBuffer buf) {
        buf.append(this.chars);
    }

    public boolean generate(ServletWriter writer, String phase) {
        if ("TemplateStringDeclarationPhase".equals(phase)) {
            return this.declareBlock(writer);
        }
        if ("ServiceMethodPhase".equals(phase)) {
            return this.writeBlock(writer);
        }
        return false;
    }

    public void forwardTrim() {
        if (this.chars == null || this.chars.length == 0) {
            return;
        }
        for (int i = this.starting; i < this.limit && Character.isWhitespace(this.chars[i]); ++i) {
            ++this.starting;
        }
    }

    public void backwardTrim() {
        if (this.chars == null || this.chars.length == 0) {
            return;
        }
        for (int i = this.limit - 1; i >= this.starting && Character.isWhitespace(this.chars[i]); --i) {
            --this.limit;
        }
    }

    private boolean declareBlock(ServletWriter writer) {
        if (this.isObsolete()) {
            return false;
        }
        String cont = this.getContents();
        if (cont != null) {
            writer.indent();
            writer.print("private final static String " + this.variable + " = \"" + cont + "\";");
            return true;
        }
        return false;
    }

    private boolean writeBlock(ServletWriter writer) {
        if (this.isObsolete()) {
            return false;
        }
        String cont = this.getContents();
        if (cont != null) {
            writer.indent();
            String outputName = "out";
            if (this.outStack != null && this.outStack.size() != 0) {
                outputName = (String)this.outStack.peek();
            }
            writer.print(outputName + ".write(" + this.variable + ");");
            return true;
        }
        return false;
    }

    private String getContents() {
        if (this.chars == null || this.chars.length == 0 || this.contents != null) {
            return this.contents;
        }
        StringBuffer sb = new StringBuffer();
        block7: for (int i = this.starting; i < this.limit; ++i) {
            char ch = this.chars[i];
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\r': {
                    if (i + 1 != this.limit && this.chars[i + 1] == '\n') continue block7;
                    sb.append("\\r\\n");
                    continue block7;
                }
                case '\n': {
                    if (this.isTextPlain) {
                        sb.append("\\n");
                        continue block7;
                    }
                    sb.append("\\r\\n");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }
}

