/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler;

import java.io.CharArrayWriter;
import jeus.servlet.jsp.compiler.JspParseException;
import jeus.servlet.jsp.compiler.JspReader;
import jeus.servlet.jsp.compiler.Mark;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5;
import jeus.util.message.JeusMessage_WebContainer5_4;

final class XmlCdataProcessor {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private JspReader reader;
    private String open;
    private String close;

    XmlCdataProcessor(JspReader reader, String open, String close) {
        this.reader = reader;
        this.open = open;
        this.close = close;
    }

    char[] process() throws JspParseException {
        CharArrayWriter caw = new CharArrayWriter();
        Mark start = this.reader.mark();
        while (true) {
            if (this.reader.matches(CDATA_START)) {
                this.reader.advance(CDATA_START.length());
                this.processCdata(caw);
                continue;
            }
            if (this.reader.matches(this.close)) break;
            if (this.reader.matches("<jsp:scriptlet")) {
                throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5._5225));
            }
            int ch = this.reader.nextChar();
            if (ch < 0) {
                throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)this.open));
            }
            caw.write(ch);
        }
        this.reader.advance(this.close.length());
        return caw.toCharArray();
    }

    private void processCdata(CharArrayWriter caw) throws JspParseException {
        Mark start = this.reader.mark();
        while (true) {
            if (this.reader.matches(CDATA_END)) {
                this.reader.advance(CDATA_END.length());
                return;
            }
            int ch = this.reader.nextChar();
            if (ch < 0) {
                throw new JspParseException(start, ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5571, (Object)CDATA_START));
            }
            caw.write(ch);
        }
    }
}

