/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.compiler.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletException;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.engine.Context;
import jeus.servlet.engine.ServletManager;
import jeus.servlet.engine.VirtualHost;
import jeus.servlet.jsp.JspServletWrapper;
import jeus.servlet.jsp.compiler.JspCompileException;
import jeus.servlet.jsp.compiler.batch.BatchCompiler;
import jeus.servlet.jsp.compiler.batch.CompileRequest;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer5_4;

public class CompileContext
extends Context {
    private Vector compileList = new Vector();

    public CompileContext(VirtualHost vhost, ContextDescriptor desc, boolean isWebAdmin) throws StartingException {
        super(vhost, desc, isWebAdmin);
    }

    int prepareCompile(String root) {
        this.compileList.clear();
        Set set = this.getResourcePathsAll(root);
        if (set == null) {
            return 0;
        }
        Object[] totalList = set.toArray();
        for (int i = 0; i < totalList.length; ++i) {
            String _extension;
            int pos;
            String uri = (String)totalList[i];
            if (uri == null || (pos = uri.lastIndexOf(".")) <= 0 || ServletManager.JSP_EXTENSION.get(_extension = uri.substring(pos)) == null) continue;
            this.compileList.add(uri);
        }
        return this.compileList.size();
    }

    int prepareCompile(File listFile) {
        this.compileList.clear();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(listFile));
            while ((line = reader.readLine()) != null) {
                String _extension;
                int pos = (line = line.trim()).lastIndexOf(".");
                if (pos <= 0 || ServletManager.JSP_EXTENSION.get(_extension = line.substring(pos)) == null) continue;
                this.compileList.add(line);
            }
        }
        catch (Exception e) {
            System.out.println(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5670, (Object[])new Object[]{listFile, e}));
            this.compileList.clear();
            return -1;
        }
        return this.compileList.size();
    }

    int preCompile(int totalCount, int countStart, Vector successList, Vector failList, boolean samename) {
        DecimalFormat numFormat = new DecimalFormat("###%");
        ClassLoader prev = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContextLoader());
        int size = this.compileList.size();
        for (int i = 0; i < size; ++i) {
            String uri = null;
            String countStat = null;
            try {
                ServletManager servletManager;
                String jspuri;
                uri = (String)this.compileList.elementAt(i);
                double percent = (double)(countStart + i + 1) / (double)totalCount;
                countStat = " [" + numFormat.format(percent) + "]";
                System.out.print(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer5_4._5660, (Object[])new String[]{this.getContextName(), uri}));
                String ctxPath = this.getContextPath();
                if (ctxPath.equals("/")) {
                    ctxPath = "";
                }
                CompileRequest compileRequest = new CompileRequest(this.getVirtualHost().getContextGroup(), this, ctxPath + uri);
                this.getServletByPath(compileRequest);
                String jspName = jspuri = compileRequest.getServletPath();
                if (JspServletWrapper.FILENAME_IGNORECASE && !samename) {
                    jspName = jspuri.toLowerCase();
                }
                if ((servletManager = this.getServletManager()) == null) {
                    throw new Exception("the servlet manager must be initialized");
                }
                JspServletWrapper wrapper = servletManager.addJsp(jspName, jspuri, null, samename);
                wrapper.batchCompile(compileRequest);
                successList.add(uri);
                System.out.println(" OK " + countStat);
                continue;
            }
            catch (Throwable t) {
                System.out.println(" FAIL " + countStat);
                if (t instanceof JspCompileException) {
                    System.out.println(t.getMessage());
                } else {
                    t.printStackTrace(System.out);
                    if (t instanceof ServletException) {
                        System.out.println("[RootCause] : ");
                        Throwable tt = ((ServletException)t).getRootCause();
                        if (tt != null) {
                            tt.printStackTrace(System.out);
                        }
                    }
                }
                failList.add(uri);
                if (!BatchCompiler.EXIT_ON_ERROR) continue;
                System.exit(1);
            }
        }
        Thread.currentThread().setContextClassLoader(prev);
        return size;
    }
}

