/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.jsp.el;

import java.math.BigDecimal;
import javax.servlet.jsp.el.ELException;
import jeus.servlet.jsp.el.BinaryOperator;
import jeus.servlet.jsp.el.Coercions;
import jeus.servlet.jsp.el.ExceptionHandler;
import jeus.servlet.jsp.el.Logger;
import jeus.servlet.jsp.el.PrimitiveObjects;
import jeus.util.message.JeusMessage_WebContainer6;

public class DivideOperator
extends BinaryOperator {
    public static final DivideOperator SINGLETON = new DivideOperator();

    public String getOperatorSymbol() {
        return "/";
    }

    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (logger.isLoggable(JeusMessage_WebContainer6._6027_LEVEL)) {
                logger.log(JeusMessage_WebContainer6._6027_LEVEL, JeusMessage_WebContainer6._6027, (Object)this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(pLeft) || Coercions.isBigInteger(pLeft) || Coercions.isBigDecimal(pRight) || Coercions.isBigInteger(pRight)) {
            BigDecimal left = (BigDecimal)Coercions.coerceToPrimitiveNumber(pLeft, BigDecimal.class, pLogger);
            BigDecimal right = (BigDecimal)Coercions.coerceToPrimitiveNumber(pRight, BigDecimal.class, pLogger);
            try {
                return left.divide(right, 4);
            }
            catch (Exception exc) {
                ExceptionHandler.handle(JeusMessage_WebContainer6._6029, new Object[]{this.getOperatorSymbol(), "" + left, "" + right});
                return PrimitiveObjects.getInteger(0);
            }
        }
        double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
        double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
        try {
            return PrimitiveObjects.getDouble(left / right);
        }
        catch (Exception exc) {
            ExceptionHandler.handle(JeusMessage_WebContainer6._6029, new Object[]{this.getOperatorSymbol(), "" + left, "" + right});
            return PrimitiveObjects.getInteger(0);
        }
    }
}

